/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.BufferArrayGrouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.GrouperTestUtil;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.TestColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.junit.Assert;
import org.junit.Test;

public class BufferArrayGrouperTest {
    @Test
    public void testAggregate() {
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        BufferArrayGrouper grouper = this.newGrouper(columnSelectorFactory, 1024);
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        grouper.aggregate(12);
        grouper.aggregate(6);
        grouper.aggregate(10);
        grouper.aggregate(6);
        grouper.aggregate(12);
        grouper.aggregate(6);
        ImmutableList expected = ImmutableList.of((Object)new Grouper.Entry((Object)6, new Object[]{30L, 3L}), (Object)new Grouper.Entry((Object)10, new Object[]{10L, 1L}), (Object)new Grouper.Entry((Object)12, new Object[]{20L, 2L}));
        ArrayList unsortedEntries = Lists.newArrayList((Iterator)grouper.iterator(false));
        Assert.assertEquals((Object)expected, (Object)Ordering.from((o1, o2) -> Ints.compare((int)((Integer)o1.getKey()), (int)((Integer)o2.getKey()))).sortedCopy((Iterable)unsortedEntries));
    }

    private BufferArrayGrouper newGrouper(TestColumnSelectorFactory columnSelectorFactory, int bufferSize) {
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        BufferArrayGrouper grouper = new BufferArrayGrouper(Suppliers.ofInstance((Object)buffer), (ColumnSelectorFactory)columnSelectorFactory, new AggregatorFactory[]{new LongSumAggregatorFactory("valueSum", "value"), new CountAggregatorFactory("count")}, 1000);
        grouper.init();
        return grouper;
    }
}

