/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.collections.BlockingPool;
import org.apache.hive.druid.io.druid.collections.DefaultBlockingPool;
import org.apache.hive.druid.io.druid.collections.NonBlockingPool;
import org.apache.hive.druid.io.druid.collections.ReferenceCountingResourceHolder;
import org.apache.hive.druid.io.druid.collections.StupidPool;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.DruidProcessingConfig;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryDataSource;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryEngine;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.groupby.strategy.GroupByStrategySelector;
import org.apache.hive.druid.io.druid.query.groupby.strategy.GroupByStrategyV1;
import org.apache.hive.druid.io.druid.query.groupby.strategy.GroupByStrategyV2;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GroupByQueryMergeBufferTest {
    private static final long TIMEOUT = 5000L;
    public static final DruidProcessingConfig PROCESSING_CONFIG = new DruidProcessingConfig(){

        public String getFormatString() {
            return null;
        }

        public int intermediateComputeSizeBytes() {
            return 0xA00000;
        }

        public int getNumMergeBuffers() {
            return 3;
        }

        public int getNumThreads() {
            return 1;
        }
    };
    private static final TestBlockingPool mergeBufferPool = new TestBlockingPool(new Supplier<ByteBuffer>(){

        public ByteBuffer get() {
            return ByteBuffer.allocateDirect(PROCESSING_CONFIG.intermediateComputeSizeBytes());
        }
    }, PROCESSING_CONFIG.getNumMergeBuffers());
    private static final GroupByQueryRunnerFactory factory = GroupByQueryMergeBufferTest.makeQueryRunnerFactory(GroupByQueryRunnerTest.DEFAULT_MAPPER, new GroupByQueryConfig(){

        public String getDefaultStrategy() {
            return "v2";
        }
    });
    private QueryRunner<Row> runner;

    private static GroupByQueryRunnerFactory makeQueryRunnerFactory(ObjectMapper mapper, GroupByQueryConfig config) {
        Supplier configSupplier = Suppliers.ofInstance((Object)config);
        StupidPool bufferPool = new StupidPool("GroupByQueryEngine-bufferPool", (Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocateDirect(PROCESSING_CONFIG.intermediateComputeSizeBytes());
            }
        });
        GroupByStrategySelector strategySelector = new GroupByStrategySelector(configSupplier, new GroupByStrategyV1(configSupplier, new GroupByQueryEngine(configSupplier, (NonBlockingPool)bufferPool), QueryRunnerTestHelper.NOOP_QUERYWATCHER, (NonBlockingPool)bufferPool), new GroupByStrategyV2(PROCESSING_CONFIG, configSupplier, (NonBlockingPool)bufferPool, (BlockingPool)mergeBufferPool, mapper, QueryRunnerTestHelper.NOOP_QUERYWATCHER));
        GroupByQueryQueryToolChest toolChest = new GroupByQueryQueryToolChest(strategySelector, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator());
        return new GroupByQueryRunnerFactory(strategySelector, toolChest);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> constructorFeeder() throws IOException {
        ArrayList args = Lists.newArrayList();
        for (QueryRunner runner : QueryRunnerTestHelper.makeQueryRunners(factory)) {
            args.add(new Object[]{runner});
        }
        return args;
    }

    public GroupByQueryMergeBufferTest(QueryRunner<Row> runner) {
        this.runner = factory.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), (Iterable)ImmutableList.of(runner));
    }

    @Before
    public void setup() {
        mergeBufferPool.resetMinRemainBufferNum();
    }

    @Test
    public void testSimpleGroupBy() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")})).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)5000L)).build();
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)factory, this.runner, query);
        Assert.assertEquals((long)2L, (long)mergeBufferPool.getMinRemainBufferNum());
        Assert.assertEquals((long)3L, (long)mergeBufferPool.getPoolSize());
    }

    @Test
    public void testNestedGroupBy() {
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.firstToThird).setGranularity(Granularities.ALL).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build())).setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")})).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)5000L)).build();
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)factory, this.runner, query);
        Assert.assertEquals((long)1L, (long)mergeBufferPool.getMinRemainBufferNum());
        Assert.assertEquals((long)3L, (long)mergeBufferPool.getPoolSize());
    }

    @Test
    public void testDoubleNestedGroupBy() {
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.firstToThird).setGranularity(Granularities.ALL).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", null)})).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build()).setInterval(QueryRunnerTestHelper.firstToThird).setGranularity(Granularities.ALL).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build())).setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")})).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)5000L)).build();
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)factory, this.runner, query);
        Assert.assertEquals((long)0L, (long)mergeBufferPool.getMinRemainBufferNum());
        Assert.assertEquals((long)3L, (long)mergeBufferPool.getPoolSize());
    }

    @Test
    public void testTripleNestedGroupBy() {
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.firstToThird).setGranularity(Granularities.ALL).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", null), new DefaultDimensionSpec("placement", null)})).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build()).setInterval(QueryRunnerTestHelper.firstToThird).setGranularity(Granularities.ALL).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", null)})).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build()).setInterval(QueryRunnerTestHelper.firstToThird).setGranularity(Granularities.ALL).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build())).setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")})).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)5000L)).build();
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)factory, this.runner, query);
        Assert.assertEquals((long)0L, (long)mergeBufferPool.getMinRemainBufferNum());
        Assert.assertEquals((long)3L, (long)mergeBufferPool.getPoolSize());
    }

    private static class TestBlockingPool
    extends DefaultBlockingPool<ByteBuffer> {
        private int minRemainBufferNum;

        public TestBlockingPool(Supplier<ByteBuffer> generator, int limit) {
            super(generator, limit);
            this.minRemainBufferNum = limit;
        }

        public ReferenceCountingResourceHolder<ByteBuffer> take(long timeout) {
            ReferenceCountingResourceHolder holder = super.take(timeout);
            int poolSize = this.getPoolSize();
            if (this.minRemainBufferNum > poolSize) {
                this.minRemainBufferNum = poolSize;
            }
            return holder;
        }

        public ReferenceCountingResourceHolder<List<ByteBuffer>> takeBatch(int maxElements, long timeout) {
            ReferenceCountingResourceHolder holder = super.takeBatch(maxElements, timeout);
            int poolSize = this.getPoolSize();
            if (this.minRemainBufferNum > poolSize) {
                this.minRemainBufferNum = poolSize;
            }
            return holder;
        }

        public void resetMinRemainBufferNum() {
            this.minRemainBufferNum = PROCESSING_CONFIG.getNumMergeBuffers();
        }

        public int getMinRemainBufferNum() {
            return this.minRemainBufferNum;
        }
    }
}

