/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.filter;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.guice.GuiceInjectors;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.RegexDimExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.BoundDimFilter;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BoundDimFilterTest {
    private static final ExtractionFn extractionFn = new RegexDimExtractionFn(".*", Boolean.valueOf(false), null);
    private final BoundDimFilter boundDimFilter;

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{new BoundDimFilter("dimension", "12", "15", null, null, null, null, StringComparators.LEXICOGRAPHIC)}, (Object)new Object[]{new BoundDimFilter("dimension", "12", "15", null, Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC)}, (Object)new Object[]{new BoundDimFilter("dimension", "12", "15", null, null, Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC)}, (Object)new Object[]{new BoundDimFilter("dimension", null, "15", null, Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC)}, (Object)new Object[]{new BoundDimFilter("dimension", "12", "15", Boolean.valueOf(true), null, null, null, StringComparators.LEXICOGRAPHIC)}, (Object)new Object[]{new BoundDimFilter("dimension", "12", null, Boolean.valueOf(true), null, Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC)}, (Object)new Object[]{new BoundDimFilter("dimension", "12", "15", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC)}, (Object)new Object[]{new BoundDimFilter("dimension", "12", "15", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC)}, (Object)new Object[]{new BoundDimFilter("dimension", null, "15", null, Boolean.valueOf(true), Boolean.valueOf(true), extractionFn, StringComparators.ALPHANUMERIC)});
    }

    public BoundDimFilterTest(BoundDimFilter boundDimFilter) {
        this.boundDimFilter = boundDimFilter;
    }

    @Test
    public void testSerDesBoundFilter() throws IOException {
        Injector defaultInjector = GuiceInjectors.makeStartupInjector();
        ObjectMapper mapper = (ObjectMapper)defaultInjector.getInstance(Key.get(ObjectMapper.class, Json.class));
        String serBetweenDimFilter = mapper.writeValueAsString((Object)this.boundDimFilter);
        BoundDimFilter actualBoundDimFilter = (BoundDimFilter)mapper.reader(DimFilter.class).readValue(serBetweenDimFilter);
        Assert.assertEquals((Object)this.boundDimFilter, (Object)actualBoundDimFilter);
    }

    @Test
    public void testGetCacheKey() {
        BoundDimFilter boundDimFilter = new BoundDimFilter("dimension", "12", "15", null, null, Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC);
        BoundDimFilter boundDimFilterCopy = new BoundDimFilter("dimension", "12", "15", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC);
        Assert.assertArrayEquals((byte[])boundDimFilter.getCacheKey(), (byte[])boundDimFilterCopy.getCacheKey());
        BoundDimFilter anotherBoundDimFilter = new BoundDimFilter("dimension", "12", "15", Boolean.valueOf(true), null, Boolean.valueOf(false), null, StringComparators.LEXICOGRAPHIC);
        Assert.assertFalse((boolean)Arrays.equals(anotherBoundDimFilter.getCacheKey(), boundDimFilter.getCacheKey()));
        BoundDimFilter boundDimFilterWithExtract = new BoundDimFilter("dimension", "12", "15", null, null, Boolean.valueOf(true), extractionFn, StringComparators.ALPHANUMERIC);
        BoundDimFilter boundDimFilterWithExtractCopy = new BoundDimFilter("dimension", "12", "15", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), extractionFn, StringComparators.ALPHANUMERIC);
        Assert.assertFalse((boolean)Arrays.equals(boundDimFilter.getCacheKey(), boundDimFilterWithExtract.getCacheKey()));
        Assert.assertArrayEquals((byte[])boundDimFilterWithExtract.getCacheKey(), (byte[])boundDimFilterWithExtractCopy.getCacheKey());
    }

    @Test
    public void testHashCode() {
        BoundDimFilter boundDimFilter = new BoundDimFilter("dimension", "12", "15", null, null, Boolean.valueOf(true), null, StringComparators.ALPHANUMERIC);
        BoundDimFilter boundDimFilterWithExtract = new BoundDimFilter("dimension", "12", "15", null, null, Boolean.valueOf(true), extractionFn, StringComparators.ALPHANUMERIC);
        Assert.assertNotEquals((long)boundDimFilter.hashCode(), (long)boundDimFilterWithExtract.hashCode());
    }
}

