/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.BaseQuery;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.RetryQueryRunner;
import org.apache.hive.druid.io.druid.query.RetryQueryRunnerConfig;
import org.apache.hive.druid.io.druid.query.SegmentDescriptor;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.io.druid.segment.SegmentMissingException;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class RetryQueryRunnerTest {
    private final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
    final TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).intervals(QueryRunnerTestHelper.firstToThird).aggregators(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.qualityUniques)).build();

    @Test
    public void testRunWithMissingSegments() throws Exception {
        ConcurrentHashMap<String, ArrayList> context = new ConcurrentHashMap<String, ArrayList>();
        context.put(Result.MISSING_SEGMENTS_KEY, Lists.newArrayList());
        RetryQueryRunner runner = new RetryQueryRunner((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus queryPlus, Map context) {
                ((List)context.get(Result.MISSING_SEGMENTS_KEY)).add(new SegmentDescriptor(Intervals.utc((long)178888L, (long)1999999L), "test", 1));
                return Sequences.empty();
            }
        }, new RetryQueryRunnerConfig(){

            public int getNumTries() {
                return 0;
            }

            public boolean isReturnPartialResults() {
                return true;
            }
        }, this.jsonMapper);
        List actualResults = Sequences.toList((Sequence)runner.run(QueryPlus.wrap((Query)this.query), context), (List)Lists.newArrayList());
        Assert.assertTrue((String)"Should have one entry in the list of missing segments", (((List)context.get(Result.MISSING_SEGMENTS_KEY)).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should return an empty sequence as a result", (actualResults.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRetry() throws Exception {
        ConcurrentHashMap<String, Serializable> context = new ConcurrentHashMap<String, Serializable>();
        context.put("count", Integer.valueOf(0));
        context.put(Result.MISSING_SEGMENTS_KEY, Lists.newArrayList());
        RetryQueryRunner runner = new RetryQueryRunner((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, Map<String, Object> context) {
                if ((Integer)context.get("count") == 0) {
                    ((List)context.get(Result.MISSING_SEGMENTS_KEY)).add(new SegmentDescriptor(Intervals.utc((long)178888L, (long)1999999L), "test", 1));
                    context.put("count", 1);
                    return Sequences.empty();
                }
                return Sequences.simple(Arrays.asList(new Result(DateTimes.nowUtc(), (Object)new TimeseriesResultValue((Map)Maps.newHashMap()))));
            }
        }, (RetryQueryRunnerConfig)new TestRetryQueryRunnerConfig(1, true), this.jsonMapper);
        List actualResults = Sequences.toList((Sequence)runner.run(QueryPlus.wrap((Query)this.query), context), (List)Lists.newArrayList());
        Assert.assertTrue((String)"Should return a list with one element", (actualResults.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should have nothing in missingSegment list", (((List)context.get(Result.MISSING_SEGMENTS_KEY)).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRetryMultiple() throws Exception {
        ConcurrentHashMap<String, Serializable> context = new ConcurrentHashMap<String, Serializable>();
        context.put("count", Integer.valueOf(0));
        context.put(Result.MISSING_SEGMENTS_KEY, Lists.newArrayList());
        RetryQueryRunner runner = new RetryQueryRunner((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, Map<String, Object> context) {
                if ((Integer)context.get("count") < 3) {
                    ((List)context.get(Result.MISSING_SEGMENTS_KEY)).add(new SegmentDescriptor(Intervals.utc((long)178888L, (long)1999999L), "test", 1));
                    context.put("count", (Integer)context.get("count") + 1);
                    return Sequences.empty();
                }
                return Sequences.simple(Arrays.asList(new Result(DateTimes.nowUtc(), (Object)new TimeseriesResultValue((Map)Maps.newHashMap()))));
            }
        }, (RetryQueryRunnerConfig)new TestRetryQueryRunnerConfig(4, true), this.jsonMapper);
        List actualResults = Sequences.toList((Sequence)runner.run(QueryPlus.wrap((Query)this.query), context), (List)Lists.newArrayList());
        Assert.assertTrue((String)"Should return a list with one element", (actualResults.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should have nothing in missingSegment list", (((List)context.get(Result.MISSING_SEGMENTS_KEY)).size() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=SegmentMissingException.class)
    public void testException() throws Exception {
        ConcurrentHashMap<String, ArrayList> context = new ConcurrentHashMap<String, ArrayList>();
        context.put(Result.MISSING_SEGMENTS_KEY, Lists.newArrayList());
        RetryQueryRunner runner = new RetryQueryRunner((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, Map<String, Object> context) {
                ((List)context.get(Result.MISSING_SEGMENTS_KEY)).add(new SegmentDescriptor(Intervals.utc((long)178888L, (long)1999999L), "test", 1));
                return Sequences.empty();
            }
        }, (RetryQueryRunnerConfig)new TestRetryQueryRunnerConfig(1, false), this.jsonMapper);
        Sequences.toList((Sequence)runner.run(QueryPlus.wrap((Query)this.query), context), (List)Lists.newArrayList());
        Assert.assertTrue((String)"Should have one entry in the list of missing segments", (((List)context.get(Result.MISSING_SEGMENTS_KEY)).size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testNoDuplicateRetry() throws Exception {
        ConcurrentHashMap<String, Serializable> context = new ConcurrentHashMap<String, Serializable>();
        context.put("count", Integer.valueOf(0));
        context.put(Result.MISSING_SEGMENTS_KEY, Lists.newArrayList());
        RetryQueryRunner runner = new RetryQueryRunner((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, Map<String, Object> context) {
                Query query = queryPlus.getQuery();
                if ((Integer)context.get("count") == 0) {
                    ((List)context.get(Result.MISSING_SEGMENTS_KEY)).add(new SegmentDescriptor(Intervals.utc((long)178888L, (long)1999999L), "test", 1));
                    ((List)context.get(Result.MISSING_SEGMENTS_KEY)).add(new SegmentDescriptor(Intervals.utc((long)178888L, (long)1999999L), "test", 2));
                    context.put("count", 1);
                    return Sequences.simple(Arrays.asList(new Result(DateTimes.nowUtc(), (Object)new TimeseriesResultValue((Map)Maps.newHashMap()))));
                }
                if ((Integer)context.get("count") == 1) {
                    Assert.assertTrue((String)"Should retry with 2 missing segments", (((MultipleSpecificSegmentSpec)((BaseQuery)query).getQuerySegmentSpec()).getDescriptors().size() == 2 ? 1 : 0) != 0);
                    ((List)context.get(Result.MISSING_SEGMENTS_KEY)).add(new SegmentDescriptor(Intervals.utc((long)178888L, (long)1999999L), "test", 2));
                    context.put("count", 2);
                    return Sequences.simple(Arrays.asList(new Result(DateTimes.nowUtc(), (Object)new TimeseriesResultValue((Map)Maps.newHashMap()))));
                }
                Assert.assertTrue((String)"Should retry with 1 missing segments", (((MultipleSpecificSegmentSpec)((BaseQuery)query).getQuerySegmentSpec()).getDescriptors().size() == 1 ? 1 : 0) != 0);
                context.put("count", 3);
                return Sequences.simple(Arrays.asList(new Result(DateTimes.nowUtc(), (Object)new TimeseriesResultValue((Map)Maps.newHashMap()))));
            }
        }, (RetryQueryRunnerConfig)new TestRetryQueryRunnerConfig(2, false), this.jsonMapper);
        List actualResults = Sequences.toList((Sequence)runner.run(QueryPlus.wrap((Query)this.query), context), (List)Lists.newArrayList());
        Assert.assertTrue((String)"Should return a list with 3 elements", (actualResults.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should have nothing in missingSegment list", (((List)context.get(Result.MISSING_SEGMENTS_KEY)).size() == 0 ? 1 : 0) != 0);
    }

    private static class TestRetryQueryRunnerConfig
    extends RetryQueryRunnerConfig {
        private int numTries;
        private boolean returnPartialResults;

        public TestRetryQueryRunnerConfig(int numTries, boolean returnPartialResults) {
            this.numTries = numTries;
            this.returnPartialResults = returnPartialResults;
        }

        public int getNumTries() {
            return this.numTries;
        }

        public boolean isReturnPartialResults() {
            return this.returnPartialResults;
        }
    }
}

