/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.metadata.MetadataSegmentManagerConfig;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataSegmentManager;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataSegmentPublisher;
import org.apache.hive.druid.io.druid.metadata.TestDerbyConnector;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.server.metrics.NoopServiceEmitter;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MetadataSegmentManagerTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private SQLMetadataSegmentManager manager;
    private SQLMetadataSegmentPublisher publisher;
    private final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
    private final DataSegment segment1 = new DataSegment("wikipedia", Intervals.of((String)"2012-03-15T00:00:00.000/2012-03-16T00:00:00.000"), "2012-03-16T00:36:30.848Z", (Map)ImmutableMap.of((Object)"type", (Object)"s3_zip", (Object)"bucket", (Object)"test", (Object)"key", (Object)"wikipedia/index/y=2012/m=03/d=15/2012-03-16T00:36:30.848Z/0/index.zip"), (List)ImmutableList.of((Object)"dim1", (Object)"dim2", (Object)"dim3"), (List)ImmutableList.of((Object)"count", (Object)"value"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 1234L);
    private final DataSegment segment2 = new DataSegment("wikipedia", Intervals.of((String)"2012-01-05T00:00:00.000/2012-01-06T00:00:00.000"), "2012-01-06T22:19:12.565Z", (Map)ImmutableMap.of((Object)"type", (Object)"s3_zip", (Object)"bucket", (Object)"test", (Object)"key", (Object)"wikipedia/index/y=2012/m=01/d=05/2012-01-06T22:19:12.565Z/0/index.zip"), (List)ImmutableList.of((Object)"dim1", (Object)"dim2", (Object)"dim3"), (List)ImmutableList.of((Object)"count", (Object)"value"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 1234L);

    @Before
    public void setUp() throws Exception {
        TestDerbyConnector connector = this.derbyConnectorRule.getConnector();
        this.manager = new SQLMetadataSegmentManager(this.jsonMapper, Suppliers.ofInstance((Object)new MetadataSegmentManagerConfig()), this.derbyConnectorRule.metadataTablesConfigSupplier(), (SQLMetadataConnector)connector);
        this.publisher = new SQLMetadataSegmentPublisher(this.jsonMapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)connector);
        connector.createSegmentTable();
        this.publisher.publishSegment(this.segment1);
        this.publisher.publishSegment(this.segment2);
    }

    @After
    public void teardown() {
        if (this.manager.isStarted()) {
            this.manager.stop();
        }
    }

    @Test
    public void testPoll() {
        this.manager.start();
        this.manager.poll();
        Assert.assertEquals((Object)ImmutableList.of((Object)"wikipedia"), (Object)this.manager.getAllDatasourceNames());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Collection)this.manager.getInventoryValue("wikipedia").getSegments()));
    }

    @Test
    public void testPollWithCurroptedSegment() {
        this.publisher.publishSegment("corrupt-segment-id", "corrupt-datasource", "corrupt-create-date", "corrupt-start-date", "corrupt-end-date", true, "corrupt-version", true, StringUtils.toUtf8((String)"corrupt-payload"));
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        this.manager.start();
        this.manager.poll();
        Assert.assertEquals((Object)"wikipedia", (Object)((ImmutableDruidDataSource)Iterables.getOnlyElement((Iterable)this.manager.getInventory())).getName());
    }

    @Test
    public void testGetUnusedSegmentsForInterval() throws Exception {
        this.manager.start();
        this.manager.poll();
        Assert.assertTrue((boolean)this.manager.removeDatasource("wikipedia"));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.segment2.getInterval()), (Object)this.manager.getUnusedSegmentIntervals("wikipedia", Intervals.of((String)"1970/3000"), 1));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.segment2.getInterval(), (Object)this.segment1.getInterval()), (Object)this.manager.getUnusedSegmentIntervals("wikipedia", Intervals.of((String)"1970/3000"), 5));
    }

    @Test
    public void testRemoveDataSource() throws IOException {
        this.manager.start();
        this.manager.poll();
        String newDataSource = "wikipedia2";
        DataSegment newSegment = new DataSegment("wikipedia2", Intervals.of((String)"2017-10-15T00:00:00.000/2017-10-16T00:00:00.000"), "2017-10-15T20:19:12.565Z", (Map)ImmutableMap.of((Object)"type", (Object)"s3_zip", (Object)"bucket", (Object)"test", (Object)"key", (Object)"wikipedia2/index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip"), (List)ImmutableList.of((Object)"dim1", (Object)"dim2", (Object)"dim3"), (List)ImmutableList.of((Object)"count", (Object)"value"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 1234L);
        this.publisher.publishSegment(newSegment);
        Assert.assertNull((Object)this.manager.getInventoryValue("wikipedia2"));
        Assert.assertTrue((boolean)this.manager.removeDatasource("wikipedia2"));
    }

    @Test
    public void testRemoveDataSegment() throws IOException {
        this.manager.start();
        this.manager.poll();
        String newDataSource = "wikipedia2";
        DataSegment newSegment = new DataSegment("wikipedia2", Intervals.of((String)"2017-10-15T00:00:00.000/2017-10-16T00:00:00.000"), "2017-10-15T20:19:12.565Z", (Map)ImmutableMap.of((Object)"type", (Object)"s3_zip", (Object)"bucket", (Object)"test", (Object)"key", (Object)"wikipedia2/index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip"), (List)ImmutableList.of((Object)"dim1", (Object)"dim2", (Object)"dim3"), (List)ImmutableList.of((Object)"count", (Object)"value"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 1234L);
        this.publisher.publishSegment(newSegment);
        Assert.assertNull((Object)this.manager.getInventoryValue("wikipedia2"));
        Assert.assertTrue((boolean)this.manager.removeSegment("wikipedia2", newSegment.getIdentifier()));
    }
}

