/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.curator;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Properties;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.ensemble.exhibitor.ExhibitorEnsembleProvider;
import org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.curator.CuratorModule;
import org.apache.hive.druid.io.druid.guice.GuiceInjectors;
import org.apache.hive.druid.io.druid.guice.LifecycleModule;
import org.junit.Assert;
import org.junit.Test;

public final class CuratorModuleTest {
    private static final String curatorHostKey = "druid.zk.service.host";
    private static final String exhibitorHostsKey = "druid.exhibitor.service.hosts";

    @Test
    public void defaultEnsembleProvider() throws NoSuchFieldException, IllegalAccessException {
        Injector injector = this.newInjector(new Properties());
        injector.getInstance(CuratorFramework.class);
        EnsembleProvider ensembleProvider = (EnsembleProvider)injector.getInstance(EnsembleProvider.class);
        Assert.assertTrue((String)"EnsembleProvider should be FixedEnsembleProvider", (boolean)(ensembleProvider instanceof FixedEnsembleProvider));
        Assert.assertEquals((String)"The connectionString should be 'localhost'", (Object)"localhost", (Object)ensembleProvider.getConnectionString());
    }

    @Test
    public void fixedZkHosts() {
        Properties props = new Properties();
        props.put(curatorHostKey, "hostA");
        Injector injector = this.newInjector(props);
        injector.getInstance(CuratorFramework.class);
        EnsembleProvider ensembleProvider = (EnsembleProvider)injector.getInstance(EnsembleProvider.class);
        Assert.assertTrue((String)"EnsembleProvider should be FixedEnsembleProvider", (boolean)(ensembleProvider instanceof FixedEnsembleProvider));
        Assert.assertEquals((String)"The connectionString should be 'hostA'", (Object)"hostA", (Object)ensembleProvider.getConnectionString());
    }

    @Test
    public void exhibitorEnsembleProvider() {
        Properties props = new Properties();
        props.put(curatorHostKey, "hostA");
        props.put(exhibitorHostsKey, "[\"hostB\"]");
        Injector injector = this.newInjector(props);
        injector.getInstance(CuratorFramework.class);
        EnsembleProvider ensembleProvider = (EnsembleProvider)injector.getInstance(EnsembleProvider.class);
        Assert.assertTrue((String)"EnsembleProvider should be ExhibitorEnsembleProvider", (boolean)(ensembleProvider instanceof ExhibitorEnsembleProvider));
    }

    @Test
    public void emptyExhibitorHosts() {
        Properties props = new Properties();
        props.put(curatorHostKey, "hostB");
        props.put(exhibitorHostsKey, "[]");
        Injector injector = this.newInjector(props);
        injector.getInstance(CuratorFramework.class);
        EnsembleProvider ensembleProvider = (EnsembleProvider)injector.getInstance(EnsembleProvider.class);
        Assert.assertTrue((String)"EnsembleProvider should be FixedEnsembleProvider", (boolean)(ensembleProvider instanceof FixedEnsembleProvider));
        Assert.assertEquals((String)"The connectionString should be 'hostB'", (Object)"hostB", (Object)ensembleProvider.getConnectionString());
    }

    private Injector newInjector(final Properties props) {
        ImmutableList modules = ImmutableList.builder().addAll((Iterable)GuiceInjectors.makeDefaultStartupModules()).add((Object)new LifecycleModule()).add((Object)new CuratorModule()).build();
        return Guice.createInjector((Module[])new Module[]{Modules.override((Iterable)modules).with(new Module[]{new Module(){

            public void configure(Binder binder) {
                binder.bind(Properties.class).toInstance((Object)props);
            }
        }})});
    }
}

