/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.emitter.service;

import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.emitter.service.AlertBuilder;
import org.apache.hive.druid.com.metamx.emitter.service.AlertEvent;
import org.junit.Assert;
import org.junit.Test;

public class AlertEventTest {
    @Test
    public void testStupid() throws Exception {
        AlertEvent event = (AlertEvent)AlertBuilder.create((String)"blargy", (Object[])new Object[0]).addData("something1", (Object)"a").addData("something2", (Object)"b").build("test", "localhost");
        Assert.assertEquals((Object)ImmutableMap.builder().put((Object)"feed", (Object)"alerts").put((Object)"timestamp", (Object)event.getCreatedTime().toString()).put((Object)"service", (Object)"test").put((Object)"host", (Object)"localhost").put((Object)"severity", (Object)"component-failure").put((Object)"description", (Object)"blargy").put((Object)"data", (Object)ImmutableMap.of((Object)"something1", (Object)"a", (Object)"something2", (Object)"b")).build(), (Object)event.toMap());
    }

    @Test
    public void testAnomaly() throws Exception {
        AlertEvent event = (AlertEvent)AlertBuilder.create((String)"blargy", (Object[])new Object[0]).severity(AlertEvent.Severity.ANOMALY).addData("something1", (Object)"a").addData("something2", (Object)"b").build("test", "localhost");
        Assert.assertEquals((Object)ImmutableMap.builder().put((Object)"feed", (Object)"alerts").put((Object)"timestamp", (Object)event.getCreatedTime().toString()).put((Object)"service", (Object)"test").put((Object)"host", (Object)"localhost").put((Object)"severity", (Object)"anomaly").put((Object)"description", (Object)"blargy").put((Object)"data", (Object)ImmutableMap.of((Object)"something1", (Object)"a", (Object)"something2", (Object)"b")).build(), (Object)event.toMap());
    }

    @Test
    public void testComponentFailure() throws Exception {
        AlertEvent event = (AlertEvent)AlertBuilder.create((String)"blargy", (Object[])new Object[0]).severity(AlertEvent.Severity.COMPONENT_FAILURE).addData("something1", (Object)"a").addData("something2", (Object)"b").build("test", "localhost");
        Assert.assertEquals((Object)ImmutableMap.builder().put((Object)"feed", (Object)"alerts").put((Object)"timestamp", (Object)event.getCreatedTime().toString()).put((Object)"service", (Object)"test").put((Object)"host", (Object)"localhost").put((Object)"severity", (Object)"component-failure").put((Object)"description", (Object)"blargy").put((Object)"data", (Object)ImmutableMap.of((Object)"something1", (Object)"a", (Object)"something2", (Object)"b")).build(), (Object)event.toMap());
    }

    @Test
    public void testServiceFailure() throws Exception {
        AlertEvent event = (AlertEvent)AlertBuilder.create((String)"blargy", (Object[])new Object[0]).severity(AlertEvent.Severity.SERVICE_FAILURE).addData("something1", (Object)"a").addData("something2", (Object)"b").build("test", "localhost");
        Assert.assertEquals((Object)ImmutableMap.builder().put((Object)"feed", (Object)"alerts").put((Object)"timestamp", (Object)event.getCreatedTime().toString()).put((Object)"service", (Object)"test").put((Object)"host", (Object)"localhost").put((Object)"severity", (Object)"service-failure").put((Object)"description", (Object)"blargy").put((Object)"data", (Object)ImmutableMap.of((Object)"something1", (Object)"a", (Object)"something2", (Object)"b")).build(), (Object)event.toMap());
    }

    @Test
    public void testDefaulting() throws Exception {
        String service = "some service";
        String host = "some host";
        String desc = "some description";
        ImmutableMap data = ImmutableMap.builder().put((Object)"a", (Object)"1").put((Object)"b", (Object)"2").build();
        for (AlertEvent.Severity severity : new AlertEvent.Severity[]{AlertEvent.Severity.ANOMALY, AlertEvent.Severity.COMPONENT_FAILURE, AlertEvent.Severity.SERVICE_FAILURE}) {
            Assert.assertEquals(this.contents(new AlertEvent("some service", "some host", "some description", (Map)data)), this.contents(new AlertEvent("some service", "some host", AlertEvent.Severity.COMPONENT_FAILURE, "some description", (Map)data)));
            Assert.assertEquals(this.contents(new AlertEvent("some service", "some host", "some description")), this.contents(new AlertEvent("some service", "some host", AlertEvent.Severity.COMPONENT_FAILURE, "some description", (Map)ImmutableMap.of())));
            Assert.assertEquals(this.contents((AlertEvent)AlertBuilder.create((String)"some description", (Object[])new Object[0]).addData("a", (Object)"1").addData("b", (Object)"2").build("some service", "some host")), this.contents(new AlertEvent("some service", "some host", AlertEvent.Severity.COMPONENT_FAILURE, "some description", (Map)data)));
            Assert.assertEquals(this.contents((AlertEvent)AlertBuilder.create((String)"some description", (Object[])new Object[0]).addData((Map)data).build("some service", "some host")), this.contents(new AlertEvent("some service", "some host", AlertEvent.Severity.COMPONENT_FAILURE, "some description", (Map)data)));
            Assert.assertEquals(this.contents((AlertEvent)AlertBuilder.create((String)"some description", (Object[])new Object[0]).severity(severity).addData("a", (Object)"1").addData("b", (Object)"2").build("some service", "some host")), this.contents(new AlertEvent("some service", "some host", severity, "some description", (Map)data)));
            Assert.assertEquals(this.contents((AlertEvent)AlertBuilder.create((String)"some description", (Object[])new Object[0]).severity(severity).addData((Map)data).build("some service", "some host")), this.contents(new AlertEvent("some service", "some host", severity, "some description", (Map)data)));
        }
    }

    public Map<String, Object> contents(AlertEvent a) {
        return Maps.filterKeys((Map)a.toMap(), (Predicate)new Predicate<String>(){

            public boolean apply(String k) {
                return k != "timestamp";
            }
        });
    }
}

