/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.emitter.core;

import java.util.Properties;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.metamx.emitter.core.BatchingStrategy;
import org.apache.hive.druid.com.metamx.emitter.core.Emitters;
import org.apache.hive.druid.com.metamx.emitter.core.HttpEmitterConfig;
import org.apache.hive.druid.com.metamx.emitter.core.ParametrizedUriEmitterConfig;
import org.junit.Assert;
import org.junit.Test;

public class ParametrizedUriEmitterConfigTest {
    @Test
    public void testDefaults() {
        Properties props = new Properties();
        ObjectMapper objectMapper = new ObjectMapper();
        ParametrizedUriEmitterConfig paramConfig = (ParametrizedUriEmitterConfig)objectMapper.convertValue((Object)Emitters.makeCustomFactoryMap((Properties)props), ParametrizedUriEmitterConfig.class);
        HttpEmitterConfig config = paramConfig.buildHttpEmitterConfig("http://example.com/topic");
        Assert.assertEquals((long)60000L, (long)config.getFlushMillis());
        Assert.assertEquals((long)500L, (long)config.getFlushCount());
        Assert.assertEquals((Object)"http://example.com/topic", (Object)config.getRecipientBaseUrl());
        Assert.assertEquals(null, (Object)config.getBasicAuthentication());
        Assert.assertEquals((Object)BatchingStrategy.ARRAY, (Object)config.getBatchingStrategy());
        Assert.assertEquals((long)0x500000L, (long)config.getMaxBatchSize());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)config.getFlushTimeOut());
    }

    @Test
    public void testSettingEverything() {
        Properties props = new Properties();
        props.setProperty("org.apache.hive.druid.com.metamx.emitter.httpEmitting.flushMillis", "1");
        props.setProperty("org.apache.hive.druid.com.metamx.emitter.httpEmitting.flushCount", "2");
        props.setProperty("org.apache.hive.druid.com.metamx.emitter.httpEmitting.basicAuthentication", "a:b");
        props.setProperty("org.apache.hive.druid.com.metamx.emitter.httpEmitting.batchingStrategy", "NEWLINES");
        props.setProperty("org.apache.hive.druid.com.metamx.emitter.httpEmitting.maxBatchSize", "4");
        props.setProperty("org.apache.hive.druid.com.metamx.emitter.httpEmitting.flushTimeOut", "1000");
        ObjectMapper objectMapper = new ObjectMapper();
        ParametrizedUriEmitterConfig paramConfig = (ParametrizedUriEmitterConfig)objectMapper.convertValue((Object)Emitters.makeCustomFactoryMap((Properties)props), ParametrizedUriEmitterConfig.class);
        HttpEmitterConfig config = paramConfig.buildHttpEmitterConfig("http://example.com/topic");
        Assert.assertEquals((long)1L, (long)config.getFlushMillis());
        Assert.assertEquals((long)2L, (long)config.getFlushCount());
        Assert.assertEquals((Object)"http://example.com/topic", (Object)config.getRecipientBaseUrl());
        Assert.assertEquals((Object)"a:b", (Object)config.getBasicAuthentication());
        Assert.assertEquals((Object)BatchingStrategy.NEWLINES, (Object)config.getBatchingStrategy());
        Assert.assertEquals((long)4L, (long)config.getMaxBatchSize());
        Assert.assertEquals((long)1000L, (long)config.getFlushTimeOut());
    }
}

