/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.integration.gauss;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.function.Cos;
import org.apache.commons.math3.analysis.function.Inverse;
import org.apache.commons.math3.analysis.function.Log;
import org.apache.commons.math3.analysis.integration.gauss.GaussIntegrator;
import org.apache.commons.math3.analysis.integration.gauss.GaussIntegratorFactory;
import org.junit.Assert;
import org.junit.Test;

public class LegendreHighPrecisionTest {
    private static GaussIntegratorFactory factory = new GaussIntegratorFactory();

    @Test
    public void testCos() {
        Cos cos = new Cos();
        GaussIntegrator integrator = factory.legendreHighPrecision(7, 0.0, 1.5707963267948966);
        double s = integrator.integrate((UnivariateFunction)cos);
        Assert.assertEquals((double)1.0, (double)s, (double)Math.ulp(1.0));
    }

    @Test
    public void testInverse() {
        Inverse inv = new Inverse();
        Log log = new Log();
        double lo = 12.34;
        double hi = 456.78;
        GaussIntegrator integrator = factory.legendreHighPrecision(60, 12.34, 456.78);
        double s = integrator.integrate((UnivariateFunction)inv);
        double expected = log.value(456.78) - log.value(12.34);
        Assert.assertEquals((double)expected, (double)s, (double)1.0E-15);
    }
}

