/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.math.BigInteger;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CompareToBuilderTest {
    @Test
    public void testReflectionCompare() {
        TestObject o1 = new TestObject(4);
        TestObject o2 = new TestObject(4);
        Assertions.assertEquals((int)0, (int)CompareToBuilder.reflectionCompare((Object)o1, (Object)o1));
        Assertions.assertEquals((int)0, (int)CompareToBuilder.reflectionCompare((Object)o1, (Object)o2));
        o2.setA(5);
        Assertions.assertTrue((CompareToBuilder.reflectionCompare((Object)o1, (Object)o2) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((CompareToBuilder.reflectionCompare((Object)o2, (Object)o1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReflectionCompareEx1() {
        TestObject o1 = new TestObject(4);
        Assertions.assertThrows(NullPointerException.class, () -> CompareToBuilder.reflectionCompare((Object)o1, null));
    }

    @Test
    public void testReflectionCompareEx2() {
        TestObject o1 = new TestObject(4);
        Object o2 = new Object();
        Assertions.assertThrows(ClassCastException.class, () -> CompareToBuilder.reflectionCompare((Object)o1, (Object)o2));
    }

    @Test
    public void testReflectionHierarchyCompare() {
        this.testReflectionHierarchyCompare(false, null);
    }

    @Test
    public void testReflectionHierarchyCompareExcludeFields() {
        String[] excludeFields = new String[]{"b"};
        this.testReflectionHierarchyCompare(true, excludeFields);
        TestSubObject x = new TestSubObject(1, 1);
        TestSubObject y = new TestSubObject(2, 1);
        TestSubObject z = new TestSubObject(3, 1);
        this.assertXYZCompareOrder(x, y, z, true, excludeFields);
        x = new TestSubObject(1, 3);
        y = new TestSubObject(2, 2);
        z = new TestSubObject(3, 1);
        this.assertXYZCompareOrder(x, y, z, true, excludeFields);
    }

    @Test
    public void testReflectionHierarchyCompareTransients() {
        this.testReflectionHierarchyCompare(true, null);
        TestTransientSubObject x = new TestTransientSubObject(1, 1);
        TestTransientSubObject y = new TestTransientSubObject(2, 2);
        TestTransientSubObject z = new TestTransientSubObject(3, 3);
        this.assertXYZCompareOrder(x, y, z, true, null);
        x = new TestTransientSubObject(1, 1);
        y = new TestTransientSubObject(1, 2);
        z = new TestTransientSubObject(1, 3);
        this.assertXYZCompareOrder(x, y, z, true, null);
    }

    private void assertXYZCompareOrder(Object x, Object y, Object z, boolean testTransients, String[] excludeFields) {
        Assertions.assertEquals((int)0, (int)CompareToBuilder.reflectionCompare((Object)x, (Object)x, (boolean)testTransients, null, (String[])excludeFields));
        Assertions.assertEquals((int)0, (int)CompareToBuilder.reflectionCompare((Object)y, (Object)y, (boolean)testTransients, null, (String[])excludeFields));
        Assertions.assertEquals((int)0, (int)CompareToBuilder.reflectionCompare((Object)z, (Object)z, (boolean)testTransients, null, (String[])excludeFields));
        Assertions.assertTrue((0 > CompareToBuilder.reflectionCompare((Object)x, (Object)y, (boolean)testTransients, null, (String[])excludeFields) ? 1 : 0) != 0);
        Assertions.assertTrue((0 > CompareToBuilder.reflectionCompare((Object)x, (Object)z, (boolean)testTransients, null, (String[])excludeFields) ? 1 : 0) != 0);
        Assertions.assertTrue((0 > CompareToBuilder.reflectionCompare((Object)y, (Object)z, (boolean)testTransients, null, (String[])excludeFields) ? 1 : 0) != 0);
        Assertions.assertTrue((0 < CompareToBuilder.reflectionCompare((Object)y, (Object)x, (boolean)testTransients, null, (String[])excludeFields) ? 1 : 0) != 0);
        Assertions.assertTrue((0 < CompareToBuilder.reflectionCompare((Object)z, (Object)x, (boolean)testTransients, null, (String[])excludeFields) ? 1 : 0) != 0);
        Assertions.assertTrue((0 < CompareToBuilder.reflectionCompare((Object)z, (Object)y, (boolean)testTransients, null, (String[])excludeFields) ? 1 : 0) != 0);
    }

    private void testReflectionHierarchyCompare(boolean testTransients, String[] excludeFields) {
        TestObject to1 = new TestObject(1);
        TestObject to2 = new TestObject(2);
        TestObject to3 = new TestObject(3);
        TestSubObject tso1 = new TestSubObject(1, 1);
        TestSubObject tso2 = new TestSubObject(2, 2);
        TestSubObject tso3 = new TestSubObject(3, 3);
        this.assertReflectionCompareContract(to1, to1, to1, false, excludeFields);
        this.assertReflectionCompareContract(to1, to2, to3, false, excludeFields);
        this.assertReflectionCompareContract(tso1, tso1, tso1, false, excludeFields);
        this.assertReflectionCompareContract(tso1, tso2, tso3, false, excludeFields);
        this.assertReflectionCompareContract("1", "2", "3", false, excludeFields);
        Assertions.assertTrue((0 != CompareToBuilder.reflectionCompare((Object)tso1, (Object)new TestSubObject(1, 0), (boolean)testTransients) ? 1 : 0) != 0);
        Assertions.assertTrue((0 != CompareToBuilder.reflectionCompare((Object)tso1, (Object)new TestSubObject(0, 1), (boolean)testTransients) ? 1 : 0) != 0);
        this.assertXYZCompareOrder(to1, to2, to3, true, null);
        this.assertXYZCompareOrder(tso1, tso2, tso3, true, null);
    }

    private void assertReflectionCompareContract(Object x, Object y, Object z, boolean testTransients, String[] excludeFields) {
        Assertions.assertEquals((int)this.reflectionCompareSignum(x, y, testTransients, excludeFields), (int)(-this.reflectionCompareSignum(y, x, testTransients, excludeFields)));
        if (CompareToBuilder.reflectionCompare((Object)x, (Object)y, (boolean)testTransients, null, (String[])excludeFields) > 0 && CompareToBuilder.reflectionCompare((Object)y, (Object)z, (boolean)testTransients, null, (String[])excludeFields) > 0) {
            Assertions.assertTrue((CompareToBuilder.reflectionCompare((Object)x, (Object)z, (boolean)testTransients, null, (String[])excludeFields) > 0 ? 1 : 0) != 0);
        }
        if (CompareToBuilder.reflectionCompare((Object)x, (Object)y, (boolean)testTransients, null, (String[])excludeFields) == 0) {
            Assertions.assertEquals((int)this.reflectionCompareSignum(x, z, testTransients, excludeFields), (int)(-this.reflectionCompareSignum(y, z, testTransients, excludeFields)));
        }
        Assertions.assertTrue((CompareToBuilder.reflectionCompare((Object)x, (Object)y, (boolean)testTransients) == 0 == EqualsBuilder.reflectionEquals((Object)x, (Object)y, (boolean)testTransients) ? 1 : 0) != 0);
    }

    private int reflectionCompareSignum(Object lhs, Object rhs, boolean testTransients, String[] excludeFields) {
        return BigInteger.valueOf(CompareToBuilder.reflectionCompare((Object)lhs, (Object)rhs, (boolean)testTransients)).signum();
    }

    @Test
    public void testAppendSuper() {
        TestObject o1 = new TestObject(4);
        TestObject o2 = new TestObject(5);
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().appendSuper(0).append((Object)o1, (Object)o1).toComparison());
        Assertions.assertTrue((new CompareToBuilder().appendSuper(0).append((Object)o1, (Object)o2).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().appendSuper(0).append((Object)o2, (Object)o1).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().appendSuper(-1).append((Object)o1, (Object)o1).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().appendSuper(-1).append((Object)o1, (Object)o2).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().appendSuper(1).append((Object)o1, (Object)o1).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().appendSuper(1).append((Object)o1, (Object)o2).toComparison() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testObject() {
        TestObject o1 = new TestObject(4);
        TestObject o2 = new TestObject(4);
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)o1, (Object)o1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)o1, (Object)o2).toComparison());
        o2.setA(5);
        Assertions.assertTrue((new CompareToBuilder().append((Object)o1, (Object)o2).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)o2, (Object)o1).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)o1, null).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(null, null).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(null, (Object)o1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testObjectBuild() {
        TestObject o1 = new TestObject(4);
        TestObject o2 = new TestObject(4);
        Assertions.assertEquals((Integer)0, (Integer)new CompareToBuilder().append((Object)o1, (Object)o1).build());
        Assertions.assertEquals((Integer)0, (Integer)new CompareToBuilder().append((Object)o1, (Object)o2).build());
        o2.setA(5);
        Assertions.assertTrue((new CompareToBuilder().append((Object)o1, (Object)o2).build() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)o2, (Object)o1).build() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)o1, null).build() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Integer)0, (Integer)new CompareToBuilder().append(null, null).build());
        Assertions.assertTrue((new CompareToBuilder().append(null, (Object)o1).build() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testObjectEx2() {
        TestObject o1 = new TestObject(4);
        Object o2 = new Object();
        Assertions.assertThrows(ClassCastException.class, () -> new CompareToBuilder().append((Object)o1, o2));
    }

    @Test
    public void testObjectComparator() {
        String o1 = "Fred";
        String o2 = "Fred";
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)"Fred", (Object)"Fred", String.CASE_INSENSITIVE_ORDER).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)"Fred", (Object)o2, String.CASE_INSENSITIVE_ORDER).toComparison());
        o2 = "FRED";
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)"Fred", (Object)o2, String.CASE_INSENSITIVE_ORDER).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)o2, (Object)"Fred", String.CASE_INSENSITIVE_ORDER).toComparison());
        o2 = "FREDA";
        Assertions.assertTrue((new CompareToBuilder().append((Object)"Fred", (Object)o2, String.CASE_INSENSITIVE_ORDER).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)o2, (Object)"Fred", String.CASE_INSENSITIVE_ORDER).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)"Fred", null, String.CASE_INSENSITIVE_ORDER).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(null, null, String.CASE_INSENSITIVE_ORDER).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(null, (Object)"Fred", String.CASE_INSENSITIVE_ORDER).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testObjectComparatorNull() {
        String o1 = "Fred";
        String o2 = "Fred";
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)"Fred", (Object)"Fred", null).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)"Fred", (Object)o2, null).toComparison());
        o2 = "Zebra";
        Assertions.assertTrue((new CompareToBuilder().append((Object)"Fred", (Object)o2, null).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)o2, (Object)"Fred", null).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)"Fred", null, null).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(null, null, null).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(null, (Object)"Fred", null).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLong() {
        long o1 = 1L;
        long o2 = 2L;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(1L, 1L).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(1L, 2L).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(2L, 1L).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(1L, Long.MAX_VALUE).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(Long.MAX_VALUE, 1L).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(1L, Long.MIN_VALUE).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(Long.MIN_VALUE, 1L).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testInt() {
        boolean o1 = true;
        int o2 = 2;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(1, 1).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(1, 2).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(2, 1).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(1, Integer.MAX_VALUE).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(Integer.MAX_VALUE, 1).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(1, Integer.MIN_VALUE).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(Integer.MIN_VALUE, 1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testShort() {
        boolean o1 = true;
        int o2 = 2;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((short)1, (short)1).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((short)1, (short)2).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((short)2, (short)1).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((short)1, (short)Short.MAX_VALUE).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((short)Short.MAX_VALUE, (short)1).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((short)1, (short)Short.MIN_VALUE).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((short)Short.MIN_VALUE, (short)1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testChar() {
        boolean o1 = true;
        int o2 = 2;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append('\u0001', '\u0001').toComparison());
        Assertions.assertTrue((new CompareToBuilder().append('\u0001', '\u0002').toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append('\u0002', '\u0001').toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append('\u0001', '\uffff').toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append('\uffff', '\u0001').toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append('\u0001', '\u0000').toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append('\u0000', '\u0001').toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testByte() {
        boolean o1 = true;
        int o2 = 2;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((byte)1, (byte)1).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((byte)1, (byte)2).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((byte)2, (byte)1).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((byte)1, (byte)127).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((byte)127, (byte)1).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((byte)1, (byte)-128).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((byte)-128, (byte)1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDouble() {
        double o1 = 1.0;
        double o2 = 2.0;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(1.0, 1.0).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(1.0, 2.0).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(2.0, 1.0).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(1.0, Double.MAX_VALUE).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(Double.MAX_VALUE, 1.0).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(1.0, Double.MIN_VALUE).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(Double.MIN_VALUE, 1.0).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(Double.NaN, Double.NaN).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(Double.NaN, Double.MAX_VALUE).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(Double.POSITIVE_INFINITY, Double.MAX_VALUE).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(Double.NEGATIVE_INFINITY, Double.MIN_VALUE).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(1.0, Double.NaN).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(Double.NaN, 1.0).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(-0.0, 0.0).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(0.0, -0.0).toComparison() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFloat() {
        float o1 = 1.0f;
        float o2 = 2.0f;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(1.0f, 1.0f).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(1.0f, 2.0f).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(2.0f, 1.0f).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(1.0f, Float.MAX_VALUE).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(Float.MAX_VALUE, 1.0f).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(1.0f, Float.MIN_VALUE).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(Float.MIN_VALUE, 1.0f).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(Float.NaN, Float.NaN).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(Float.NaN, Float.MAX_VALUE).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(Float.POSITIVE_INFINITY, Float.MAX_VALUE).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(Float.NEGATIVE_INFINITY, Float.MIN_VALUE).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(1.0f, Float.NaN).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(Float.NaN, 1.0f).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(-0.0, 0.0).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(0.0, -0.0).toComparison() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBoolean() {
        boolean o1 = true;
        boolean o2 = false;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(true, true).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(false, false).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(true, false).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(false, true).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testObjectArray() {
        Object[] obj1 = new TestObject[]{new TestObject(4), new TestObject(5)};
        Object[] obj2 = new TestObject[]{new TestObject(4), new TestObject(5)};
        Object[] obj3 = new TestObject[]{new TestObject(4), new TestObject(5), new TestObject(6)};
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj3, obj1).toComparison() > 0 ? 1 : 0) != 0);
        obj1[1] = new TestObject(7);
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj2, obj1).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj1, null).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])null, null).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(null, obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLongArray() {
        long[] obj1 = new long[]{5L, 6L};
        long[] obj2 = new long[]{5L, 6L};
        long[] obj3 = new long[]{5L, 6L, 7L};
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj3, obj1).toComparison() > 0 ? 1 : 0) != 0);
        obj1[1] = 7L;
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj2, obj1).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj1, null).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((long[])null, null).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(null, obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIntArray() {
        int[] obj1 = new int[]{5, 6};
        int[] obj2 = new int[]{5, 6};
        int[] obj3 = new int[]{5, 6, 7};
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj3, obj1).toComparison() > 0 ? 1 : 0) != 0);
        obj1[1] = 7;
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj2, obj1).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj1, null).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((int[])null, null).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(null, obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testShortArray() {
        short[] obj1 = new short[]{5, 6};
        short[] obj2 = new short[]{5, 6};
        short[] obj3 = new short[]{5, 6, 7};
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj3, obj1).toComparison() > 0 ? 1 : 0) != 0);
        obj1[1] = 7;
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj2, obj1).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj1, null).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((short[])null, null).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(null, obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCharArray() {
        char[] obj1 = new char[]{'\u0005', '\u0006'};
        char[] obj2 = new char[]{'\u0005', '\u0006'};
        char[] obj3 = new char[]{'\u0005', '\u0006', '\u0007'};
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj3, obj1).toComparison() > 0 ? 1 : 0) != 0);
        obj1[1] = 7;
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj2, obj1).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj1, null).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((char[])null, null).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(null, obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testByteArray() {
        byte[] obj1 = new byte[]{5, 6};
        byte[] obj2 = new byte[]{5, 6};
        byte[] obj3 = new byte[]{5, 6, 7};
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj3, obj1).toComparison() > 0 ? 1 : 0) != 0);
        obj1[1] = 7;
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj2, obj1).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj1, null).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((byte[])null, null).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(null, obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDoubleArray() {
        double[] obj1 = new double[]{5.0, 6.0};
        double[] obj2 = new double[]{5.0, 6.0};
        double[] obj3 = new double[]{5.0, 6.0, 7.0};
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj3, obj1).toComparison() > 0 ? 1 : 0) != 0);
        obj1[1] = 7.0;
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj2, obj1).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj1, null).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((double[])null, null).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(null, obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFloatArray() {
        float[] obj1 = new float[]{5.0f, 6.0f};
        float[] obj2 = new float[]{5.0f, 6.0f};
        float[] obj3 = new float[]{5.0f, 6.0f, 7.0f};
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj3, obj1).toComparison() > 0 ? 1 : 0) != 0);
        obj1[1] = 7.0f;
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj2, obj1).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj1, null).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((float[])null, null).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(null, obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBooleanArray() {
        boolean[] obj1 = new boolean[]{true, false};
        boolean[] obj2 = new boolean[]{true, false};
        boolean[] obj3 = new boolean[]{true, false, true};
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(obj1, obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj3, obj1).toComparison() > 0 ? 1 : 0) != 0);
        obj1[1] = true;
        Assertions.assertTrue((new CompareToBuilder().append(obj1, obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj2, obj1).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(obj1, null).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((boolean[])null, null).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(null, obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultiLongArray() {
        long[][] array1 = new long[2][2];
        long[][] array2 = new long[2][2];
        long[][] array3 = new long[2][3];
        for (int i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array1[0].length; ++j) {
                array1[i][j] = (i + 1) * (j + 1);
                array2[i][j] = (i + 1) * (j + 1);
                array3[i][j] = (i + 1) * (j + 1);
            }
        }
        array3[1][2] = 100L;
        array3[1][2] = 100L;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array3, (Object[])array1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1][1] = 200L;
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array2, (Object[])array1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultiIntArray() {
        int[][] array1 = new int[2][2];
        int[][] array2 = new int[2][2];
        int[][] array3 = new int[2][3];
        for (int i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array1[0].length; ++j) {
                array1[i][j] = (i + 1) * (j + 1);
                array2[i][j] = (i + 1) * (j + 1);
                array3[i][j] = (i + 1) * (j + 1);
            }
        }
        array3[1][2] = 100;
        array3[1][2] = 100;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array3, (Object[])array1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1][1] = 200;
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array2, (Object[])array1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultiShortArray() {
        short[][] array1 = new short[2][2];
        short[][] array2 = new short[2][2];
        short[][] array3 = new short[2][3];
        for (int i = 0; i < array1.length; i = (int)((short)(i + 1))) {
            for (int j = 0; j < array1[0].length; j = (int)((short)(j + 1))) {
                array1[i][j] = (short)((i + 1) * (j + 1));
                array2[i][j] = (short)((i + 1) * (j + 1));
                array3[i][j] = (short)((i + 1) * (j + 1));
            }
        }
        array3[1][2] = 100;
        array3[1][2] = 100;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array3, (Object[])array1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1][1] = 200;
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array2, (Object[])array1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultiCharArray() {
        char[][] array1 = new char[2][2];
        char[][] array2 = new char[2][2];
        char[][] array3 = new char[2][3];
        for (int i = 0; i < array1.length; i = (int)((short)(i + 1))) {
            for (int j = 0; j < array1[0].length; j = (int)((short)(j + 1))) {
                array1[i][j] = (char)((i + 1) * (j + 1));
                array2[i][j] = (char)((i + 1) * (j + 1));
                array3[i][j] = (char)((i + 1) * (j + 1));
            }
        }
        array3[1][2] = 100;
        array3[1][2] = 100;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array3, (Object[])array1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1][1] = 200;
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array2, (Object[])array1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultiByteArray() {
        byte[][] array1 = new byte[2][2];
        byte[][] array2 = new byte[2][2];
        byte[][] array3 = new byte[2][3];
        for (int i = 0; i < array1.length; i = (int)((byte)(i + 1))) {
            for (int j = 0; j < array1[0].length; j = (int)((byte)(j + 1))) {
                array1[i][j] = (byte)((i + 1) * (j + 1));
                array2[i][j] = (byte)((i + 1) * (j + 1));
                array3[i][j] = (byte)((i + 1) * (j + 1));
            }
        }
        array3[1][2] = 100;
        array3[1][2] = 100;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array3, (Object[])array1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1][1] = 127;
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array2, (Object[])array1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultiFloatArray() {
        float[][] array1 = new float[2][2];
        float[][] array2 = new float[2][2];
        float[][] array3 = new float[2][3];
        for (int i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array1[0].length; ++j) {
                array1[i][j] = (i + 1) * (j + 1);
                array2[i][j] = (i + 1) * (j + 1);
                array3[i][j] = (i + 1) * (j + 1);
            }
        }
        array3[1][2] = 100.0f;
        array3[1][2] = 100.0f;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array3, (Object[])array1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1][1] = 127.0f;
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array2, (Object[])array1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultiDoubleArray() {
        double[][] array1 = new double[2][2];
        double[][] array2 = new double[2][2];
        double[][] array3 = new double[2][3];
        for (int i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array1[0].length; ++j) {
                array1[i][j] = (i + 1) * (j + 1);
                array2[i][j] = (i + 1) * (j + 1);
                array3[i][j] = (i + 1) * (j + 1);
            }
        }
        array3[1][2] = 100.0;
        array3[1][2] = 100.0;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array3, (Object[])array1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1][1] = 127.0;
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array2, (Object[])array1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultiBooleanArray() {
        boolean[][] array1 = new boolean[2][2];
        boolean[][] array2 = new boolean[2][2];
        boolean[][] array3 = new boolean[2][3];
        for (int i = 0; i < array1.length; ++i) {
            for (int j = 0; j < array1[0].length; ++j) {
                array1[i][j] = i == 1 ^ j == 1;
                array2[i][j] = i == 1 ^ j == 1;
                array3[i][j] = i == 1 ^ j == 1;
            }
        }
        array3[1][2] = false;
        array3[1][2] = false;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array3, (Object[])array1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1][1] = true;
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array2, (Object[])array1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRaggedArray() {
        long[][] array1 = new long[2][];
        long[][] array2 = new long[2][];
        long[][] array3 = new long[3][];
        for (int i = 0; i < array1.length; ++i) {
            array1[i] = new long[2];
            array2[i] = new long[2];
            array3[i] = new long[3];
            for (int j = 0; j < array1[i].length; ++j) {
                array1[i][j] = (i + 1) * (j + 1);
                array2[i][j] = (i + 1) * (j + 1);
                array3[i][j] = (i + 1) * (j + 1);
            }
        }
        array3[1][2] = 100L;
        array3[1][2] = 100L;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array3, (Object[])array1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1][1] = 200L;
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array1, (Object[])array2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object[])array2, (Object[])array1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMixedArray() {
        Object[] array1 = new Object[2];
        Object[] array2 = new Object[2];
        Object[] array3 = new Object[2];
        for (int i = 0; i < array1.length; ++i) {
            array1[i] = new long[2];
            array2[i] = new long[2];
            array3[i] = new long[3];
            for (int j = 0; j < 2; ++j) {
                ((long[])array1[i])[j] = (i + 1) * (j + 1);
                ((long[])array2[i])[j] = (i + 1) * (j + 1);
                ((long[])array3[i])[j] = (i + 1) * (j + 1);
            }
        }
        ((long[])array3[0])[2] = 1L;
        ((long[])array3[1])[2] = 1L;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(array1, array1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append(array1, array2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append(array1, array3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(array3, array1).toComparison() > 0 ? 1 : 0) != 0);
        ((long[])array1[1])[1] = 200L;
        Assertions.assertTrue((new CompareToBuilder().append(array1, array2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append(array2, array1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testObjectArrayHiddenByObject() {
        TestObject[] array1 = new TestObject[]{new TestObject(4), new TestObject(5)};
        TestObject[] array2 = new TestObject[]{new TestObject(4), new TestObject(5)};
        TestObject[] array3 = new TestObject[]{new TestObject(4), new TestObject(5), new TestObject(6)};
        TestObject[] obj1 = array1;
        TestObject[] obj2 = array2;
        TestObject[] obj3 = array3;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj3, (Object)obj1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1] = new TestObject(7);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj2, (Object)obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLongArrayHiddenByObject() {
        long[] array1 = new long[]{5L, 6L};
        long[] array2 = new long[]{5L, 6L};
        long[] array3 = new long[]{5L, 6L, 7L};
        long[] obj1 = array1;
        long[] obj2 = array2;
        long[] obj3 = array3;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj3, (Object)obj1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1] = 7L;
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj2, (Object)obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIntArrayHiddenByObject() {
        int[] array1 = new int[]{5, 6};
        int[] array2 = new int[]{5, 6};
        int[] array3 = new int[]{5, 6, 7};
        int[] obj1 = array1;
        int[] obj2 = array2;
        int[] obj3 = array3;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj3, (Object)obj1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1] = 7;
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj2, (Object)obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testShortArrayHiddenByObject() {
        short[] array1 = new short[]{5, 6};
        short[] array2 = new short[]{5, 6};
        short[] array3 = new short[]{5, 6, 7};
        short[] obj1 = array1;
        short[] obj2 = array2;
        short[] obj3 = array3;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj3, (Object)obj1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1] = 7;
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj2, (Object)obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCharArrayHiddenByObject() {
        char[] array1 = new char[]{'\u0005', '\u0006'};
        char[] array2 = new char[]{'\u0005', '\u0006'};
        char[] array3 = new char[]{'\u0005', '\u0006', '\u0007'};
        char[] obj1 = array1;
        char[] obj2 = array2;
        char[] obj3 = array3;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj3, (Object)obj1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1] = 7;
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj2, (Object)obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testByteArrayHiddenByObject() {
        byte[] array1 = new byte[]{5, 6};
        byte[] array2 = new byte[]{5, 6};
        byte[] array3 = new byte[]{5, 6, 7};
        byte[] obj1 = array1;
        byte[] obj2 = array2;
        byte[] obj3 = array3;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj3, (Object)obj1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1] = 7;
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj2, (Object)obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDoubleArrayHiddenByObject() {
        double[] array1 = new double[]{5.0, 6.0};
        double[] array2 = new double[]{5.0, 6.0};
        double[] array3 = new double[]{5.0, 6.0, 7.0};
        double[] obj1 = array1;
        double[] obj2 = array2;
        double[] obj3 = array3;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj3, (Object)obj1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1] = 7.0;
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj2, (Object)obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFloatArrayHiddenByObject() {
        float[] array1 = new float[]{5.0f, 6.0f};
        float[] array2 = new float[]{5.0f, 6.0f};
        float[] array3 = new float[]{5.0f, 6.0f, 7.0f};
        float[] obj1 = array1;
        float[] obj2 = array2;
        float[] obj3 = array3;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj3, (Object)obj1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1] = 7.0f;
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj2, (Object)obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBooleanArrayHiddenByObject() {
        boolean[] array1 = new boolean[]{true, false};
        boolean[] array2 = new boolean[]{true, false};
        boolean[] array3 = new boolean[]{true, false, true};
        boolean[] obj1 = array1;
        boolean[] obj2 = array2;
        boolean[] obj3 = array3;
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj1).toComparison());
        Assertions.assertEquals((int)0, (int)new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison());
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj3).toComparison() < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj3, (Object)obj1).toComparison() > 0 ? 1 : 0) != 0);
        array1[1] = true;
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj1, (Object)obj2).toComparison() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new CompareToBuilder().append((Object)obj2, (Object)obj1).toComparison() < 0 ? 1 : 0) != 0);
    }

    static class TestTransientSubObject
    extends TestObject {
        private transient int t;

        TestTransientSubObject(int a, int t) {
            super(a);
            this.t = t;
        }
    }

    static class TestSubObject
    extends TestObject {
        private int b;

        TestSubObject() {
            super(0);
        }

        TestSubObject(int a, int b) {
            super(a);
            this.b = b;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestSubObject)) {
                return false;
            }
            TestSubObject rhs = (TestSubObject)o;
            return super.equals(o) && this.b == rhs.b;
        }
    }

    static class TestObject
    implements Comparable<TestObject> {
        private int a;

        TestObject(int a) {
            this.a = a;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestObject)) {
                return false;
            }
            TestObject rhs = (TestObject)o;
            return this.a == rhs.a;
        }

        public int hashCode() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getA() {
            return this.a;
        }

        @Override
        public int compareTo(TestObject rhs) {
            return Integer.compare(this.a, rhs.a);
        }
    }
}

