/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp2.DelegatingPreparedStatement;
import org.apache.commons.dbcp2.TestBasicDataSource;
import org.apache.commons.dbcp2.TesterPreparedStatement;

public class TestPStmtPoolingBasicDataSource
extends TestBasicDataSource {
    public TestPStmtPoolingBasicDataSource(String testName) {
        super(testName);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ds.setPoolPreparedStatements(true);
        this.ds.setMaxOpenPreparedStatements(2);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPreparedStatementPooling() throws Exception {
        Connection conn = this.getConnection();
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)conn);
        PreparedStatement stmt1 = conn.prepareStatement("select 'a' from dual");
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)stmt1);
        PreparedStatement stmt2 = conn.prepareStatement("select 'b' from dual");
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)stmt2);
        TestPStmtPoolingBasicDataSource.assertTrue((stmt1 != stmt2 ? 1 : 0) != 0);
        PreparedStatement stmt3 = null;
        try (PreparedStatement ps = conn.prepareStatement("select 'c' from dual");){
            TestPStmtPoolingBasicDataSource.fail((String)"expected SQLException");
        }
        catch (SQLException e) {
            // empty catch block
        }
        stmt2.close();
        stmt3 = conn.prepareStatement("select 'c' from dual");
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)stmt3);
        TestPStmtPoolingBasicDataSource.assertTrue((stmt3 != stmt1 ? 1 : 0) != 0);
        TestPStmtPoolingBasicDataSource.assertTrue((stmt3 != stmt2 ? 1 : 0) != 0);
        stmt1.close();
        PreparedStatement stmt4 = conn.prepareStatement("select 'a' from dual");
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)stmt4);
    }

    public void testLRUBehavior() throws Exception {
        this.ds.setMaxOpenPreparedStatements(3);
        Connection conn = this.getConnection();
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)conn);
        PreparedStatement stmt1 = conn.prepareStatement("select 'a' from dual");
        PreparedStatement inner1 = (PreparedStatement)((DelegatingPreparedStatement)stmt1).getInnermostDelegate();
        PreparedStatement stmt2 = conn.prepareStatement("select 'b' from dual");
        PreparedStatement inner2 = (PreparedStatement)((DelegatingPreparedStatement)stmt2).getInnermostDelegate();
        PreparedStatement stmt3 = conn.prepareStatement("select 'c' from dual");
        PreparedStatement inner3 = (PreparedStatement)((DelegatingPreparedStatement)stmt3).getInnermostDelegate();
        stmt1.close();
        Thread.sleep(100L);
        stmt2.close();
        Thread.sleep(100L);
        stmt3.close();
        PreparedStatement stmt4 = conn.prepareStatement("select 'd' from dual");
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)stmt4);
        try {
            inner1.clearParameters();
            TestPStmtPoolingBasicDataSource.fail((String)"expecting SQLExcption - statement should be closed");
        }
        catch (SQLException ex) {
            // empty catch block
        }
        inner2.clearParameters();
        inner3.clearParameters();
        PreparedStatement stmt5 = conn.prepareStatement("select 'a' from dual");
        PreparedStatement inner5 = (PreparedStatement)((DelegatingPreparedStatement)stmt5).getInnermostDelegate();
        TestPStmtPoolingBasicDataSource.assertNotSame((Object)inner5, (Object)inner1);
        try {
            inner2.clearParameters();
            TestPStmtPoolingBasicDataSource.fail((String)"expecting SQLExcption - statement should be closed");
        }
        catch (SQLException ex) {
            // empty catch block
        }
        inner3.clearParameters();
    }

    public void testPStmtCatalog() throws Exception {
        Connection conn = this.getConnection();
        conn.setCatalog("catalog1");
        DelegatingPreparedStatement stmt1 = (DelegatingPreparedStatement)conn.prepareStatement("select 'a' from dual");
        TesterPreparedStatement inner1 = (TesterPreparedStatement)stmt1.getInnermostDelegate();
        TestPStmtPoolingBasicDataSource.assertEquals((String)"catalog1", (String)inner1.getCatalog());
        stmt1.close();
        conn.setCatalog("catalog2");
        DelegatingPreparedStatement stmt2 = (DelegatingPreparedStatement)conn.prepareStatement("select 'a' from dual");
        TesterPreparedStatement inner2 = (TesterPreparedStatement)stmt2.getInnermostDelegate();
        TestPStmtPoolingBasicDataSource.assertEquals((String)"catalog2", (String)inner2.getCatalog());
        stmt2.close();
        conn.setCatalog("catalog1");
        DelegatingPreparedStatement stmt3 = (DelegatingPreparedStatement)conn.prepareStatement("select 'a' from dual");
        TesterPreparedStatement inner3 = (TesterPreparedStatement)stmt3.getInnermostDelegate();
        TestPStmtPoolingBasicDataSource.assertEquals((String)"catalog1", (String)inner3.getCatalog());
        stmt3.close();
        TestPStmtPoolingBasicDataSource.assertNotSame((Object)inner1, (Object)inner2);
        TestPStmtPoolingBasicDataSource.assertSame((Object)inner1, (Object)inner3);
    }

    public void testPStmtPoolingWithNoClose() throws Exception {
        this.ds.setMaxTotal(1);
        this.ds.setMaxIdle(1);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection conn1 = this.getConnection();
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)conn1);
        TestPStmtPoolingBasicDataSource.assertEquals((int)1, (int)this.ds.getNumActive());
        TestPStmtPoolingBasicDataSource.assertEquals((int)0, (int)this.ds.getNumIdle());
        PreparedStatement stmt1 = conn1.prepareStatement("select 'a' from dual");
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)stmt1);
        Statement inner1 = ((DelegatingPreparedStatement)stmt1).getInnermostDelegate();
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)inner1);
        stmt1.close();
        Connection conn2 = conn1;
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)conn2);
        TestPStmtPoolingBasicDataSource.assertEquals((int)1, (int)this.ds.getNumActive());
        TestPStmtPoolingBasicDataSource.assertEquals((int)0, (int)this.ds.getNumIdle());
        PreparedStatement stmt2 = conn2.prepareStatement("select 'a' from dual");
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)stmt2);
        Statement inner2 = ((DelegatingPreparedStatement)stmt2).getInnermostDelegate();
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)inner2);
        TestPStmtPoolingBasicDataSource.assertSame((Object)inner1, (Object)inner2);
    }

    public void testPStmtPoolingAccrossClose() throws Exception {
        this.ds.setMaxTotal(1);
        this.ds.setMaxIdle(1);
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection conn1 = this.getConnection();
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)conn1);
        TestPStmtPoolingBasicDataSource.assertEquals((int)1, (int)this.ds.getNumActive());
        TestPStmtPoolingBasicDataSource.assertEquals((int)0, (int)this.ds.getNumIdle());
        PreparedStatement stmt1 = conn1.prepareStatement("select 'a' from dual");
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)stmt1);
        Statement inner1 = ((DelegatingPreparedStatement)stmt1).getInnermostDelegate();
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)inner1);
        stmt1.close();
        conn1.close();
        TestPStmtPoolingBasicDataSource.assertEquals((int)0, (int)this.ds.getNumActive());
        TestPStmtPoolingBasicDataSource.assertEquals((int)1, (int)this.ds.getNumIdle());
        Connection conn2 = this.getConnection();
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)conn2);
        TestPStmtPoolingBasicDataSource.assertEquals((int)1, (int)this.ds.getNumActive());
        TestPStmtPoolingBasicDataSource.assertEquals((int)0, (int)this.ds.getNumIdle());
        PreparedStatement stmt2 = conn2.prepareStatement("select 'a' from dual");
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)stmt2);
        Statement inner2 = ((DelegatingPreparedStatement)stmt2).getInnermostDelegate();
        TestPStmtPoolingBasicDataSource.assertNotNull((Object)inner2);
        TestPStmtPoolingBasicDataSource.assertSame((Object)inner1, (Object)inner2);
    }

    public void testMultipleThreads1() throws Exception {
        this.ds.setMaxWaitMillis(-1L);
        this.ds.setMaxTotal(5);
        this.ds.setMaxOpenPreparedStatements(-1);
        this.multipleThreads(5, false, false, -1L, 3, 100, 10000L);
    }
}

