/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.lz4.XXHash32;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class XXHash32Test {
    private final File file;
    private final String expectedChecksum;

    public XXHash32Test(String fileName, String c) throws IOException {
        this.file = AbstractTestCase.getFile(fileName);
        this.expectedChecksum = c;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> factory() {
        return Arrays.asList({"bla.tar", "fbb5c8d1"}, {"bla.tar.xz", "4106a208"}, {"8.posix.tar.gz", "9fce116a"});
    }

    @Test
    public void verifyChecksum() throws IOException {
        XXHash32 h = new XXHash32();
        try (InputStream s = Files.newInputStream(this.file.toPath(), new OpenOption[0]);){
            byte[] b = IOUtils.toByteArray((InputStream)s);
            h.update(b, 0, b.length);
        }
        Assert.assertEquals((String)("checksum for " + this.file.getName()), (Object)this.expectedChecksum, (Object)Long.toHexString(h.getValue()));
    }
}

