/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.deflate64;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.compress.compressors.deflate64.HuffmanDecoder;
import org.junit.Assert;
import org.junit.Test;

public class HuffmanDecoderTest {
    @Test
    public void decodeUncompressedBlock() throws Exception {
        byte[] data = new byte[]{1, 11, 0, -12, -1, 72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100};
        HuffmanDecoder decoder = new HuffmanDecoder((InputStream)new ByteArrayInputStream(data));
        byte[] result = new byte[100];
        int len = decoder.decode(result);
        Assert.assertEquals((long)11L, (long)len);
        Assert.assertEquals((Object)"Hello World", (Object)new String(result, 0, len));
    }

    @Test
    public void decodeUncompressedBlockWithInvalidLenNLenValue() throws Exception {
        byte[] data = new byte[]{1, 11, 0, -12, -2, 72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100};
        HuffmanDecoder decoder = new HuffmanDecoder((InputStream)new ByteArrayInputStream(data));
        byte[] result = new byte[100];
        try {
            int len = decoder.decode(result);
            Assert.fail((String)("Should have failed but returned " + len + " entries: " + Arrays.toString(Arrays.copyOf(result, len))));
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"Illegal LEN / NLEN values", (Object)e.getMessage());
        }
    }

    @Test
    public void decodeSimpleFixedHuffmanBlock() throws Exception {
        byte[] data = new byte[]{-13, 72, -51, -55, -55, 87, 8, -49, 47, -54, 73, 1, -4};
        HuffmanDecoder decoder = new HuffmanDecoder((InputStream)new ByteArrayInputStream(data));
        byte[] result = new byte[100];
        int len = decoder.decode(result);
        Assert.assertEquals((long)11L, (long)len);
        Assert.assertEquals((Object)"Hello World", (Object)new String(result, 0, len));
    }

    @Test
    public void decodeSimpleFixedHuffmanBlockToSmallBuffer() throws Exception {
        byte[] data = new byte[]{-13, 72, -51, -55, -55, 87, 8, -49, 47, -54, 73, 1, -4};
        HuffmanDecoder decoder = new HuffmanDecoder((InputStream)new ByteArrayInputStream(data));
        byte[] result = new byte[10];
        int len = decoder.decode(result);
        Assert.assertEquals((long)10L, (long)len);
        Assert.assertEquals((Object)"Hello Worl", (Object)new String(result, 0, len));
        len = decoder.decode(result);
        Assert.assertEquals((long)1L, (long)len);
        Assert.assertEquals((Object)"d", (Object)new String(result, 0, len));
    }

    @Test
    public void decodeFixedHuffmanBlockWithMemoryLookup() throws Exception {
        byte[] data = new byte[]{-13, 72, -51, -55, -55, 87, 8, -49, 47, -54, 73, -31, 34, -122, 13, -8};
        HuffmanDecoder decoder = new HuffmanDecoder((InputStream)new ByteArrayInputStream(data));
        byte[] result = new byte[100];
        int len = decoder.decode(result);
        Assert.assertEquals((long)48L, (long)len);
        Assert.assertEquals((Object)"Hello World\nHello World\nHello World\nHello World\n", (Object)new String(result, 0, len));
    }

    @Test
    public void decodeFixedHuffmanBlockWithMemoryLookupInSmallBuffer() throws Exception {
        byte[] data = new byte[]{-13, 72, -51, -55, -55, 87, 8, -49, 47, -54, 73, -31, 34, -122, 13, -8};
        HuffmanDecoder decoder = new HuffmanDecoder((InputStream)new ByteArrayInputStream(data));
        byte[] result = new byte[30];
        int len = decoder.decode(result);
        Assert.assertEquals((long)30L, (long)len);
        Assert.assertEquals((Object)"Hello World\nHello World\nHello ", (Object)new String(result, 0, len));
        len = decoder.decode(result);
        Assert.assertEquals((long)18L, (long)len);
        Assert.assertEquals((Object)"World\nHello World\n", (Object)new String(result, 0, len));
    }

    @Test
    public void decodeFixedHuffmanBlockWithMemoryLookupInExactBuffer() throws Exception {
        byte[] data = new byte[]{-13, 72, -51, -55, -55, 87, 8, -49, 47, -54, 73, -31, 34, -122, 13, -8};
        HuffmanDecoder decoder = new HuffmanDecoder((InputStream)new ByteArrayInputStream(data));
        byte[] result = new byte[48];
        int len = decoder.decode(result);
        Assert.assertEquals((long)48L, (long)len);
        Assert.assertEquals((Object)"Hello World\nHello World\nHello World\nHello World\n", (Object)new String(result, 0, len));
        len = decoder.decode(result);
        Assert.assertEquals((long)-1L, (long)len);
    }
}

