/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveStructSparse;
import org.apache.commons.compress.archivers.tar.TarFile;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class SparseFilesTest
extends AbstractTestCase {
    private final boolean isOnWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");

    @Test
    public void testOldGNU() throws Throwable {
        File file = SparseFilesTest.getFile("oldgnu_sparse.tar");
        try (TarArchiveInputStream tin = new TarArchiveInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            TarArchiveEntry ae = tin.getNextTarEntry();
            Assert.assertEquals((Object)"sparsefile", (Object)ae.getName());
            Assert.assertTrue((boolean)ae.isOldGNUSparse());
            Assert.assertTrue((boolean)ae.isGNUSparse());
            Assert.assertFalse((boolean)ae.isPaxGNUSparse());
            Assert.assertTrue((boolean)tin.canReadEntryData((ArchiveEntry)ae));
            List sparseHeaders = ae.getSparseHeaders();
            Assert.assertEquals((long)4L, (long)sparseHeaders.size());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getOffset());
            Assert.assertEquals((long)2048L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getNumbytes());
            Assert.assertEquals((long)0x100800L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getOffset());
            Assert.assertEquals((long)2560L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getNumbytes());
            Assert.assertEquals((long)3101184L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getOffset());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getNumbytes());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getOffset());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getNumbytes());
            List sparseOrderedHeaders = ae.getOrderedSparseHeaders();
            Assert.assertEquals((long)3L, (long)sparseOrderedHeaders.size());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(0)).getOffset());
            Assert.assertEquals((long)2048L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(0)).getNumbytes());
            Assert.assertEquals((long)0x100800L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(1)).getOffset());
            Assert.assertEquals((long)2560L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(1)).getNumbytes());
            Assert.assertEquals((long)3101184L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(2)).getOffset());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(2)).getNumbytes());
        }
    }

    @Test
    public void testTarFileOldGNU() throws Throwable {
        File file = SparseFilesTest.getFile("oldgnu_sparse.tar");
        try (TarFile tarFile = new TarFile(file);){
            TarArchiveEntry ae = (TarArchiveEntry)tarFile.getEntries().get(0);
            Assert.assertEquals((Object)"sparsefile", (Object)ae.getName());
            Assert.assertTrue((boolean)ae.isOldGNUSparse());
            Assert.assertTrue((boolean)ae.isGNUSparse());
            Assert.assertFalse((boolean)ae.isPaxGNUSparse());
            List sparseHeaders = ae.getSparseHeaders();
            Assert.assertEquals((long)4L, (long)sparseHeaders.size());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getOffset());
            Assert.assertEquals((long)2048L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getNumbytes());
            Assert.assertEquals((long)0x100800L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getOffset());
            Assert.assertEquals((long)2560L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getNumbytes());
            Assert.assertEquals((long)3101184L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getOffset());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getNumbytes());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getOffset());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getNumbytes());
            List sparseOrderedHeaders = ae.getOrderedSparseHeaders();
            Assert.assertEquals((long)3L, (long)sparseOrderedHeaders.size());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(0)).getOffset());
            Assert.assertEquals((long)2048L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(0)).getNumbytes());
            Assert.assertEquals((long)0x100800L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(1)).getOffset());
            Assert.assertEquals((long)2560L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(1)).getNumbytes());
            Assert.assertEquals((long)3101184L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(2)).getOffset());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseOrderedHeaders.get(2)).getNumbytes());
        }
    }

    @Test
    public void testPaxGNU() throws Throwable {
        File file = SparseFilesTest.getFile("pax_gnu_sparse.tar");
        try (TarArchiveInputStream tin = new TarArchiveInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            this.assertPaxGNUEntry(tin, "0.0");
            this.assertPaxGNUEntry(tin, "0.1");
            this.assertPaxGNUEntry(tin, "1.0");
        }
    }

    @Test
    public void testTarFilePaxGNU() throws IOException {
        File file = SparseFilesTest.getFile("pax_gnu_sparse.tar");
        try (TarFile tarFile = new TarFile(file);){
            List entries = tarFile.getEntries();
            this.assertPaxGNUEntry((TarArchiveEntry)entries.get(0), "0.0");
            this.assertPaxGNUEntry((TarArchiveEntry)entries.get(1), "0.1");
            this.assertPaxGNUEntry((TarArchiveEntry)entries.get(2), "1.0");
        }
    }

    private void assertPaxGNUEntry(TarArchiveEntry entry, String suffix) {
        Assert.assertEquals((Object)("sparsefile-" + suffix), (Object)entry.getName());
        Assert.assertTrue((boolean)entry.isGNUSparse());
        Assert.assertTrue((boolean)entry.isPaxGNUSparse());
        Assert.assertFalse((boolean)entry.isOldGNUSparse());
        List sparseHeaders = entry.getSparseHeaders();
        Assert.assertEquals((long)3L, (long)sparseHeaders.size());
        Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getOffset());
        Assert.assertEquals((long)2048L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getNumbytes());
        Assert.assertEquals((long)0x100800L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getOffset());
        Assert.assertEquals((long)2560L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getNumbytes());
        Assert.assertEquals((long)3101184L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getOffset());
        Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getNumbytes());
    }

    @Test
    public void testExtractSparseTarsOnWindows() throws IOException {
        Assume.assumeTrue((String)"This test should be ignored if not running on Windows", (boolean)this.isOnWindows);
        File oldGNUSparseTar = SparseFilesTest.getFile("oldgnu_sparse.tar");
        File paxGNUSparseTar = SparseFilesTest.getFile("pax_gnu_sparse.tar");
        try (TarArchiveInputStream paxGNUSparseInputStream = new TarArchiveInputStream(Files.newInputStream(paxGNUSparseTar.toPath(), new OpenOption[0]));){
            TarArchiveEntry oldGNUEntry;
            TarArchiveEntry paxGNUEntry = paxGNUSparseInputStream.getNextTarEntry();
            Assert.assertTrue((boolean)paxGNUSparseInputStream.canReadEntryData((ArchiveEntry)paxGNUEntry));
            try (TarArchiveInputStream oldGNUSparseInputStream = new TarArchiveInputStream(Files.newInputStream(oldGNUSparseTar.toPath(), new OpenOption[0]));){
                oldGNUEntry = oldGNUSparseInputStream.getNextTarEntry();
                Assert.assertTrue((boolean)oldGNUSparseInputStream.canReadEntryData((ArchiveEntry)oldGNUEntry));
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)oldGNUSparseInputStream), (byte[])IOUtils.toByteArray((InputStream)paxGNUSparseInputStream));
            }
            paxGNUEntry = paxGNUSparseInputStream.getNextTarEntry();
            Assert.assertTrue((boolean)paxGNUSparseInputStream.canReadEntryData((ArchiveEntry)paxGNUEntry));
            oldGNUSparseInputStream = new TarArchiveInputStream(Files.newInputStream(oldGNUSparseTar.toPath(), new OpenOption[0]));
            var7_9 = null;
            try {
                oldGNUEntry = oldGNUSparseInputStream.getNextTarEntry();
                Assert.assertTrue((boolean)oldGNUSparseInputStream.canReadEntryData((ArchiveEntry)oldGNUEntry));
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)oldGNUSparseInputStream), (byte[])IOUtils.toByteArray((InputStream)paxGNUSparseInputStream));
            }
            catch (Throwable oldGNUEntry2) {
                var7_9 = oldGNUEntry2;
                throw oldGNUEntry2;
            }
            finally {
                if (oldGNUSparseInputStream != null) {
                    if (var7_9 != null) {
                        try {
                            oldGNUSparseInputStream.close();
                        }
                        catch (Throwable oldGNUEntry2) {
                            var7_9.addSuppressed(oldGNUEntry2);
                        }
                    } else {
                        oldGNUSparseInputStream.close();
                    }
                }
            }
            paxGNUEntry = paxGNUSparseInputStream.getNextTarEntry();
            Assert.assertTrue((boolean)paxGNUSparseInputStream.canReadEntryData((ArchiveEntry)paxGNUEntry));
            oldGNUSparseInputStream = new TarArchiveInputStream(Files.newInputStream(oldGNUSparseTar.toPath(), new OpenOption[0]));
            var7_9 = null;
            try {
                oldGNUEntry = oldGNUSparseInputStream.getNextTarEntry();
                Assert.assertTrue((boolean)oldGNUSparseInputStream.canReadEntryData((ArchiveEntry)oldGNUEntry));
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)oldGNUSparseInputStream), (byte[])IOUtils.toByteArray((InputStream)paxGNUSparseInputStream));
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
            finally {
                if (oldGNUSparseInputStream != null) {
                    if (var7_9 != null) {
                        try {
                            oldGNUSparseInputStream.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        oldGNUSparseInputStream.close();
                    }
                }
            }
        }
    }

    @Test
    public void testTarFileExtractSparseTarsOnWindows() throws IOException {
        Assume.assumeTrue((String)"Only run test on Windows", (boolean)this.isOnWindows);
        File oldGNUSparseTar = SparseFilesTest.getFile("oldgnu_sparse.tar");
        File paxGNUSparseTar = SparseFilesTest.getFile("pax_gnu_sparse.tar");
        try (TarFile paxGnu = new TarFile(paxGNUSparseTar);){
            Throwable throwable;
            InputStream pax2;
            Throwable throwable2;
            InputStream old;
            TarArchiveEntry oldGnuEntry;
            List entries = paxGnu.getEntries();
            TarArchiveEntry paxGnuEntry = (TarArchiveEntry)entries.get(0);
            try (TarFile oldGnu = new TarFile(oldGNUSparseTar);){
                oldGnuEntry = (TarArchiveEntry)oldGnu.getEntries().get(0);
                old = oldGnu.getInputStream(oldGnuEntry);
                throwable2 = null;
                try {
                    pax2 = paxGnu.getInputStream(paxGnuEntry);
                    throwable = null;
                    try {
                        Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)old), (byte[])IOUtils.toByteArray((InputStream)pax2));
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (pax2 != null) {
                            if (throwable != null) {
                                try {
                                    pax2.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                pax2.close();
                            }
                        }
                    }
                }
                catch (Throwable pax2) {
                    throwable2 = pax2;
                    throw pax2;
                }
                finally {
                    if (old != null) {
                        if (throwable2 != null) {
                            try {
                                old.close();
                            }
                            catch (Throwable pax2) {
                                throwable2.addSuppressed(pax2);
                            }
                        } else {
                            old.close();
                        }
                    }
                }
            }
            paxGnuEntry = (TarArchiveEntry)entries.get(1);
            oldGnu = new TarFile(oldGNUSparseTar);
            var8_10 = null;
            try {
                oldGnuEntry = (TarArchiveEntry)oldGnu.getEntries().get(0);
                old = oldGnu.getInputStream(oldGnuEntry);
                throwable2 = null;
                try {
                    pax2 = paxGnu.getInputStream(paxGnuEntry);
                    throwable = null;
                    try {
                        Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)old), (byte[])IOUtils.toByteArray((InputStream)pax2));
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (pax2 != null) {
                            if (throwable != null) {
                                try {
                                    pax2.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                pax2.close();
                            }
                        }
                    }
                }
                catch (Throwable pax3) {
                    throwable2 = pax3;
                    throw pax3;
                }
                finally {
                    if (old != null) {
                        if (throwable2 != null) {
                            try {
                                old.close();
                            }
                            catch (Throwable pax3) {
                                throwable2.addSuppressed(pax3);
                            }
                        } else {
                            old.close();
                        }
                    }
                }
            }
            catch (Throwable oldGnuEntry2) {
                var8_10 = oldGnuEntry2;
                throw oldGnuEntry2;
            }
            finally {
                if (oldGnu != null) {
                    if (var8_10 != null) {
                        try {
                            oldGnu.close();
                        }
                        catch (Throwable oldGnuEntry2) {
                            var8_10.addSuppressed(oldGnuEntry2);
                        }
                    } else {
                        oldGnu.close();
                    }
                }
            }
            paxGnuEntry = (TarArchiveEntry)entries.get(2);
            oldGnu = new TarFile(oldGNUSparseTar);
            var8_10 = null;
            try {
                oldGnuEntry = (TarArchiveEntry)oldGnu.getEntries().get(0);
                old = oldGnu.getInputStream(oldGnuEntry);
                throwable2 = null;
                try {
                    pax2 = paxGnu.getInputStream(paxGnuEntry);
                    throwable = null;
                    try {
                        Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)old), (byte[])IOUtils.toByteArray((InputStream)pax2));
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (pax2 != null) {
                            if (throwable != null) {
                                try {
                                    pax2.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                            } else {
                                pax2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable9) {
                    throwable2 = throwable9;
                    throw throwable9;
                }
                finally {
                    if (old != null) {
                        if (throwable2 != null) {
                            try {
                                old.close();
                            }
                            catch (Throwable throwable10) {
                                throwable2.addSuppressed(throwable10);
                            }
                        } else {
                            old.close();
                        }
                    }
                }
            }
            catch (Throwable throwable11) {
                var8_10 = throwable11;
                throw throwable11;
            }
            finally {
                if (oldGnu != null) {
                    if (var8_10 != null) {
                        try {
                            oldGnu.close();
                        }
                        catch (Throwable throwable12) {
                            var8_10.addSuppressed(throwable12);
                        }
                    } else {
                        oldGnu.close();
                    }
                }
            }
        }
    }

    @Test
    public void testExtractOldGNU() throws IOException, InterruptedException {
        Assume.assumeFalse((String)"This test should be ignored on Windows", (boolean)this.isOnWindows);
        try {
            File file = SparseFilesTest.getFile("oldgnu_sparse.tar");
            try (InputStream sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile");
                 TarArchiveInputStream tin = new TarArchiveInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                TarArchiveEntry entry = tin.getNextTarEntry();
                Assert.assertTrue((boolean)tin.canReadEntryData((ArchiveEntry)entry));
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tin), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            }
        }
        catch (IOException | RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    @Test
    public void testTarFileExtractOldGNU() throws IOException, InterruptedException {
        Assume.assumeFalse((String)"Don't run test on Windows", (boolean)this.isOnWindows);
        File file = SparseFilesTest.getFile("oldgnu_sparse.tar");
        try (InputStream sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile");
             TarFile tarFile = new TarFile(file);){
            TarArchiveEntry entry = (TarArchiveEntry)tarFile.getEntries().get(0);
            try (InputStream tarInput = tarFile.getInputStream(entry);){
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tarInput), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            }
        }
    }

    @Test
    public void testExtractExtendedOldGNU() throws IOException, InterruptedException {
        Assume.assumeFalse((String)"This test should be ignored on Windows", (boolean)this.isOnWindows);
        File file = SparseFilesTest.getFile("oldgnu_extended_sparse.tar");
        try (InputStream sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparse6");
             TarArchiveInputStream tin = new TarArchiveInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            TarArchiveEntry ae = tin.getNextTarEntry();
            Assert.assertTrue((boolean)tin.canReadEntryData((ArchiveEntry)ae));
            Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tin), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            List sparseHeaders = ae.getOrderedSparseHeaders();
            Assert.assertEquals((long)7L, (long)sparseHeaders.size());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getNumbytes());
            Assert.assertEquals((long)10240L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getNumbytes());
            Assert.assertEquals((long)16384L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getNumbytes());
            Assert.assertEquals((long)24576L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getNumbytes());
            Assert.assertEquals((long)29696L, (long)((TarArchiveStructSparse)sparseHeaders.get(4)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(4)).getNumbytes());
            Assert.assertEquals((long)36864L, (long)((TarArchiveStructSparse)sparseHeaders.get(5)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(5)).getNumbytes());
            Assert.assertEquals((long)51200L, (long)((TarArchiveStructSparse)sparseHeaders.get(6)).getOffset());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(6)).getNumbytes());
        }
    }

    @Test
    public void testTarFileExtractExtendedOldGNU() throws IOException, InterruptedException {
        Assume.assumeFalse((String)"Don't run test on Windows", (boolean)this.isOnWindows);
        File file = SparseFilesTest.getFile("oldgnu_extended_sparse.tar");
        try (InputStream sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparse6");
             TarFile tarFile = new TarFile(file);){
            TarArchiveEntry ae = (TarArchiveEntry)tarFile.getEntries().get(0);
            try (InputStream tarInput = tarFile.getInputStream(ae);){
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tarInput), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            }
            List sparseHeaders = ae.getOrderedSparseHeaders();
            Assert.assertEquals((long)7L, (long)sparseHeaders.size());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getNumbytes());
            Assert.assertEquals((long)10240L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getNumbytes());
            Assert.assertEquals((long)16384L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getNumbytes());
            Assert.assertEquals((long)24576L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(3)).getNumbytes());
            Assert.assertEquals((long)29696L, (long)((TarArchiveStructSparse)sparseHeaders.get(4)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(4)).getNumbytes());
            Assert.assertEquals((long)36864L, (long)((TarArchiveStructSparse)sparseHeaders.get(5)).getOffset());
            Assert.assertEquals((long)1024L, (long)((TarArchiveStructSparse)sparseHeaders.get(5)).getNumbytes());
            Assert.assertEquals((long)51200L, (long)((TarArchiveStructSparse)sparseHeaders.get(6)).getOffset());
            Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(6)).getNumbytes());
        }
    }

    @Test
    public void testExtractPaxGNU() throws IOException, InterruptedException {
        Assume.assumeFalse((String)"This test should be ignored on Windows", (boolean)this.isOnWindows);
        Assume.assumeFalse((String)"This test should be ignored if GNU tar is version 1.28", (boolean)this.getTarBinaryHelp().startsWith("tar (GNU tar) 1.28"));
        File file = SparseFilesTest.getFile("pax_gnu_sparse.tar");
        try (TarArchiveInputStream tin = new TarArchiveInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            TarArchiveEntry paxGNUEntry = tin.getNextTarEntry();
            Assert.assertTrue((boolean)tin.canReadEntryData((ArchiveEntry)paxGNUEntry));
            try (InputStream sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile-0.0");){
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tin), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            }
            paxGNUEntry = tin.getNextTarEntry();
            Assert.assertTrue((boolean)tin.canReadEntryData((ArchiveEntry)paxGNUEntry));
            sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile-0.1");
            var6_8 = null;
            try {
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tin), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (sparseFileInputStream != null) {
                    if (var6_8 != null) {
                        try {
                            sparseFileInputStream.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        sparseFileInputStream.close();
                    }
                }
            }
            paxGNUEntry = tin.getNextTarEntry();
            Assert.assertTrue((boolean)tin.canReadEntryData((ArchiveEntry)paxGNUEntry));
            sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile-1.0");
            var6_8 = null;
            try {
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tin), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (sparseFileInputStream != null) {
                    if (var6_8 != null) {
                        try {
                            sparseFileInputStream.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        sparseFileInputStream.close();
                    }
                }
            }
        }
    }

    @Test
    public void testTarFileExtractPaxGNU() throws IOException, InterruptedException {
        Assume.assumeFalse((String)"Don't run test on Windows", (boolean)this.isOnWindows);
        Assume.assumeFalse((String)"This test should be ignored if GNU tar is version 1.28", (boolean)this.getTarBinaryHelp().startsWith("tar (GNU tar) 1.28"));
        File file = SparseFilesTest.getFile("pax_gnu_sparse.tar");
        try (TarFile paxGnu = new TarFile(file);){
            Throwable throwable;
            InputStream paxInput;
            List entries = paxGnu.getEntries();
            TarArchiveEntry entry = (TarArchiveEntry)entries.get(0);
            try (InputStream sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile-0.0");){
                paxInput = paxGnu.getInputStream(entry);
                throwable = null;
                try {
                    Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)paxInput), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (paxInput != null) {
                        if (throwable != null) {
                            try {
                                paxInput.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            paxInput.close();
                        }
                    }
                }
            }
            entry = (TarArchiveEntry)entries.get(1);
            sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile-0.1");
            var7_9 = null;
            try {
                paxInput = paxGnu.getInputStream(entry);
                throwable = null;
                try {
                    Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)paxInput), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (paxInput != null) {
                        if (throwable != null) {
                            try {
                                paxInput.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            paxInput.close();
                        }
                    }
                }
            }
            catch (Throwable paxInput2) {
                var7_9 = paxInput2;
                throw paxInput2;
            }
            finally {
                if (sparseFileInputStream != null) {
                    if (var7_9 != null) {
                        try {
                            sparseFileInputStream.close();
                        }
                        catch (Throwable paxInput2) {
                            var7_9.addSuppressed(paxInput2);
                        }
                    } else {
                        sparseFileInputStream.close();
                    }
                }
            }
            entry = (TarArchiveEntry)entries.get(2);
            sparseFileInputStream = this.extractTarAndGetInputStream(file, "sparsefile-1.0");
            var7_9 = null;
            try {
                paxInput = paxGnu.getInputStream(entry);
                throwable = null;
                try {
                    Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)paxInput), (byte[])IOUtils.toByteArray((InputStream)sparseFileInputStream));
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (paxInput != null) {
                        if (throwable != null) {
                            try {
                                paxInput.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            paxInput.close();
                        }
                    }
                }
            }
            catch (Throwable throwable8) {
                var7_9 = throwable8;
                throw throwable8;
            }
            finally {
                if (sparseFileInputStream != null) {
                    if (var7_9 != null) {
                        try {
                            sparseFileInputStream.close();
                        }
                        catch (Throwable throwable9) {
                            var7_9.addSuppressed(throwable9);
                        }
                    } else {
                        sparseFileInputStream.close();
                    }
                }
            }
        }
    }

    @Test
    public void compareTarArchiveInputStreamWithTarFile() throws IOException {
        Path file = SparseFilesTest.getPath("oldgnu_sparse.tar");
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(file, new OpenOption[0])));
             TarFile tarFile = new TarFile(file);){
            TarArchiveEntry tarInEntry = tarIn.getNextTarEntry();
            Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)tarIn), (byte[])IOUtils.toByteArray((InputStream)tarFile.getInputStream((TarArchiveEntry)tarFile.getEntries().get(0))));
        }
    }

    private void assertPaxGNUEntry(TarArchiveInputStream tin, String suffix) throws Throwable {
        TarArchiveEntry ae = tin.getNextTarEntry();
        Assert.assertEquals((Object)("sparsefile-" + suffix), (Object)ae.getName());
        Assert.assertTrue((boolean)ae.isGNUSparse());
        Assert.assertTrue((boolean)ae.isPaxGNUSparse());
        Assert.assertFalse((boolean)ae.isOldGNUSparse());
        Assert.assertTrue((boolean)tin.canReadEntryData((ArchiveEntry)ae));
        List sparseHeaders = ae.getSparseHeaders();
        Assert.assertEquals((long)3L, (long)sparseHeaders.size());
        Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getOffset());
        Assert.assertEquals((long)2048L, (long)((TarArchiveStructSparse)sparseHeaders.get(0)).getNumbytes());
        Assert.assertEquals((long)0x100800L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getOffset());
        Assert.assertEquals((long)2560L, (long)((TarArchiveStructSparse)sparseHeaders.get(1)).getNumbytes());
        Assert.assertEquals((long)3101184L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getOffset());
        Assert.assertEquals((long)0L, (long)((TarArchiveStructSparse)sparseHeaders.get(2)).getNumbytes());
    }

    private InputStream extractTarAndGetInputStream(File tarFile, String sparseFileName) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder("tar", "-xf", tarFile.getPath(), "-C", this.resultDir.getPath());
        pb.redirectErrorStream(true);
        Process process = pb.start();
        Assert.assertEquals((String)new String(IOUtils.toByteArray((InputStream)process.getInputStream())), (long)0L, (long)process.waitFor());
        for (File file : this.resultDir.listFiles()) {
            if (!file.getName().equals(sparseFileName)) continue;
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        Assert.fail((String)("didn't find " + sparseFileName + " after extracting " + tarFile));
        return null;
    }

    private String getTarBinaryHelp() throws IOException {
        ProcessBuilder pb = new ProcessBuilder("tar", "--version");
        pb.redirectErrorStream(true);
        Process process = pb.start();
        return new String(IOUtils.toByteArray((InputStream)process.getInputStream()));
    }
}

