/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class SevenZTestCase
extends AbstractTestCase {
    private File output;
    private final File file1 = SevenZTestCase.getFile("test1.xml");
    private final File file2 = SevenZTestCase.getFile("test2.xml");

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.output = new File(this.dir, "bla.7z");
    }

    @Test
    public void testSevenZArchiveCreationUsingCopy() throws Exception {
        this.testSevenZArchiveCreation(SevenZMethod.COPY);
    }

    @Test
    public void testSevenZArchiveCreationUsingLZMA() throws Exception {
        this.testSevenZArchiveCreation(SevenZMethod.LZMA);
    }

    @Test
    public void testSevenZArchiveCreationUsingLZMA2() throws Exception {
        this.testSevenZArchiveCreation(SevenZMethod.LZMA2);
    }

    @Test
    public void testSevenZArchiveCreationUsingBZIP2() throws Exception {
        this.testSevenZArchiveCreation(SevenZMethod.BZIP2);
    }

    @Test
    public void testSevenZArchiveCreationUsingDeflate() throws Exception {
        this.testSevenZArchiveCreation(SevenZMethod.DEFLATE);
    }

    private void testSevenZArchiveCreation(SevenZMethod method) throws Exception {
        this.createArchive(method);
        try (SevenZFile archive = new SevenZFile(this.output);){
            SevenZArchiveEntry entry = archive.getNextEntry();
            assert (entry != null);
            Assert.assertEquals((Object)entry.getName(), (Object)this.file1.getName());
            entry = archive.getNextEntry();
            assert (entry != null);
            Assert.assertEquals((Object)entry.getName(), (Object)this.file2.getName());
            assert (archive.getNextEntry() == null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createArchive(SevenZMethod method) throws Exception {
        outArchive.setContentCompression(method);
        try (SevenZOutputFile outArchive = new SevenZOutputFile(this.output);){
            SevenZArchiveEntry entry = outArchive.createArchiveEntry(this.file1, this.file1.getName());
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            this.copy(this.file1, outArchive);
            outArchive.closeArchiveEntry();
            entry = outArchive.createArchiveEntry(this.file2, this.file2.getName());
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            this.copy(this.file2, outArchive);
            outArchive.closeArchiveEntry();
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingCopy() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(SevenZMethod.COPY);
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingLZMA() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(SevenZMethod.LZMA);
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingLZMA2() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(SevenZMethod.LZMA2);
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingBZIP2() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(SevenZMethod.BZIP2);
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingDeflate() throws Exception {
        this.singleByteReadConsistentlyReturnsMinusOneAtEof(SevenZMethod.DEFLATE);
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEofUsingAES() throws Exception {
        SevenZTestCase.assumeStrongCryptoIsAvailable();
        try (SevenZFile archive = new SevenZFile(SevenZTestCase.getFile("bla.encrypted.7z"), "foo".toCharArray());){
            this.singleByteReadConsistentlyReturnsMinusOneAtEof(archive);
        }
    }

    private void singleByteReadConsistentlyReturnsMinusOneAtEof(SevenZMethod method) throws Exception {
        this.createArchive(method);
        try (SevenZFile archive = new SevenZFile(this.output);){
            this.singleByteReadConsistentlyReturnsMinusOneAtEof(archive);
        }
    }

    private void singleByteReadConsistentlyReturnsMinusOneAtEof(SevenZFile archive) throws Exception {
        SevenZArchiveEntry entry = archive.getNextEntry();
        entry = archive.getNextEntry();
        this.readFully(archive);
        Assert.assertEquals((long)-1L, (long)archive.read());
        Assert.assertEquals((long)-1L, (long)archive.read());
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingLZMA() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(SevenZMethod.LZMA);
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingLZMA2() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(SevenZMethod.LZMA2);
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingBZIP2() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(SevenZMethod.BZIP2);
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingDeflate() throws Exception {
        this.multiByteReadConsistentlyReturnsMinusOneAtEof(SevenZMethod.DEFLATE);
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEofUsingAES() throws Exception {
        SevenZTestCase.assumeStrongCryptoIsAvailable();
        try (SevenZFile archive = new SevenZFile(SevenZTestCase.getFile("bla.encrypted.7z"), "foo".toCharArray());){
            this.multiByteReadConsistentlyReturnsMinusOneAtEof(archive);
        }
    }

    private void multiByteReadConsistentlyReturnsMinusOneAtEof(SevenZMethod method) throws Exception {
        this.createArchive(method);
        try (SevenZFile archive = new SevenZFile(this.output);){
            this.multiByteReadConsistentlyReturnsMinusOneAtEof(archive);
        }
    }

    private void multiByteReadConsistentlyReturnsMinusOneAtEof(SevenZFile archive) throws Exception {
        byte[] buf = new byte[2];
        SevenZArchiveEntry entry = archive.getNextEntry();
        entry = archive.getNextEntry();
        this.readFully(archive);
        Assert.assertEquals((long)-1L, (long)archive.read(buf));
        Assert.assertEquals((long)-1L, (long)archive.read(buf));
    }

    private void copy(File src, SevenZOutputFile dst) throws IOException {
        try (InputStream fis = Files.newInputStream(src.toPath(), new OpenOption[0]);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = fis.read(buffer)) >= 0) {
                dst.write(buffer, 0, bytesRead);
            }
        }
    }

    private void readFully(SevenZFile archive) throws IOException {
        byte[] buf = new byte[1024];
        int x = 0;
        while (0 <= (x = archive.read(buf))) {
        }
    }

    private static void assumeStrongCryptoIsAvailable() throws NoSuchAlgorithmException {
        Assume.assumeTrue((String)"test requires strong crypto", (Cipher.getMaxAllowedKeyLength("AES/ECB/PKCS5Padding") >= 256 ? 1 : 0) != 0);
    }
}

