/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LongSymLinkTest
extends AbstractTestCase {
    private static final ClassLoader CLASSLOADER = LongSymLinkTest.class.getClassLoader();
    private static final File ARCDIR;
    private static final ArrayList<String> FILELIST;
    private final File file;

    public LongSymLinkTest(String file) {
        this.file = new File(ARCDIR, file);
    }

    @BeforeClass
    public static void setUpFileList() throws Exception {
        String line;
        Assert.assertTrue((boolean)ARCDIR.exists());
        File listing = new File(ARCDIR, "files.txt");
        Assert.assertTrue((String)"files.txt is readable", (boolean)listing.canRead());
        BufferedReader br = new BufferedReader(Files.newBufferedReader(listing.toPath()));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            FILELIST.add(line);
        }
        br.close();
    }

    @Parameterized.Parameters(name="file={0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String f : ARCDIR.list((dir, name) -> !name.endsWith(".txt"))) {
            params.add(new Object[]{f});
        }
        return params;
    }

    @Override
    protected String getExpectedString(ArchiveEntry entry) {
        TarArchiveEntry tarEntry;
        if (entry instanceof TarArchiveEntry && (tarEntry = (TarArchiveEntry)entry).isSymbolicLink()) {
            return tarEntry.getName() + " -> " + tarEntry.getLinkName();
        }
        return entry.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArchive() throws Exception {
        ArrayList expected = (ArrayList)FILELIST.clone();
        String name = this.file.getName();
        if ("minotaur.jar".equals(name) || "minotaur-0.jar".equals(name)) {
            expected.add("META-INF/");
            expected.add("META-INF/MANIFEST.MF");
        }
        ArchiveInputStream ais = this.factory.createArchiveInputStream((InputStream)new BufferedInputStream(Files.newInputStream(this.file.toPath(), new OpenOption[0])));
        if (name.endsWith(".tar")) {
            Assert.assertTrue((boolean)(ais instanceof TarArchiveInputStream));
        } else if (name.endsWith(".jar") || name.endsWith(".zip")) {
            Assert.assertTrue((boolean)(ais instanceof ZipArchiveInputStream));
        } else if (name.endsWith(".cpio")) {
            Assert.assertTrue((boolean)(ais instanceof CpioArchiveInputStream));
            for (int i = 0; i < expected.size(); ++i) {
                String ent = (String)expected.get(i);
                if (!ent.endsWith("/")) continue;
                expected.set(i, ent.substring(0, ent.length() - 1));
            }
        } else if (name.endsWith(".ar")) {
            Assert.assertTrue((boolean)(ais instanceof ArArchiveInputStream));
            expected.clear();
            for (String ent : FILELIST) {
                if (ent.endsWith("/")) continue;
                int lastSlash = ent.lastIndexOf(47);
                if (lastSlash >= 0) {
                    expected.add(ent.substring(lastSlash + 1));
                    continue;
                }
                expected.add(ent);
            }
        } else {
            Assert.fail((String)("Unexpected file type: " + name));
        }
        try {
            this.checkArchiveContent(ais, (List<String>)expected);
        }
        catch (AssertionFailedError e) {
            Assert.fail((String)("Error processing " + this.file.getName() + " " + (Object)((Object)e)));
        }
        finally {
            ais.close();
        }
    }

    static {
        FILELIST = new ArrayList();
        try {
            ARCDIR = new File(CLASSLOADER.getResource("longsymlink").toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

