/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.druid.QTestDruidSerDe;
import org.apache.hadoop.hive.druid.serde.DruidGroupByQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidSelectQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidSerDe;
import org.apache.hadoop.hive.druid.serde.DruidTimeseriesQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidTopNQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParseException;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.select.SelectQuery;
import org.apache.hive.druid.io.druid.query.select.SelectResultValue;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNResultValue;
import org.junit.Assert;
import org.junit.Test;

public class TestDruidSerDe {
    private static final String TIMESERIES_QUERY = "{  \"queryType\": \"timeseries\",  \"dataSource\": \"sample_datasource\",  \"granularity\": \"day\",  \"descending\": \"true\",  \"filter\": {    \"type\": \"and\",    \"fields\": [      { \"type\": \"selector\", \"dimension\": \"sample_dimension1\", \"value\": \"sample_value1\" },      { \"type\": \"or\",        \"fields\": [          { \"type\": \"selector\", \"dimension\": \"sample_dimension2\", \"value\": \"sample_value2\" },          { \"type\": \"selector\", \"dimension\": \"sample_dimension3\", \"value\": \"sample_value3\" }        ]      }    ]  },  \"aggregations\": [    { \"type\": \"longSum\", \"name\": \"sample_name1\", \"fieldName\": \"sample_fieldName1\" },    { \"type\": \"doubleSum\", \"name\": \"sample_name2\", \"fieldName\": \"sample_fieldName2\" }  ],  \"postAggregations\": [    { \"type\": \"arithmetic\",      \"name\": \"sample_divide\",      \"fn\": \"/\",      \"fields\": [        { \"type\": \"fieldAccess\", \"name\": \"postAgg__sample_name1\", \"fieldName\": \"sample_name1\" },        { \"type\": \"fieldAccess\", \"name\": \"postAgg__sample_name2\", \"fieldName\": \"sample_name2\" }      ]    }  ],  \"intervals\": [ \"2012-01-01T00:00:00.000/2012-01-03T00:00:00.000\" ]}";
    private static final String TIMESERIES_QUERY_RESULTS = "[  {    \"timestamp\": \"2012-01-01T00:00:00.000Z\",    \"result\": { \"sample_name1\": 0, \"sample_name2\": 1.0, \"sample_divide\": 2.2222 }   },  {    \"timestamp\": \"2012-01-02T00:00:00.000Z\",    \"result\": { \"sample_name1\": 2, \"sample_name2\": 3.32, \"sample_divide\": 4 }  }]";
    private static final Object[][] TIMESERIES_QUERY_RESULTS_RECORDS = new Object[][]{{new TimestampWritable(new Timestamp(1325376000000L)), new LongWritable(0L), new FloatWritable(1.0f), new FloatWritable(2.2222f)}, {new TimestampWritable(new Timestamp(1325462400000L)), new LongWritable(2L), new FloatWritable(3.32f), new FloatWritable(4.0f)}};
    private static final String TOPN_QUERY = "{  \"queryType\": \"topN\",  \"dataSource\": \"sample_data\",  \"dimension\": \"sample_dim\",  \"threshold\": 5,  \"metric\": \"count\",  \"granularity\": \"all\",  \"filter\": {    \"type\": \"and\",    \"fields\": [      {        \"type\": \"selector\",        \"dimension\": \"dim1\",        \"value\": \"some_value\"      },      {        \"type\": \"selector\",        \"dimension\": \"dim2\",        \"value\": \"some_other_val\"      }    ]  },  \"aggregations\": [    {      \"type\": \"longSum\",      \"name\": \"count\",      \"fieldName\": \"count\"    },    {      \"type\": \"doubleSum\",      \"name\": \"some_metric\",      \"fieldName\": \"some_metric\"    }  ],  \"postAggregations\": [    {      \"type\": \"arithmetic\",      \"name\": \"sample_divide\",      \"fn\": \"/\",      \"fields\": [        {          \"type\": \"fieldAccess\",          \"name\": \"some_metric\",          \"fieldName\": \"some_metric\"        },        {          \"type\": \"fieldAccess\",          \"name\": \"count\",          \"fieldName\": \"count\"        }      ]    }  ],  \"intervals\": [    \"2013-08-31T00:00:00.000/2013-09-03T00:00:00.000\"  ]}";
    private static final String TOPN_QUERY_RESULTS = "[  {    \"timestamp\": \"2013-08-31T00:00:00.000Z\",    \"result\": [      {        \"sample_dim\": \"dim1_val\",        \"count\": 111,        \"some_metric\": 10669,        \"sample_divide\": 96.11711711711712      },      {        \"sample_dim\": \"another_dim1_val\",        \"count\": 88,        \"some_metric\": 28344,        \"sample_divide\": 322.09090909090907      },      {        \"sample_dim\": \"dim1_val3\",        \"count\": 70,        \"some_metric\": 871,        \"sample_divide\": 12.442857142857143      },      {        \"sample_dim\": \"dim1_val4\",        \"count\": 62,        \"some_metric\": 815,        \"sample_divide\": 13.14516129032258      },      {        \"sample_dim\": \"dim1_val5\",        \"count\": 60,        \"some_metric\": 2787,        \"sample_divide\": 46.45      }    ]  }]";
    private static final Object[][] TOPN_QUERY_RESULTS_RECORDS = new Object[][]{{new TimestampWritable(new Timestamp(1377907200000L)), new Text("dim1_val"), new LongWritable(111L), new FloatWritable(10669.0f), new FloatWritable(96.11712f)}, {new TimestampWritable(new Timestamp(1377907200000L)), new Text("another_dim1_val"), new LongWritable(88L), new FloatWritable(28344.0f), new FloatWritable(322.0909f)}, {new TimestampWritable(new Timestamp(1377907200000L)), new Text("dim1_val3"), new LongWritable(70L), new FloatWritable(871.0f), new FloatWritable(12.442857f)}, {new TimestampWritable(new Timestamp(1377907200000L)), new Text("dim1_val4"), new LongWritable(62L), new FloatWritable(815.0f), new FloatWritable(13.145162f)}, {new TimestampWritable(new Timestamp(1377907200000L)), new Text("dim1_val5"), new LongWritable(60L), new FloatWritable(2787.0f), new FloatWritable(46.45f)}};
    private static final String GROUP_BY_QUERY = "{  \"queryType\": \"groupBy\",  \"dataSource\": \"sample_datasource\",  \"granularity\": \"day\",  \"dimensions\": [\"country\", \"device\"],  \"limitSpec\": { \"type\": \"default\", \"limit\": 5000, \"columns\": [\"country\", \"data_transfer\"] },  \"filter\": {    \"type\": \"and\",    \"fields\": [      { \"type\": \"selector\", \"dimension\": \"carrier\", \"value\": \"AT&T\" },      { \"type\": \"or\",         \"fields\": [          { \"type\": \"selector\", \"dimension\": \"make\", \"value\": \"Apple\" },          { \"type\": \"selector\", \"dimension\": \"make\", \"value\": \"Samsung\" }        ]      }    ]  },  \"aggregations\": [    { \"type\": \"longSum\", \"name\": \"total_usage\", \"fieldName\": \"user_count\" },    { \"type\": \"doubleSum\", \"name\": \"data_transfer\", \"fieldName\": \"data_transfer\" }  ],  \"postAggregations\": [    { \"type\": \"arithmetic\",      \"name\": \"avg_usage\",      \"fn\": \"/\",      \"fields\": [        { \"type\": \"fieldAccess\", \"fieldName\": \"data_transfer\" },        { \"type\": \"fieldAccess\", \"fieldName\": \"total_usage\" }      ]    }  ],  \"intervals\": [ \"2012-01-01T00:00:00.000/2012-01-03T00:00:00.000\" ],  \"having\": {    \"type\": \"greaterThan\",    \"aggregation\": \"total_usage\",    \"value\": 100  }}";
    private static final String GROUP_BY_QUERY_RESULTS = "[   {    \"version\" : \"v1\",    \"timestamp\" : \"2012-01-01T00:00:00.000Z\",    \"event\" : {      \"country\" : \"India\",      \"device\" : \"phone\",      \"total_usage\" : 88,      \"data_transfer\" : 29.91233453,      \"avg_usage\" : 60.32    }  },   {    \"version\" : \"v1\",    \"timestamp\" : \"2012-01-01T00:00:12.000Z\",    \"event\" : {      \"country\" : \"Spain\",      \"device\" : \"pc\",      \"total_usage\" : 16,      \"data_transfer\" : 172.93494959,      \"avg_usage\" : 6.333333    }  }]";
    private static final Object[][] GROUP_BY_QUERY_RESULTS_RECORDS = new Object[][]{{new TimestampWritable(new Timestamp(1325376000000L)), new Text("India"), new Text("phone"), new LongWritable(88L), new FloatWritable(29.912334f), new FloatWritable(60.32f)}, {new TimestampWritable(new Timestamp(1325376012000L)), new Text("Spain"), new Text("pc"), new LongWritable(16L), new FloatWritable(172.93495f), new FloatWritable(6.333333f)}};
    private static final String SELECT_QUERY = "{   \"queryType\": \"select\",   \"dataSource\": \"wikipedia\",   \"descending\": \"false\",   \"dimensions\":[\"robot\",\"namespace\",\"anonymous\",\"unpatrolled\",\"page\",\"language\",\"newpage\",\"user\"],   \"metrics\":[\"count\",\"added\",\"delta\",\"variation\",\"deleted\"],   \"granularity\": \"all\",   \"intervals\": [     \"2013-01-01/2013-01-02\"   ],   \"pagingSpec\":{\"pagingIdentifiers\": {}, \"threshold\":5} }";
    private static final String SELECT_QUERY_RESULTS = "[{  \"timestamp\" : \"2013-01-01T00:00:00.000Z\",  \"result\" : {    \"pagingIdentifiers\" : {      \"wikipedia_2012-12-29T00:00:00.000Z_2013-01-10T08:00:00.000Z_2013-01-10T08:13:47.830Z_v9\" : 4    },    \"events\" : [ {      \"segmentId\" : \"wikipedia_editstream_2012-12-29T00:00:00.000Z_2013-01-10T08:00:00.000Z_2013-01-10T08:13:47.830Z_v9\",      \"offset\" : 0,      \"event\" : {        \"timestamp\" : \"2013-01-01T00:00:00.000Z\",        \"robot\" : \"1\",        \"namespace\" : \"article\",        \"anonymous\" : \"0\",        \"unpatrolled\" : \"0\",        \"page\" : \"11._korpus_(NOVJ)\",        \"language\" : \"sl\",        \"newpage\" : \"0\",        \"user\" : \"EmausBot\",        \"count\" : 1.0,        \"added\" : 39.0,        \"delta\" : 39.0,        \"variation\" : 39.0,        \"deleted\" : 0.0      }    }, {      \"segmentId\" : \"wikipedia_2012-12-29T00:00:00.000Z_2013-01-10T08:00:00.000Z_2013-01-10T08:13:47.830Z_v9\",      \"offset\" : 1,      \"event\" : {        \"timestamp\" : \"2013-01-01T00:00:00.000Z\",        \"robot\" : \"0\",        \"namespace\" : \"article\",        \"anonymous\" : \"0\",        \"unpatrolled\" : \"0\",        \"page\" : \"112_U.S._580\",        \"language\" : \"en\",        \"newpage\" : \"1\",        \"user\" : \"MZMcBride\",        \"count\" : 1.0,        \"added\" : 70.0,        \"delta\" : 70.0,        \"variation\" : 70.0,        \"deleted\" : 0.0      }    }, {      \"segmentId\" : \"wikipedia_2012-12-29T00:00:00.000Z_2013-01-10T08:00:00.000Z_2013-01-10T08:13:47.830Z_v9\",      \"offset\" : 2,      \"event\" : {        \"timestamp\" : \"2013-01-01T00:00:12.000Z\",        \"robot\" : \"0\",        \"namespace\" : \"article\",        \"anonymous\" : \"0\",        \"unpatrolled\" : \"0\",        \"page\" : \"113_U.S._243\",        \"language\" : \"en\",        \"newpage\" : \"1\",        \"user\" : \"MZMcBride\",        \"count\" : 1.0,        \"added\" : 77.0,        \"delta\" : 77.0,        \"variation\" : 77.0,        \"deleted\" : 0.0      }    }, {      \"segmentId\" : \"wikipedia_2012-12-29T00:00:00.000Z_2013-01-10T08:00:00.000Z_2013-01-10T08:13:47.830Z_v9\",      \"offset\" : 3,      \"event\" : {        \"timestamp\" : \"2013-01-01T00:00:12.000Z\",        \"robot\" : \"0\",        \"namespace\" : \"article\",        \"anonymous\" : \"0\",        \"unpatrolled\" : \"0\",        \"page\" : \"113_U.S._73\",        \"language\" : \"en\",        \"newpage\" : \"1\",        \"user\" : \"MZMcBride\",        \"count\" : 1.0,        \"added\" : 70.0,        \"delta\" : 70.0,        \"variation\" : 70.0,        \"deleted\" : 0.0      }    }, {      \"segmentId\" : \"wikipedia_2012-12-29T00:00:00.000Z_2013-01-10T08:00:00.000Z_2013-01-10T08:13:47.830Z_v9\",      \"offset\" : 4,      \"event\" : {        \"timestamp\" : \"2013-01-01T00:00:12.000Z\",        \"robot\" : \"0\",        \"namespace\" : \"article\",        \"anonymous\" : \"0\",        \"unpatrolled\" : \"0\",        \"page\" : \"113_U.S._756\",        \"language\" : \"en\",        \"newpage\" : \"1\",        \"user\" : \"MZMcBride\",        \"count\" : 1.0,        \"added\" : 68.0,        \"delta\" : 68.0,        \"variation\" : 68.0,        \"deleted\" : 0.0      }    } ]  }} ]";
    private static final Object[][] SELECT_QUERY_RESULTS_RECORDS = new Object[][]{{new TimestampWritable(new Timestamp(1356998400000L)), new Text("1"), new Text("article"), new Text("0"), new Text("0"), new Text("11._korpus_(NOVJ)"), new Text("sl"), new Text("0"), new Text("EmausBot"), new FloatWritable(1.0f), new FloatWritable(39.0f), new FloatWritable(39.0f), new FloatWritable(39.0f), new FloatWritable(0.0f)}, {new TimestampWritable(new Timestamp(1356998400000L)), new Text("0"), new Text("article"), new Text("0"), new Text("0"), new Text("112_U.S._580"), new Text("en"), new Text("1"), new Text("MZMcBride"), new FloatWritable(1.0f), new FloatWritable(70.0f), new FloatWritable(70.0f), new FloatWritable(70.0f), new FloatWritable(0.0f)}, {new TimestampWritable(new Timestamp(1356998412000L)), new Text("0"), new Text("article"), new Text("0"), new Text("0"), new Text("113_U.S._243"), new Text("en"), new Text("1"), new Text("MZMcBride"), new FloatWritable(1.0f), new FloatWritable(77.0f), new FloatWritable(77.0f), new FloatWritable(77.0f), new FloatWritable(0.0f)}, {new TimestampWritable(new Timestamp(1356998412000L)), new Text("0"), new Text("article"), new Text("0"), new Text("0"), new Text("113_U.S._73"), new Text("en"), new Text("1"), new Text("MZMcBride"), new FloatWritable(1.0f), new FloatWritable(70.0f), new FloatWritable(70.0f), new FloatWritable(70.0f), new FloatWritable(0.0f)}, {new TimestampWritable(new Timestamp(1356998412000L)), new Text("0"), new Text("article"), new Text("0"), new Text("0"), new Text("113_U.S._756"), new Text("en"), new Text("1"), new Text("MZMcBride"), new FloatWritable(1.0f), new FloatWritable(68.0f), new FloatWritable(68.0f), new FloatWritable(68.0f), new FloatWritable(0.0f)}};
    private static final String COLUMN_NAMES = "__time,c0,c1,c2,c3,c4,c5,c6,c7";
    private static final String COLUMN_TYPES = "timestamp,string,double,float,decimal(38,18),bigint,int,smallint,tinyint";
    private static final Object[] ROW_OBJECT = new Object[]{new TimestampWritable(new Timestamp(1377907200000L)), new Text("dim1_val"), new DoubleWritable(10669.3), new FloatWritable(10669.45f), new HiveDecimalWritable(HiveDecimal.create((double)1064.34)), new LongWritable(1113939L), new IntWritable(1112123), new ShortWritable(12), new ByteWritable(0), new TimestampWritable(new Timestamp(1377907200000L))};
    private static final DruidWritable DRUID_WRITABLE = new DruidWritable((Map)ImmutableMap.builder().put((Object)"__time", (Object)1377907200000L).put((Object)"c0", (Object)"dim1_val").put((Object)"c1", (Object)10669.3).put((Object)"c2", (Object)Float.valueOf(10669.45f)).put((Object)"c3", (Object)1064.34).put((Object)"c4", (Object)1113939L).put((Object)"c5", (Object)1112123).put((Object)"c6", (Object)12).put((Object)"c7", (Object)0).put((Object)"__time_granularity", (Object)1377907200000L).build());

    @Test
    public void testDruidDeserializer() throws SerDeException, JsonParseException, JsonMappingException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, IOException, InterruptedException, NoSuchMethodException, InvocationTargetException {
        QTestDruidSerDe serDe = new QTestDruidSerDe();
        Configuration conf = new Configuration();
        Properties tbl = TestDruidSerDe.createPropertiesQuery("sample_datasource", "timeseries", TIMESERIES_QUERY);
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        TestDruidSerDe.deserializeQueryResults(serDe, "timeseries", TIMESERIES_QUERY, TIMESERIES_QUERY_RESULTS, TIMESERIES_QUERY_RESULTS_RECORDS);
        tbl = TestDruidSerDe.createPropertiesQuery("sample_data", "topN", TOPN_QUERY);
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        TestDruidSerDe.deserializeQueryResults(serDe, "topN", TOPN_QUERY, TOPN_QUERY_RESULTS, TOPN_QUERY_RESULTS_RECORDS);
        tbl = TestDruidSerDe.createPropertiesQuery("sample_datasource", "groupBy", GROUP_BY_QUERY);
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        TestDruidSerDe.deserializeQueryResults(serDe, "groupBy", GROUP_BY_QUERY, GROUP_BY_QUERY_RESULTS, GROUP_BY_QUERY_RESULTS_RECORDS);
        tbl = TestDruidSerDe.createPropertiesQuery("wikipedia", "select", SELECT_QUERY);
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        TestDruidSerDe.deserializeQueryResults(serDe, "select", SELECT_QUERY, SELECT_QUERY_RESULTS, SELECT_QUERY_RESULTS_RECORDS);
    }

    private static Properties createPropertiesQuery(String dataSource, String queryType, String jsonQuery) {
        Properties tbl = new Properties();
        tbl.setProperty("druid.datasource", dataSource);
        tbl.setProperty("druid.query.json", jsonQuery);
        tbl.setProperty("druid.query.type", queryType);
        return tbl;
    }

    private static void deserializeQueryResults(DruidSerDe serDe, String queryType, String jsonQuery, String resultString, Object[][] records) throws SerDeException, JsonParseException, JsonMappingException, IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, InterruptedException, NoSuchMethodException, InvocationTargetException {
        Object fieldData;
        int i;
        Object[] expectedFieldsData;
        Object row;
        Query query = null;
        DruidTimeseriesQueryRecordReader reader = null;
        List resultsList = null;
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        switch (queryType) {
            case "timeseries": {
                query = (Query)mapper.readValue(jsonQuery, TimeseriesQuery.class);
                reader = new DruidTimeseriesQueryRecordReader();
                resultsList = (List)mapper.readValue(resultString, (TypeReference)new TypeReference<List<Result<TimeseriesResultValue>>>(){});
                break;
            }
            case "topN": {
                query = (Query)mapper.readValue(jsonQuery, TopNQuery.class);
                reader = new DruidTopNQueryRecordReader();
                resultsList = (List)mapper.readValue(resultString, (TypeReference)new TypeReference<List<Result<TopNResultValue>>>(){});
                break;
            }
            case "groupBy": {
                query = (Query)mapper.readValue(jsonQuery, GroupByQuery.class);
                reader = new DruidGroupByQueryRecordReader();
                resultsList = (List)mapper.readValue(resultString, (TypeReference)new TypeReference<List<Row>>(){});
                break;
            }
            case "select": {
                query = (Query)mapper.readValue(jsonQuery, SelectQuery.class);
                reader = new DruidSelectQueryRecordReader();
                resultsList = (List)mapper.readValue(resultString, (TypeReference)new TypeReference<List<Result<SelectResultValue>>>(){});
            }
        }
        Field field1 = DruidQueryRecordReader.class.getDeclaredField("query");
        field1.setAccessible(true);
        field1.set(reader, query);
        if (reader instanceof DruidGroupByQueryRecordReader) {
            Method method1 = DruidGroupByQueryRecordReader.class.getDeclaredMethod("initExtractors", new Class[0]);
            method1.setAccessible(true);
            method1.invoke((Object)reader, new Object[0]);
        }
        Field field2 = DruidQueryRecordReader.class.getDeclaredField("results");
        field2.setAccessible(true);
        StructObjectInspector oi = (StructObjectInspector)serDe.getObjectInspector();
        List fieldRefs = oi.getAllStructFieldRefs();
        Iterator results = resultsList.iterator();
        field2.set(reader, results);
        DruidWritable writable = new DruidWritable();
        int pos = 0;
        while (reader.next(NullWritable.get(), writable)) {
            row = serDe.deserialize((Writable)writable);
            expectedFieldsData = records[pos];
            Assert.assertEquals((long)expectedFieldsData.length, (long)fieldRefs.size());
            for (i = 0; i < fieldRefs.size(); ++i) {
                fieldData = oi.getStructFieldData(row, (StructField)fieldRefs.get(i));
                Assert.assertEquals((String)("Field " + i), (Object)expectedFieldsData[i], (Object)fieldData);
            }
            ++pos;
        }
        Assert.assertEquals((long)pos, (long)records.length);
        results = resultsList.iterator();
        field2.set(reader, results);
        pos = 0;
        while (reader.nextKeyValue()) {
            row = serDe.deserialize((Writable)reader.getCurrentValue());
            expectedFieldsData = records[pos];
            Assert.assertEquals((long)expectedFieldsData.length, (long)fieldRefs.size());
            for (i = 0; i < fieldRefs.size(); ++i) {
                fieldData = oi.getStructFieldData(row, (StructField)fieldRefs.get(i));
                Assert.assertEquals((String)("Field " + i), (Object)expectedFieldsData[i], (Object)fieldData);
            }
            ++pos;
        }
        Assert.assertEquals((long)pos, (long)records.length);
    }

    @Test
    public void testDruidSerializer() throws SerDeException, JsonParseException, JsonMappingException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, IOException, InterruptedException, NoSuchMethodException, InvocationTargetException {
        DruidSerDe serDe = new DruidSerDe();
        Configuration conf = new Configuration();
        Properties tbl = TestDruidSerDe.createPropertiesSource(COLUMN_NAMES, COLUMN_TYPES);
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        TestDruidSerDe.serializeObject(tbl, serDe, ROW_OBJECT, DRUID_WRITABLE);
    }

    private static Properties createPropertiesSource(String columnNames, String columnTypes) {
        Properties tbl = new Properties();
        tbl.setProperty("columns", columnNames);
        tbl.setProperty("columns.types", columnTypes);
        return tbl;
    }

    private static void serializeObject(Properties properties, DruidSerDe serDe, Object[] rowObject, DruidWritable druidWritable) throws SerDeException {
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<PrimitiveTypeInfo> columnTypes = new ArrayList<PrimitiveTypeInfo>();
        ArrayList inspectors = new ArrayList();
        columnNames.addAll(Utilities.getColumnNames((Properties)properties));
        columnNames.add("__time_granularity");
        columnTypes.addAll(Lists.transform((List)Utilities.getColumnTypes((Properties)properties), (Function)new Function<String, PrimitiveTypeInfo>(){

            public PrimitiveTypeInfo apply(String type) {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)type);
            }
        }));
        columnTypes.add(TypeInfoFactory.getPrimitiveTypeInfo((String)"timestamp"));
        inspectors.addAll(Lists.transform(columnTypes, (Function)new Function<PrimitiveTypeInfo, ObjectInspector>(){

            public ObjectInspector apply(PrimitiveTypeInfo type) {
                return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)type);
            }
        }));
        StandardStructObjectInspector inspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, inspectors);
        DruidWritable writable = (DruidWritable)serDe.serialize((Object)rowObject, (ObjectInspector)inspector);
        Assert.assertEquals((long)DRUID_WRITABLE.getValue().size(), (long)writable.getValue().size());
        for (Map.Entry e : DRUID_WRITABLE.getValue().entrySet()) {
            Assert.assertEquals(e.getValue(), writable.getValue().get(e.getKey()));
        }
    }
}

