/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.druid.DerbyConnectorTestUtility;
import org.apache.hadoop.hive.druid.DruidStorageHandler;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.indexer.JobHelper;
import org.apache.hive.druid.io.druid.indexer.SQLMetadataStorageUpdaterJobHandler;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.skife.jdbi.v2.Handle;

public class TestDruidStorageHandler {
    @Rule
    public final DerbyConnectorTestUtility.DerbyConnectorRule derbyConnectorRule = new DerbyConnectorTestUtility.DerbyConnectorRule();
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final String DATA_SOURCE_NAME = "testName";
    private String segmentsTable;
    private String tableWorkingPath;
    private DataSegment dataSegment = DataSegment.builder().dataSource("testName").version("v1").interval(new Interval(100L, 170L)).shardSpec((ShardSpec)NoneShardSpec.instance()).build();
    Table tableMock = (Table)Mockito.mock(Table.class);

    @Before
    public void before() throws Throwable {
        this.tableWorkingPath = this.temporaryFolder.newFolder().getAbsolutePath();
        this.segmentsTable = ((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable();
        ImmutableMap mockMap = ImmutableMap.of((Object)"druid.datasource", (Object)DATA_SOURCE_NAME);
        Mockito.when((Object)this.tableMock.getParameters()).thenReturn((Object)mockMap);
        Mockito.when((Object)this.tableMock.getPartitionKeysSize()).thenReturn((Object)0);
        StorageDescriptor storageDes = (StorageDescriptor)Mockito.mock(StorageDescriptor.class);
        Mockito.when((Object)storageDes.getBucketColsSize()).thenReturn((Object)0);
        Mockito.when((Object)this.tableMock.getSd()).thenReturn((Object)storageDes);
        Mockito.when((Object)this.tableMock.getDbName()).thenReturn((Object)DATA_SOURCE_NAME);
    }

    @Test
    public void testPreCreateTableWillCreateSegmentsTable() throws MetaException {
        DruidStorageHandler druidStorageHandler = new DruidStorageHandler((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), new SQLMetadataStorageUpdaterJobHandler((SQLMetadataConnector)this.derbyConnectorRule.getConnector()), (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), null);
        try (Handle handle = this.derbyConnectorRule.getConnector().getDBI().open();){
            Assert.assertFalse((boolean)this.derbyConnectorRule.getConnector().tableExists(handle, this.segmentsTable));
            druidStorageHandler.preCreateTable(this.tableMock);
            Assert.assertTrue((boolean)this.derbyConnectorRule.getConnector().tableExists(handle, this.segmentsTable));
        }
    }

    @Test(expected=MetaException.class)
    public void testPreCreateTableWhenDataSourceExists() throws MetaException {
        this.derbyConnectorRule.getConnector().createSegmentTable();
        SQLMetadataStorageUpdaterJobHandler sqlMetadataStorageUpdaterJobHandler = new SQLMetadataStorageUpdaterJobHandler((SQLMetadataConnector)this.derbyConnectorRule.getConnector());
        sqlMetadataStorageUpdaterJobHandler.publishSegments(this.segmentsTable, Arrays.asList(this.dataSegment), DruidStorageHandlerUtils.JSON_MAPPER);
        DruidStorageHandler druidStorageHandler = new DruidStorageHandler((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), new SQLMetadataStorageUpdaterJobHandler((SQLMetadataConnector)this.derbyConnectorRule.getConnector()), (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), null);
        druidStorageHandler.preCreateTable(this.tableMock);
    }

    @Test
    public void testCommitCreateTablePlusCommitDropTableWithoutPurge() throws MetaException, IOException {
        DruidStorageHandler druidStorageHandler = new DruidStorageHandler((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), new SQLMetadataStorageUpdaterJobHandler((SQLMetadataConnector)this.derbyConnectorRule.getConnector()), (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), null);
        druidStorageHandler.preCreateTable(this.tableMock);
        Configuration config = new Configuration();
        config.set("fs.default.name", "file:///");
        config.set(String.valueOf(HiveConf.ConfVars.HIVEQUERYID), UUID.randomUUID().toString());
        config.set(String.valueOf(HiveConf.ConfVars.DRUID_WORKING_DIR), this.tableWorkingPath);
        druidStorageHandler.setConf(config);
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)config);
        Path taskDirPath = new Path(this.tableWorkingPath, druidStorageHandler.makeStagingName());
        Path descriptorPath = DruidStorageHandlerUtils.makeSegmentDescriptorOutputPath((DataSegment)this.dataSegment, (Path)new Path(taskDirPath, "segmentsDescriptorDir"));
        DruidStorageHandlerUtils.writeSegmentDescriptor((FileSystem)localFileSystem, (DataSegment)this.dataSegment, (Path)descriptorPath);
        druidStorageHandler.commitCreateTable(this.tableMock);
        Assert.assertArrayEquals((Object[])Lists.newArrayList((Object[])new String[]{DATA_SOURCE_NAME}).toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), (MetadataStorageTablesConfig)((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()))).toArray());
        druidStorageHandler.commitDropTable(this.tableMock, false);
        Assert.assertArrayEquals((Object[])Lists.newArrayList().toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), (MetadataStorageTablesConfig)((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()))).toArray());
    }

    @Test
    public void testCommitInsertTable() throws MetaException, IOException {
        DruidStorageHandler druidStorageHandler = new DruidStorageHandler((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), new SQLMetadataStorageUpdaterJobHandler((SQLMetadataConnector)this.derbyConnectorRule.getConnector()), (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), null);
        druidStorageHandler.preCreateTable(this.tableMock);
        Configuration config = new Configuration();
        config.set("fs.default.name", "file:///");
        config.set(String.valueOf(HiveConf.ConfVars.HIVEQUERYID), UUID.randomUUID().toString());
        config.set(String.valueOf(HiveConf.ConfVars.DRUID_WORKING_DIR), this.tableWorkingPath);
        druidStorageHandler.setConf(config);
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)config);
        Path taskDirPath = new Path(this.tableWorkingPath, druidStorageHandler.makeStagingName());
        Path descriptorPath = DruidStorageHandlerUtils.makeSegmentDescriptorOutputPath((DataSegment)this.dataSegment, (Path)new Path(taskDirPath, "segmentsDescriptorDir"));
        DruidStorageHandlerUtils.writeSegmentDescriptor((FileSystem)localFileSystem, (DataSegment)this.dataSegment, (Path)descriptorPath);
        druidStorageHandler.commitCreateTable(this.tableMock);
        Assert.assertArrayEquals((Object[])Lists.newArrayList((Object[])new String[]{DATA_SOURCE_NAME}).toArray(), (Object[])Lists.newArrayList((Iterable)DruidStorageHandlerUtils.getAllDataSourceNames((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), (MetadataStorageTablesConfig)((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()))).toArray());
    }

    @Test
    public void testDeleteSegment() throws IOException, SegmentLoadingException {
        DruidStorageHandler druidStorageHandler = new DruidStorageHandler((SQLMetadataConnector)this.derbyConnectorRule.getConnector(), new SQLMetadataStorageUpdaterJobHandler((SQLMetadataConnector)this.derbyConnectorRule.getConnector()), (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), null);
        String segmentRootPath = this.temporaryFolder.newFolder().getAbsolutePath();
        Configuration config = new Configuration();
        config.set("fs.default.name", "file:///");
        druidStorageHandler.setConf(config);
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)config);
        Path segmentOutputPath = JobHelper.makeSegmentOutputPath((Path)new Path(segmentRootPath), (FileSystem)localFileSystem, (DataSegment)this.dataSegment);
        Path indexPath = new Path(segmentOutputPath, "index.zip");
        DataSegment dataSegmentWithLoadspect = DataSegment.builder((DataSegment)this.dataSegment).loadSpec((Map)ImmutableMap.of((Object)"path", (Object)indexPath)).build();
        FSDataOutputStream outputStream = localFileSystem.create(indexPath, true);
        outputStream.close();
        Assert.assertTrue((String)"index file is not created ??", (boolean)localFileSystem.exists(indexPath));
        Assert.assertTrue((boolean)localFileSystem.exists(segmentOutputPath));
        druidStorageHandler.deleteSegment(dataSegmentWithLoadspect);
        Assert.assertFalse((String)"Index file still there ??", (boolean)localFileSystem.exists(indexPath));
        Assert.assertFalse((String)"PartitionNum directory still there ??", (boolean)localFileSystem.exists(segmentOutputPath));
        Assert.assertFalse((String)"Version directory still there ??", (boolean)localFileSystem.exists(segmentOutputPath.getParent()));
        Assert.assertFalse((String)"Interval directory still there ??", (boolean)localFileSystem.exists(segmentOutputPath.getParent().getParent()));
        Assert.assertFalse((String)"Data source directory still there ??", (boolean)localFileSystem.exists(segmentOutputPath.getParent().getParent().getParent()));
    }
}

