/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIdentifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSyntax;

public class ListSqlOperatorTable
implements SqlOperatorTable {
    private final List<SqlOperator> operatorList;

    public ListSqlOperatorTable() {
        this(new ArrayList<SqlOperator>());
    }

    public ListSqlOperatorTable(List<SqlOperator> operatorList) {
        this.operatorList = operatorList;
    }

    public void add(SqlOperator op) {
        this.operatorList.add(op);
    }

    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList) {
        for (SqlOperator operator : this.operatorList) {
            if (operator.getSyntax() != syntax || !opName.isSimple() || !operator.isName(opName.getSimple()) || category != null && category != ListSqlOperatorTable.category(operator) && !category.isUserDefinedNotSpecificFunction()) continue;
            operatorList.add(operator);
        }
    }

    protected static SqlFunctionCategory category(SqlOperator operator) {
        if (operator instanceof SqlFunction) {
            return ((SqlFunction)operator).getFunctionType();
        }
        return SqlFunctionCategory.SYSTEM;
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        return this.operatorList;
    }
}

