/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.Aggregate;
import org.apache.hive.druid.org.apache.calcite.rel.core.Join;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinInfo;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rel.core.SemiJoin;
import org.apache.hive.druid.org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableIntList;

public class SemiJoinRule
extends RelOptRule {
    public static final SemiJoinRule INSTANCE = new SemiJoinRule();

    private SemiJoinRule() {
        super(SemiJoinRule.operand(Project.class, SemiJoinRule.some(SemiJoinRule.operand(Join.class, SemiJoinRule.some(SemiJoinRule.operand(RelNode.class, SemiJoinRule.any()), SemiJoinRule.operand(Aggregate.class, SemiJoinRule.any()))), new RelOptRuleOperand[0])));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        ImmutableBitSet rightBits;
        Project project = (Project)call.rel(0);
        Join join = (Join)call.rel(1);
        Object left = call.rel(2);
        Aggregate aggregate = (Aggregate)call.rel(3);
        RelOptCluster cluster = join.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        ImmutableBitSet bits = RelOptUtil.InputFinder.bits(project.getProjects(), null);
        if (bits.intersects(rightBits = ImmutableBitSet.range(left.getRowType().getFieldCount(), join.getRowType().getFieldCount()))) {
            return;
        }
        JoinInfo joinInfo = join.analyzeCondition();
        if (!joinInfo.rightSet().equals(ImmutableBitSet.range(aggregate.getGroupCount()))) {
            return;
        }
        if (!joinInfo.isEqui()) {
            return;
        }
        ArrayList<Integer> newRightKeyBuilder = Lists.newArrayList();
        List<Integer> aggregateKeys = aggregate.getGroupSet().asList();
        for (int key : joinInfo.rightKeys) {
            newRightKeyBuilder.add(aggregateKeys.get(key));
        }
        ImmutableIntList newRightKeys = ImmutableIntList.copyOf(newRightKeyBuilder);
        RelNode newRight = aggregate.getInput();
        RexNode newCondition = RelOptUtil.createEquiJoinCondition(left, joinInfo.leftKeys, newRight, newRightKeys, rexBuilder);
        SemiJoin semiJoin = SemiJoin.create(left, newRight, newCondition, joinInfo.leftKeys, newRightKeys);
        Project newProject = project.copy(project.getTraitSet(), semiJoin, project.getProjects(), project.getRowType());
        call.transformTo(ProjectRemoveRule.strip(newProject));
    }
}

