/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.JoinRelType;
import org.apache.hive.druid.org.apache.calcite.rel.core.SemiJoin;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelColumnOrigin;
import org.apache.hive.druid.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hive.druid.org.apache.calcite.rel.rules.LoptJoinTree;
import org.apache.hive.druid.org.apache.calcite.rel.rules.MultiJoin;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.util.BitSets;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableBitSet;
import org.apache.hive.druid.org.apache.calcite.util.ImmutableIntList;

public class LoptMultiJoin {
    MultiJoin multiJoin;
    private List<RexNode> joinFilters;
    private List<RexNode> allJoinFilters;
    private final int nJoinFactors;
    private int nTotalFields;
    private final ImmutableList<RelNode> joinFactors;
    private final ImmutableList<JoinRelType> joinTypes;
    private final ImmutableBitSet[] outerJoinFactors;
    private List<ImmutableBitSet> projFields;
    private Map<Integer, int[]> joinFieldRefCountsMap;
    private Map<RexNode, ImmutableBitSet> factorsRefByJoinFilter;
    private Map<RexNode, ImmutableBitSet> fieldsRefByJoinFilter;
    int[] joinStart;
    int[] nFieldsInJoinFactor;
    ImmutableBitSet[] factorsRefByFactor;
    int[][] factorWeights;
    final RelDataTypeFactory factory;
    Integer[] joinRemovalFactors;
    SemiJoin[] joinRemovalSemiJoins;
    Set<Integer> removableOuterJoinFactors;
    Map<Integer, RemovableSelfJoin> removableSelfJoinPairs;

    public LoptMultiJoin(MultiJoin multiJoin) {
        this.multiJoin = multiJoin;
        this.joinFactors = ImmutableList.copyOf(multiJoin.getInputs());
        this.nJoinFactors = this.joinFactors.size();
        this.projFields = multiJoin.getProjFields();
        this.joinFieldRefCountsMap = multiJoin.getCopyJoinFieldRefCountsMap();
        this.joinFilters = Lists.newArrayList(RelOptUtil.conjunctions(multiJoin.getJoinFilter()));
        this.allJoinFilters = new ArrayList<RexNode>(this.joinFilters);
        List<RexNode> outerJoinFilters = multiJoin.getOuterJoinConditions();
        for (int i = 0; i < this.nJoinFactors; ++i) {
            this.allJoinFilters.addAll(RelOptUtil.conjunctions(outerJoinFilters.get(i)));
        }
        int start = 0;
        this.nTotalFields = multiJoin.getRowType().getFieldCount();
        this.joinStart = new int[this.nJoinFactors];
        this.nFieldsInJoinFactor = new int[this.nJoinFactors];
        for (int i = 0; i < this.nJoinFactors; ++i) {
            this.joinStart[i] = start;
            this.nFieldsInJoinFactor[i] = ((RelNode)this.joinFactors.get(i)).getRowType().getFieldCount();
            start += this.nFieldsInJoinFactor[i];
        }
        this.joinTypes = ImmutableList.copyOf(multiJoin.getJoinTypes());
        List<RexNode> outerJoinConds = this.multiJoin.getOuterJoinConditions();
        this.outerJoinFactors = new ImmutableBitSet[this.nJoinFactors];
        for (int i = 0; i < this.nJoinFactors; ++i) {
            if (outerJoinConds.get(i) == null) continue;
            ImmutableBitSet dependentFactors = this.getJoinFilterFactorBitmap(outerJoinConds.get(i), false);
            this.outerJoinFactors[i] = dependentFactors = dependentFactors.clear(i);
        }
        this.setJoinFilterRefs();
        this.factory = multiJoin.getCluster().getTypeFactory();
        this.joinRemovalFactors = new Integer[this.nJoinFactors];
        this.joinRemovalSemiJoins = new SemiJoin[this.nJoinFactors];
        this.removableOuterJoinFactors = new HashSet<Integer>();
        this.removableSelfJoinPairs = new HashMap<Integer, RemovableSelfJoin>();
    }

    public MultiJoin getMultiJoinRel() {
        return this.multiJoin;
    }

    public int getNumJoinFactors() {
        return this.nJoinFactors;
    }

    public RelNode getJoinFactor(int factIdx) {
        return (RelNode)this.joinFactors.get(factIdx);
    }

    public int getNumTotalFields() {
        return this.nTotalFields;
    }

    public int getNumFieldsInJoinFactor(int factIdx) {
        return this.nFieldsInJoinFactor[factIdx];
    }

    public List<RexNode> getJoinFilters() {
        return this.joinFilters;
    }

    public ImmutableBitSet getFactorsRefByJoinFilter(RexNode joinFilter) {
        return this.factorsRefByJoinFilter.get(joinFilter);
    }

    public List<RelDataTypeField> getMultiJoinFields() {
        return this.multiJoin.getRowType().getFieldList();
    }

    public ImmutableBitSet getFieldsRefByJoinFilter(RexNode joinFilter) {
        return this.fieldsRefByJoinFilter.get(joinFilter);
    }

    public int[][] getFactorWeights() {
        return this.factorWeights;
    }

    public ImmutableBitSet getFactorsRefByFactor(int factIdx) {
        return this.factorsRefByFactor[factIdx];
    }

    public int getJoinStart(int factIdx) {
        return this.joinStart[factIdx];
    }

    public boolean isNullGenerating(int factIdx) {
        return this.joinTypes.get(factIdx) != JoinRelType.INNER;
    }

    public ImmutableBitSet getOuterJoinFactors(int factIdx) {
        return this.outerJoinFactors[factIdx];
    }

    public RexNode getOuterJoinCond(int factIdx) {
        return this.multiJoin.getOuterJoinConditions().get(factIdx);
    }

    public ImmutableBitSet getProjFields(int factIdx) {
        return this.projFields.get(factIdx);
    }

    public int[] getJoinFieldRefCounts(int factIdx) {
        return this.joinFieldRefCountsMap.get(factIdx);
    }

    public Integer getJoinRemovalFactor(int dimIdx) {
        return this.joinRemovalFactors[dimIdx];
    }

    public SemiJoin getJoinRemovalSemiJoin(int dimIdx) {
        return this.joinRemovalSemiJoins[dimIdx];
    }

    public void setJoinRemovalFactor(int dimIdx, int factIdx) {
        this.joinRemovalFactors[dimIdx] = factIdx;
    }

    public void setJoinRemovalSemiJoin(int dimIdx, SemiJoin semiJoin) {
        this.joinRemovalSemiJoins[dimIdx] = semiJoin;
    }

    ImmutableBitSet getJoinFilterFactorBitmap(RexNode joinFilter, boolean setFields) {
        ImmutableBitSet fieldRefBitmap = this.fieldBitmap(joinFilter);
        if (setFields) {
            this.fieldsRefByJoinFilter.put(joinFilter, fieldRefBitmap);
        }
        return this.factorBitmap(fieldRefBitmap);
    }

    private ImmutableBitSet fieldBitmap(RexNode joinFilter) {
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder();
        joinFilter.accept(inputFinder);
        return inputFinder.inputBitSet.build();
    }

    private void setJoinFilterRefs() {
        this.fieldsRefByJoinFilter = Maps.newHashMap();
        this.factorsRefByJoinFilter = Maps.newHashMap();
        ListIterator<RexNode> filterIter = this.allJoinFilters.listIterator();
        while (filterIter.hasNext()) {
            RexNode joinFilter = filterIter.next();
            if (joinFilter.isAlwaysTrue()) {
                filterIter.remove();
            }
            ImmutableBitSet factorRefBitmap = this.getJoinFilterFactorBitmap(joinFilter, true);
            this.factorsRefByJoinFilter.put(joinFilter, factorRefBitmap);
        }
    }

    private ImmutableBitSet factorBitmap(ImmutableBitSet fieldRefBitmap) {
        ImmutableBitSet.Builder factorRefBitmap = ImmutableBitSet.builder();
        for (int field : fieldRefBitmap) {
            int factor = this.findRef(field);
            factorRefBitmap.set(factor);
        }
        return factorRefBitmap.build();
    }

    public int findRef(int rexInputRef) {
        for (int i = 0; i < this.nJoinFactors; ++i) {
            if (rexInputRef < this.joinStart[i] || rexInputRef >= this.joinStart[i] + this.nFieldsInJoinFactor[i]) continue;
            return i;
        }
        throw new AssertionError();
    }

    public void setFactorWeights() {
        this.factorWeights = new int[this.nJoinFactors][this.nJoinFactors];
        this.factorsRefByFactor = new ImmutableBitSet[this.nJoinFactors];
        for (int i = 0; i < this.nJoinFactors; ++i) {
            this.factorsRefByFactor[i] = ImmutableBitSet.of();
        }
        for (RexNode joinFilter : this.allJoinFilters) {
            ImmutableBitSet factorRefs = this.factorsRefByJoinFilter.get(joinFilter);
            if (!(joinFilter instanceof RexCall) || !joinFilter.isA(SqlKind.COMPARISON)) continue;
            for (int factor : factorRefs) {
                this.factorsRefByFactor[factor] = this.factorsRefByFactor[factor].rebuild().addAll(factorRefs).clear(factor).build();
            }
            if (factorRefs.cardinality() == 2) {
                int weight;
                int leftFactor = factorRefs.nextSetBit(0);
                int rightFactor = factorRefs.nextSetBit(leftFactor + 1);
                RexCall call = (RexCall)joinFilter;
                ImmutableBitSet leftFields = this.fieldBitmap(call.getOperands().get(0));
                ImmutableBitSet leftBitmap = this.factorBitmap(leftFields);
                if (leftBitmap.cardinality() == 1) {
                    switch (joinFilter.getKind()) {
                        case EQUALS: {
                            weight = 3;
                            break;
                        }
                        default: {
                            weight = 2;
                            break;
                        }
                    }
                } else {
                    weight = 1;
                }
                this.setFactorWeight(weight, leftFactor, rightFactor);
                continue;
            }
            ImmutableIntList list = ImmutableIntList.copyOf(factorRefs);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int outer = (Integer)iterator.next();
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    int inner = (Integer)iterator2.next();
                    if (outer == inner) continue;
                    this.setFactorWeight(1, outer, inner);
                }
            }
        }
    }

    private void setFactorWeight(int weight, int leftFactor, int rightFactor) {
        if (this.factorWeights[leftFactor][rightFactor] < weight) {
            this.factorWeights[leftFactor][rightFactor] = weight;
            this.factorWeights[rightFactor][leftFactor] = weight;
        }
    }

    public boolean hasAllFactors(LoptJoinTree joinTree, BitSet factorsNeeded) {
        return BitSets.contains(BitSets.of(joinTree.getTreeOrder()), factorsNeeded);
    }

    @Deprecated
    public void getChildFactors(LoptJoinTree joinTree, ImmutableBitSet.Builder childFactors) {
        for (int child : joinTree.getTreeOrder()) {
            childFactors.set(child);
        }
    }

    public List<RelDataTypeField> getJoinFields(LoptJoinTree left, LoptJoinTree right) {
        RelDataType rowType = this.factory.createJoinType(left.getJoinTree().getRowType(), right.getJoinTree().getRowType());
        return rowType.getFieldList();
    }

    public void addRemovableOuterJoinFactor(int factIdx) {
        this.removableOuterJoinFactors.add(factIdx);
    }

    public boolean isRemovableOuterJoinFactor(int factIdx) {
        return this.removableOuterJoinFactors.contains(factIdx);
    }

    public void addRemovableSelfJoinPair(int factor1, int factor2) {
        int rightFactor;
        int leftFactor;
        if (this.getNumFieldsInJoinFactor(factor1) > this.getNumFieldsInJoinFactor(factor2)) {
            leftFactor = factor1;
            rightFactor = factor2;
        } else {
            leftFactor = factor2;
            rightFactor = factor1;
        }
        HashMap<Integer, Integer> columnMapping = new HashMap<Integer, Integer>();
        RelNode left = this.getJoinFactor(leftFactor);
        RelMetadataQuery mq = RelMetadataQuery.instance();
        HashMap<Integer, Integer> leftFactorColMapping = new HashMap<Integer, Integer>();
        for (int i = 0; i < left.getRowType().getFieldCount(); ++i) {
            RelColumnOrigin colOrigin = mq.getColumnOrigin(left, i);
            if (colOrigin == null) continue;
            leftFactorColMapping.put(colOrigin.getOriginColumnOrdinal(), i);
        }
        RelNode right = this.getJoinFactor(rightFactor);
        for (int i = 0; i < right.getRowType().getFieldCount(); ++i) {
            Integer leftOffset;
            RelColumnOrigin colOrigin = mq.getColumnOrigin(right, i);
            if (colOrigin == null || (leftOffset = (Integer)leftFactorColMapping.get(colOrigin.getOriginColumnOrdinal())) == null) continue;
            columnMapping.put(i, leftOffset);
        }
        RemovableSelfJoin selfJoin = new RemovableSelfJoin(leftFactor, rightFactor, columnMapping);
        this.removableSelfJoinPairs.put(leftFactor, selfJoin);
        this.removableSelfJoinPairs.put(rightFactor, selfJoin);
    }

    public Integer getOtherSelfJoinFactor(int factIdx) {
        RemovableSelfJoin selfJoin = this.removableSelfJoinPairs.get(factIdx);
        if (selfJoin == null) {
            return null;
        }
        if (selfJoin.getRightFactor() == factIdx) {
            return selfJoin.getLeftFactor();
        }
        return selfJoin.getRightFactor();
    }

    public boolean isLeftFactorInRemovableSelfJoin(int factIdx) {
        RemovableSelfJoin selfJoin = this.removableSelfJoinPairs.get(factIdx);
        if (selfJoin == null) {
            return false;
        }
        return selfJoin.getLeftFactor() == factIdx;
    }

    public boolean isRightFactorInRemovableSelfJoin(int factIdx) {
        RemovableSelfJoin selfJoin = this.removableSelfJoinPairs.get(factIdx);
        if (selfJoin == null) {
            return false;
        }
        return selfJoin.getRightFactor() == factIdx;
    }

    public Integer getRightColumnMapping(int rightFactor, int rightOffset) {
        RemovableSelfJoin selfJoin = this.removableSelfJoinPairs.get(rightFactor);
        assert (selfJoin.getRightFactor() == rightFactor);
        return selfJoin.getColumnMapping().get(rightOffset);
    }

    public Edge createEdge(RexNode condition) {
        ImmutableBitSet fieldRefBitmap = this.fieldBitmap(condition);
        ImmutableBitSet factorRefBitmap = this.factorBitmap(fieldRefBitmap);
        return new Edge(condition, factorRefBitmap, fieldRefBitmap);
    }

    private class RemovableSelfJoin {
        private int leftFactor;
        private int rightFactor;
        private Map<Integer, Integer> columnMapping;

        RemovableSelfJoin(int leftFactor, int rightFactor, Map<Integer, Integer> columnMapping) {
            this.leftFactor = leftFactor;
            this.rightFactor = rightFactor;
            this.columnMapping = columnMapping;
        }

        public int getLeftFactor() {
            return this.leftFactor;
        }

        public int getRightFactor() {
            return this.rightFactor;
        }

        public Map<Integer, Integer> getColumnMapping() {
            return this.columnMapping;
        }
    }

    static class Edge {
        final ImmutableBitSet factors;
        final ImmutableBitSet columns;
        final RexNode condition;

        Edge(RexNode condition, ImmutableBitSet factors, ImmutableBitSet columns) {
            this.condition = condition;
            this.factors = factors;
            this.columns = columns;
        }

        public String toString() {
            return "Edge(condition: " + this.condition + ", factors: " + this.factors + ", columns: " + this.columns + ")";
        }
    }
}

