/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.config;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.hive.druid.org.apache.calcite.avatica.ConnectionConfigImpl;
import org.apache.hive.druid.org.apache.calcite.avatica.util.Casing;
import org.apache.hive.druid.org.apache.calcite.avatica.util.Quoting;
import org.apache.hive.druid.org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.hive.druid.org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.hive.druid.org.apache.calcite.config.Lex;
import org.apache.hive.druid.org.apache.calcite.config.NullCollation;
import org.apache.hive.druid.org.apache.calcite.model.JsonSchema;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.fun.OracleSqlOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlConformance;

public class CalciteConnectionConfigImpl
extends ConnectionConfigImpl
implements CalciteConnectionConfig {
    public CalciteConnectionConfigImpl(Properties properties) {
        super(properties);
    }

    public CalciteConnectionConfigImpl set(CalciteConnectionProperty property, String value) {
        Properties properties1 = new Properties(this.properties);
        properties1.setProperty(property.camelName(), value);
        return new CalciteConnectionConfigImpl(properties1);
    }

    @Override
    public boolean autoTemp() {
        return CalciteConnectionProperty.AUTO_TEMP.wrap(this.properties).getBoolean();
    }

    @Override
    public boolean materializationsEnabled() {
        return CalciteConnectionProperty.MATERIALIZATIONS_ENABLED.wrap(this.properties).getBoolean();
    }

    @Override
    public boolean createMaterializations() {
        return CalciteConnectionProperty.CREATE_MATERIALIZATIONS.wrap(this.properties).getBoolean();
    }

    @Override
    public NullCollation defaultNullCollation() {
        return (NullCollation)CalciteConnectionProperty.DEFAULT_NULL_COLLATION.wrap(this.properties).getEnum(NullCollation.class, (Enum)NullCollation.HIGH);
    }

    @Override
    public <T> T fun(Class<T> operatorTableClass, T defaultOperatorTable) {
        String fun = CalciteConnectionProperty.FUN.wrap(this.properties).getString();
        if (fun == null || fun.equals("") || fun.equals("standard")) {
            return defaultOperatorTable;
        }
        ArrayList<SqlOperatorTable> tables = new ArrayList<SqlOperatorTable>();
        for (String s : fun.split(",")) {
            tables.add(CalciteConnectionConfigImpl.operatorTable(s));
        }
        return operatorTableClass.cast(ChainedSqlOperatorTable.of(tables.toArray(new SqlOperatorTable[tables.size()])));
    }

    private static SqlOperatorTable operatorTable(String s) {
        switch (s) {
            case "standard": {
                return SqlStdOperatorTable.instance();
            }
            case "oracle": {
                return ChainedSqlOperatorTable.of(OracleSqlOperatorTable.instance(), SqlStdOperatorTable.instance());
            }
        }
        throw new IllegalArgumentException("Unknown operator table: " + s);
    }

    @Override
    public String model() {
        return CalciteConnectionProperty.MODEL.wrap(this.properties).getString();
    }

    @Override
    public Lex lex() {
        return (Lex)CalciteConnectionProperty.LEX.wrap(this.properties).getEnum(Lex.class);
    }

    @Override
    public Quoting quoting() {
        return (Quoting)CalciteConnectionProperty.QUOTING.wrap(this.properties).getEnum(Quoting.class, (Enum)this.lex().quoting);
    }

    @Override
    public Casing unquotedCasing() {
        return (Casing)CalciteConnectionProperty.UNQUOTED_CASING.wrap(this.properties).getEnum(Casing.class, (Enum)this.lex().unquotedCasing);
    }

    @Override
    public Casing quotedCasing() {
        return (Casing)CalciteConnectionProperty.QUOTED_CASING.wrap(this.properties).getEnum(Casing.class, (Enum)this.lex().quotedCasing);
    }

    @Override
    public boolean caseSensitive() {
        return CalciteConnectionProperty.CASE_SENSITIVE.wrap(this.properties).getBoolean(this.lex().caseSensitive);
    }

    @Override
    public <T> T schemaFactory(Class<T> schemaFactoryClass, T defaultSchemaFactory) {
        return (T)CalciteConnectionProperty.SCHEMA_FACTORY.wrap(this.properties).getPlugin(schemaFactoryClass, defaultSchemaFactory);
    }

    @Override
    public JsonSchema.Type schemaType() {
        JsonSchema.Type type = (JsonSchema.Type)CalciteConnectionProperty.SCHEMA_TYPE.wrap(this.properties).getEnum(JsonSchema.Type.class);
        return type == null || type == JsonSchema.Type.NONE ? null : type;
    }

    @Override
    public boolean spark() {
        return CalciteConnectionProperty.SPARK.wrap(this.properties).getBoolean();
    }

    @Override
    public boolean forceDecorrelate() {
        return CalciteConnectionProperty.FORCE_DECORRELATE.wrap(this.properties).getBoolean();
    }

    @Override
    public <T> T typeSystem(Class<T> typeSystemClass, T defaultTypeSystem) {
        return (T)CalciteConnectionProperty.TYPE_SYSTEM.wrap(this.properties).getPlugin(typeSystemClass, defaultTypeSystem);
    }

    @Override
    public SqlConformance conformance() {
        return (SqlConformance)CalciteConnectionProperty.CONFORMANCE.wrap(this.properties).getEnum(SqlConformance.class);
    }
}

