/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.router;

import javax.script.Compilable;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.io.druid.js.JavaScriptConfig;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.server.router.TieredBrokerConfig;
import org.apache.hive.druid.io.druid.server.router.TieredBrokerSelectorStrategy;

public class JavaScriptTieredBrokerSelectorStrategy
implements TieredBrokerSelectorStrategy {
    private final SelectorFunction fnSelector;
    private final String function;

    @JsonCreator
    public JavaScriptTieredBrokerSelectorStrategy(@JsonProperty(value="function") String fn, @JacksonInject JavaScriptConfig config) {
        Preconditions.checkNotNull(fn, "function must not be null");
        if (config.isDisabled()) {
            throw new ISE("JavaScript is disabled", new Object[0]);
        }
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
        try {
            ((Compilable)((Object)engine)).compile("var apply = " + fn).eval();
        }
        catch (ScriptException e) {
            Throwables.propagate(e);
        }
        this.function = fn;
        this.fnSelector = ((Invocable)((Object)engine)).getInterface(SelectorFunction.class);
    }

    @Override
    public Optional<String> getBrokerServiceName(TieredBrokerConfig config, Query query) {
        return Optional.fromNullable(this.fnSelector.apply(config, query));
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptTieredBrokerSelectorStrategy that = (JavaScriptTieredBrokerSelectorStrategy)o;
        return this.function.equals(that.function);
    }

    public int hashCode() {
        return this.function.hashCode();
    }

    public String toString() {
        return "JavascriptTieredBrokerSelectorStrategy{function='" + this.function + '\'' + '}';
    }

    public static interface SelectorFunction {
        public String apply(TieredBrokerConfig var1, Query var2);
    }
}

