/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator.helper;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.client.indexing.IndexingServiceClient;
import org.apache.hive.druid.io.druid.common.utils.JodaUtils;
import org.apache.hive.druid.io.druid.metadata.MetadataSegmentManager;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.joda.time.Interval;

public class DruidCoordinatorSegmentKiller
implements DruidCoordinatorHelper {
    private static final Logger log = new Logger(DruidCoordinatorSegmentKiller.class);
    private final long period;
    private final long retainDuration;
    private final int maxSegmentsToKill;
    private long lastKillTime = 0L;
    private final MetadataSegmentManager segmentManager;
    private final IndexingServiceClient indexingServiceClient;

    @Inject
    public DruidCoordinatorSegmentKiller(MetadataSegmentManager segmentManager, IndexingServiceClient indexingServiceClient, DruidCoordinatorConfig config) {
        this.period = config.getCoordinatorKillPeriod().getMillis();
        Preconditions.checkArgument(this.period > config.getCoordinatorIndexingPeriod().getMillis(), "coordinator kill period must be greater than druid.coordinator.period.indexingPeriod");
        this.retainDuration = config.getCoordinatorKillDurationToRetain().getMillis();
        Preconditions.checkArgument(this.retainDuration >= 0L, "coordinator kill retainDuration must be >= 0");
        this.maxSegmentsToKill = config.getCoordinatorKillMaxSegments();
        Preconditions.checkArgument(this.maxSegmentsToKill > 0, "coordinator kill maxSegments must be > 0");
        log.info("Kill Task scheduling enabled with period [%s], retainDuration [%s], maxSegmentsToKill [%s]", this.period, this.retainDuration, this.maxSegmentsToKill);
        this.segmentManager = segmentManager;
        this.indexingServiceClient = indexingServiceClient;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        boolean killAllDataSources = params.getCoordinatorDynamicConfig().isKillAllDataSources();
        Collection<String> whitelist = params.getCoordinatorDynamicConfig().getKillDataSourceWhitelist();
        if (killAllDataSources && whitelist != null && !whitelist.isEmpty()) {
            log.error("killAllDataSources can't be true when killDataSourceWhitelist is non-empty, No kill tasks are scheduled.", new Object[0]);
            return params;
        }
        if (killAllDataSources) {
            whitelist = this.segmentManager.getAllDatasourceNames();
        }
        if (whitelist != null && whitelist.size() > 0 && this.lastKillTime + this.period < System.currentTimeMillis()) {
            this.lastKillTime = System.currentTimeMillis();
            for (String dataSource : whitelist) {
                Interval intervalToKill = this.findIntervalForKillTask(dataSource, this.maxSegmentsToKill);
                if (intervalToKill == null) continue;
                try {
                    this.indexingServiceClient.killSegments(dataSource, intervalToKill);
                }
                catch (Exception ex) {
                    log.error(ex, "Failed to submit kill task for dataSource [%s]", dataSource);
                    if (!Thread.currentThread().isInterrupted()) continue;
                    log.warn("skipping kill task scheduling because thread is interrupted.", new Object[0]);
                    break;
                }
            }
        }
        return params;
    }

    @VisibleForTesting
    Interval findIntervalForKillTask(String dataSource, int limit) {
        List<Interval> unusedSegmentIntervals = this.segmentManager.getUnusedSegmentIntervals(dataSource, new Interval(0L, System.currentTimeMillis() - this.retainDuration), limit);
        if (unusedSegmentIntervals != null && unusedSegmentIntervals.size() > 0) {
            return JodaUtils.umbrellaInterval(unusedSegmentIntervals);
        }
        return null;
    }
}

