/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator.helper;

import java.util.Set;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class DruidCoordinatorSegmentInfoLoader
implements DruidCoordinatorHelper {
    private final DruidCoordinator coordinator;
    private static final Logger log = new Logger(DruidCoordinatorSegmentInfoLoader.class);

    public DruidCoordinatorSegmentInfoLoader(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        log.info("Starting coordination. Getting available segments.", new Object[0]);
        Set<DataSegment> availableSegments = this.coordinator.getOrderedAvailableDataSegments();
        if (log.isDebugEnabled()) {
            log.debug("Available DataSegments", new Object[0]);
            for (DataSegment dataSegment : availableSegments) {
                log.debug("  %s", dataSegment);
            }
        }
        log.info("Found [%,d] available segments.", availableSegments.size());
        return params.buildFromExisting().withAvailableSegments(availableSegments).build();
    }
}

