/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator.helper;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.MinMaxPriorityQueue;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.io.druid.client.DruidDataSource;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.collections.CountingMap;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorStats;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class DruidCoordinatorLogger
implements DruidCoordinatorHelper {
    private static final Logger log = new Logger(DruidCoordinatorLogger.class);
    private final DruidCoordinator coordinator;

    public DruidCoordinatorLogger(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    private <T extends Number> void emitTieredStats(ServiceEmitter emitter, String metricName, Map<String, T> statMap) {
        if (statMap != null) {
            for (Map.Entry<String, T> entry : statMap.entrySet()) {
                String tier = entry.getKey();
                Number value = (Number)entry.getValue();
                emitter.emit(new ServiceMetricEvent.Builder().setDimension("tier", tier).build(metricName, value.doubleValue()));
            }
        }
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        String dataSource;
        Map map;
        Map map2;
        DruidCluster cluster = params.getDruidCluster();
        CoordinatorStats stats = params.getCoordinatorStats();
        ServiceEmitter emitter = params.getEmitter();
        Map assigned = stats.getPerTierStats().get("assignedCount");
        if (assigned != null) {
            for (Map.Entry entry : assigned.entrySet()) {
                log.info("[%s] : Assigned %s segments among %,d servers", entry.getKey(), ((AtomicLong)entry.getValue()).get(), cluster.get((String)entry.getKey()).size());
            }
        }
        this.emitTieredStats(emitter, "segment/assigned/count", assigned);
        Map dropped = stats.getPerTierStats().get("droppedCount");
        if (dropped != null) {
            for (Map.Entry entry : dropped.entrySet()) {
                log.info("[%s] : Dropped %s segments among %,d servers", entry.getKey(), ((AtomicLong)entry.getValue()).get(), cluster.get((String)entry.getKey()).size());
            }
        }
        this.emitTieredStats(emitter, "segment/dropped/count", dropped);
        this.emitTieredStats(emitter, "segment/cost/raw", (Map)stats.getPerTierStats().get("initialCost"));
        this.emitTieredStats(emitter, "segment/cost/normalization", (Map)stats.getPerTierStats().get("normalization"));
        this.emitTieredStats(emitter, "segment/moved/count", (Map)stats.getPerTierStats().get("movedCount"));
        this.emitTieredStats(emitter, "segment/deleted/count", (Map)stats.getPerTierStats().get("deletedCount"));
        Map map3 = stats.getPerTierStats().get("normalizedInitialCostTimesOneThousand");
        if (map3 != null) {
            this.emitTieredStats(emitter, "segment/cost/normalized", Maps.transformEntries(map3, new Maps.EntryTransformer<String, AtomicLong, Number>(){

                @Override
                public Number transformEntry(String key, AtomicLong value) {
                    return value.doubleValue() / 1000.0;
                }
            }));
        }
        if ((map2 = (Map)stats.getPerTierStats().get("unneededCount")) != null) {
            for (Map.Entry entry : map2.entrySet()) {
                log.info("[%s] : Removed %s unneeded segments among %,d servers", entry.getKey(), ((AtomicLong)entry.getValue()).get(), cluster.get((String)entry.getKey()).size());
            }
        }
        this.emitTieredStats(emitter, "segment/unneeded/count", (Map)stats.getPerTierStats().get("unneededCount"));
        emitter.emit(new ServiceMetricEvent.Builder().build("segment/overShadowed/count", (Number)stats.getGlobalStats().get("overShadowedCount")));
        Map moved = stats.getPerTierStats().get("movedCount");
        if (moved != null) {
            for (Map.Entry entry : moved.entrySet()) {
                log.info("[%s] : Moved %,d segment(s)", entry.getKey(), ((AtomicLong)entry.getValue()).get());
            }
        }
        if ((map = (Map)stats.getPerTierStats().get("unmovedCount")) != null) {
            for (Map.Entry entry : map.entrySet()) {
                log.info("[%s] : Let alone %,d segment(s)", entry.getKey(), ((AtomicLong)entry.getValue()).get());
            }
        }
        log.info("Load Queues:", new Object[0]);
        for (MinMaxPriorityQueue<ServerHolder> minMaxPriorityQueue : cluster.getSortedServersByTier()) {
            for (ServerHolder serverHolder : minMaxPriorityQueue) {
                ImmutableDruidServer immutableDruidServer = serverHolder.getServer();
                Iterator<DataSegment> queuePeon = serverHolder.getPeon();
                log.info("Server[%s, %s, %s] has %,d left to load, %,d left to drop, %,d bytes queued, %,d bytes served.", immutableDruidServer.getName(), immutableDruidServer.getType(), immutableDruidServer.getTier(), ((LoadQueuePeon)((Object)queuePeon)).getSegmentsToLoad().size(), ((LoadQueuePeon)((Object)queuePeon)).getSegmentsToDrop().size(), ((LoadQueuePeon)((Object)queuePeon)).getLoadQueueSize(), immutableDruidServer.getCurrSize());
                if (!log.isDebugEnabled()) continue;
                for (DataSegment segment : ((LoadQueuePeon)((Object)queuePeon)).getSegmentsToLoad()) {
                    log.debug("Segment to load[%s]", segment);
                }
                for (DataSegment segment : ((LoadQueuePeon)((Object)queuePeon)).getSegmentsToDrop()) {
                    log.debug("Segment to drop[%s]", segment);
                }
            }
        }
        Set<Map.Entry<String, LoadQueuePeon>> set = params.getLoadManagementPeons().entrySet();
        for (Map.Entry<String, LoadQueuePeon> entry : set) {
            String serverName = entry.getKey();
            LoadQueuePeon loadQueuePeon = entry.getValue();
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("server", serverName).build("segment/loadQueue/size", loadQueuePeon.getLoadQueueSize()));
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("server", serverName).build("segment/loadQueue/failed", loadQueuePeon.getAndResetFailedAssignCount()));
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("server", serverName).build("segment/loadQueue/count", loadQueuePeon.getSegmentsToLoad().size()));
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("server", serverName).build("segment/dropQueue/count", loadQueuePeon.getSegmentsToDrop().size()));
        }
        for (Map.Entry entry : this.coordinator.getSegmentAvailability().entrySet()) {
            String datasource = (String)entry.getKey();
            Long l = ((AtomicLong)entry.getValue()).get();
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("dataSource", datasource).build("segment/unavailable/count", l));
        }
        for (Map.Entry<String, CountingMap<String>> entry : this.coordinator.getReplicationStatus().entrySet()) {
            String tier = entry.getKey();
            CountingMap<String> countingMap = entry.getValue();
            for (Map.Entry entry2 : countingMap.entrySet()) {
                String datasource = (String)entry2.getKey();
                Long count = ((AtomicLong)entry2.getValue()).get();
                emitter.emit(new ServiceMetricEvent.Builder().setDimension("tier", tier).setDimension("dataSource", datasource).build("segment/underReplicated/count", count));
            }
        }
        CountingMap<String> countingMap = new CountingMap<String>();
        CountingMap<String> countingMap2 = new CountingMap<String>();
        for (DruidDataSource druidDataSource : params.getDataSources()) {
            for (DataSegment dataSegment : druidDataSource.getSegments()) {
                countingMap.add(druidDataSource.getName(), dataSegment.getSize());
                countingMap2.add(druidDataSource.getName(), 1L);
            }
        }
        for (Map.Entry entry : countingMap.snapshot().entrySet()) {
            dataSource = (String)entry.getKey();
            Long l = (Long)entry.getValue();
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("dataSource", dataSource).build("segment/size", l));
        }
        for (Map.Entry entry : countingMap2.snapshot().entrySet()) {
            dataSource = (String)entry.getKey();
            Long l = (Long)entry.getValue();
            emitter.emit(new ServiceMetricEvent.Builder().setDimension("dataSource", dataSource).build("segment/count", l));
        }
        return params;
    }
}

