/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.io.IOException;
import java.util.concurrent.Executors;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.server.coordinator.BalancerStrategyFactory;
import org.apache.hive.druid.io.druid.server.coordinator.CostBalancerStrategy;
import org.joda.time.DateTime;

public class CostBalancerStrategyFactory
implements BalancerStrategyFactory {
    private final ListeningExecutorService exec;

    public CostBalancerStrategyFactory(int costBalancerStrategyThreadCount) {
        this.exec = MoreExecutors.listeningDecorator(Executors.newFixedThreadPool(costBalancerStrategyThreadCount));
    }

    @Override
    public CostBalancerStrategy createBalancerStrategy(DateTime referenceTimestamp) {
        return new CostBalancerStrategy(this.exec);
    }

    @Override
    public void close() throws IOException {
        this.exec.shutdownNow();
    }
}

