/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordination;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.guava.FunctionalIterable;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.io.druid.client.CachingQueryRunner;
import org.apache.hive.druid.io.druid.client.cache.Cache;
import org.apache.hive.druid.io.druid.client.cache.CacheConfig;
import org.apache.hive.druid.io.druid.collections.CountingMap;
import org.apache.hive.druid.io.druid.guice.annotations.BackgroundCaching;
import org.apache.hive.druid.io.druid.guice.annotations.Processing;
import org.apache.hive.druid.io.druid.guice.annotations.Smile;
import org.apache.hive.druid.io.druid.query.BySegmentQueryRunner;
import org.apache.hive.druid.io.druid.query.CPUTimeMetricQueryRunner;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.FinalizeResultsQueryRunner;
import org.apache.hive.druid.io.druid.query.MetricsEmittingQueryRunner;
import org.apache.hive.druid.io.druid.query.NoopQueryRunner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.hive.druid.io.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.ReferenceCountingSegmentQueryRunner;
import org.apache.hive.druid.io.druid.query.ReportTimelineMissingSegmentQueryRunner;
import org.apache.hive.druid.io.druid.query.SegmentDescriptor;
import org.apache.hive.druid.io.druid.query.TableDataSource;
import org.apache.hive.druid.io.druid.query.spec.SpecificSegmentQueryRunner;
import org.apache.hive.druid.io.druid.query.spec.SpecificSegmentSpec;
import org.apache.hive.druid.io.druid.segment.ReferenceCountingSegment;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoader;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.io.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionHolder;
import org.joda.time.Interval;

public class ServerManager
implements QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(ServerManager.class);
    private final Object lock = new Object();
    private final SegmentLoader segmentLoader;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final ServiceEmitter emitter;
    private final ExecutorService exec;
    private final ExecutorService cachingExec;
    private final Map<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>> dataSources;
    private final CountingMap<String> dataSourceSizes = new CountingMap();
    private final CountingMap<String> dataSourceCounts = new CountingMap();
    private final Cache cache;
    private final ObjectMapper objectMapper;
    private final CacheConfig cacheConfig;

    @Inject
    public ServerManager(SegmentLoader segmentLoader, QueryRunnerFactoryConglomerate conglomerate, ServiceEmitter emitter, @Processing ExecutorService exec, @BackgroundCaching ExecutorService cachingExec, @Smile ObjectMapper objectMapper, Cache cache, CacheConfig cacheConfig) {
        this.segmentLoader = segmentLoader;
        this.conglomerate = conglomerate;
        this.emitter = emitter;
        this.exec = exec;
        this.cachingExec = cachingExec;
        this.cache = cache;
        this.objectMapper = objectMapper;
        this.dataSources = new HashMap<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>>();
        this.cacheConfig = cacheConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getDataSourceSizes() {
        CountingMap<String> countingMap = this.dataSourceSizes;
        synchronized (countingMap) {
            return this.dataSourceSizes.snapshot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getDataSourceCounts() {
        CountingMap<String> countingMap = this.dataSourceCounts;
        synchronized (countingMap) {
            return this.dataSourceCounts.snapshot();
        }
    }

    public boolean isSegmentCached(DataSegment segment) throws SegmentLoadingException {
        return this.segmentLoader.isSegmentLoaded(segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSegment(DataSegment segment) throws SegmentLoadingException {
        Segment adapter;
        try {
            adapter = this.segmentLoader.getSegment(segment);
        }
        catch (SegmentLoadingException e) {
            try {
                this.segmentLoader.cleanup(segment);
            }
            catch (SegmentLoadingException segmentLoadingException) {
                // empty catch block
            }
            throw e;
        }
        if (adapter == null) {
            throw new SegmentLoadingException("Null adapter from loadSpec[%s]", segment.getLoadSpec());
        }
        Object object = this.lock;
        synchronized (object) {
            PartitionHolder<ReferenceCountingSegment> entry;
            String dataSource = segment.getDataSource();
            VersionedIntervalTimeline<String, ReferenceCountingSegment> loadedIntervals = this.dataSources.get(dataSource);
            if (loadedIntervals == null) {
                loadedIntervals = new VersionedIntervalTimeline(Ordering.natural());
                this.dataSources.put(dataSource, loadedIntervals);
            }
            if ((entry = loadedIntervals.findEntry(segment.getInterval(), segment.getVersion())) != null && entry.getChunk(segment.getShardSpec().getPartitionNum()) != null) {
                log.warn("Told to load a adapter for a segment[%s] that already exists", segment.getIdentifier());
                return false;
            }
            loadedIntervals.add(segment.getInterval(), segment.getVersion(), segment.getShardSpec().createChunk(new ReferenceCountingSegment(adapter)));
            CountingMap<String> countingMap = this.dataSourceSizes;
            synchronized (countingMap) {
                this.dataSourceSizes.add(dataSource, segment.getSize());
            }
            countingMap = this.dataSourceCounts;
            synchronized (countingMap) {
                this.dataSourceCounts.add(dataSource, 1L);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSegment(DataSegment segment) throws SegmentLoadingException {
        String dataSource = segment.getDataSource();
        Object object = this.lock;
        synchronized (object) {
            ReferenceCountingSegment oldQueryable;
            VersionedIntervalTimeline<String, ReferenceCountingSegment> loadedIntervals = this.dataSources.get(dataSource);
            if (loadedIntervals == null) {
                log.info("Told to delete a queryable for a dataSource[%s] that doesn't exist.", dataSource);
                return;
            }
            PartitionChunk<ReferenceCountingSegment> removed = loadedIntervals.remove(segment.getInterval(), segment.getVersion(), segment.getShardSpec().createChunk(null));
            ReferenceCountingSegment referenceCountingSegment = oldQueryable = removed == null ? null : removed.getObject();
            if (oldQueryable != null) {
                CountingMap<String> countingMap = this.dataSourceSizes;
                synchronized (countingMap) {
                    this.dataSourceSizes.add(dataSource, -segment.getSize());
                }
                countingMap = this.dataSourceCounts;
                synchronized (countingMap) {
                    this.dataSourceCounts.add(dataSource, -1L);
                }
                try {
                    log.info("Attempting to close segment %s", segment.getIdentifier());
                    oldQueryable.close();
                }
                catch (IOException e) {
                    log.makeAlert(e, "Exception closing segment", new Object[0]).addData("dataSource", dataSource).addData("segmentId", segment.getIdentifier()).emit();
                }
            } else {
                log.info("Told to delete a queryable on dataSource[%s] for interval[%s] and version [%s] that I don't have.", dataSource, segment.getInterval(), segment.getVersion());
            }
        }
        this.segmentLoader.cleanup(segment);
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        final QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            throw new ISE("Unknown query type[%s].", query.getClass());
        }
        final QueryToolChest toolChest = factory.getToolchest();
        final Function builderFn = ServerManager.getBuilderFn(toolChest);
        final AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
        DataSource dataSource = query.getDataSource();
        if (!(dataSource instanceof TableDataSource)) {
            throw new UnsupportedOperationException("data source type '" + dataSource.getClass().getName() + "' unsupported");
        }
        String dataSourceName = this.getDataSourceName(dataSource);
        final VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.dataSources.get(dataSourceName);
        if (timeline == null) {
            return new NoopQueryRunner();
        }
        FunctionalIterable queryRunners = FunctionalIterable.create(intervals).transformCat(new Function<Interval, Iterable<TimelineObjectHolder<String, ReferenceCountingSegment>>>(){

            @Override
            public Iterable<TimelineObjectHolder<String, ReferenceCountingSegment>> apply(Interval input) {
                return timeline.lookup(input);
            }
        }).transformCat(new Function<TimelineObjectHolder<String, ReferenceCountingSegment>, Iterable<QueryRunner<T>>>(){

            @Override
            public Iterable<QueryRunner<T>> apply(final @Nullable TimelineObjectHolder<String, ReferenceCountingSegment> holder) {
                if (holder == null) {
                    return null;
                }
                return FunctionalIterable.create(holder.getObject()).transform(new Function<PartitionChunk<ReferenceCountingSegment>, QueryRunner<T>>(){

                    @Override
                    public QueryRunner<T> apply(PartitionChunk<ReferenceCountingSegment> input) {
                        return ServerManager.this.buildAndDecorateQueryRunner(factory, toolChest, input.getObject(), new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), input.getChunkNumber()), builderFn, cpuTimeAccumulator);
                    }
                });
            }
        });
        return CPUTimeMetricQueryRunner.safeBuild(new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners(this.exec, queryRunners)), toolChest), builderFn, this.emitter, cpuTimeAccumulator, true);
    }

    private String getDataSourceName(DataSource dataSource) {
        return Iterables.getOnlyElement(dataSource.getNames());
    }

    @Override
    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        final QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            log.makeAlert("Unknown query type, [%s]", query.getClass()).addData("dataSource", query.getDataSource()).emit();
            return new NoopQueryRunner();
        }
        final QueryToolChest toolChest = factory.getToolchest();
        String dataSourceName = this.getDataSourceName(query.getDataSource());
        final VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.dataSources.get(dataSourceName);
        if (timeline == null) {
            return new NoopQueryRunner();
        }
        final Function builderFn = ServerManager.getBuilderFn(toolChest);
        final AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
        FunctionalIterable queryRunners = FunctionalIterable.create(specs).transformCat(new Function<SegmentDescriptor, Iterable<QueryRunner<T>>>(){

            @Override
            public Iterable<QueryRunner<T>> apply(SegmentDescriptor input) {
                PartitionHolder entry = timeline.findEntry(input.getInterval(), input.getVersion());
                if (entry == null) {
                    return Arrays.asList(new ReportTimelineMissingSegmentQueryRunner(input));
                }
                PartitionChunk chunk = entry.getChunk(input.getPartitionNumber());
                if (chunk == null) {
                    return Arrays.asList(new ReportTimelineMissingSegmentQueryRunner(input));
                }
                ReferenceCountingSegment adapter = (ReferenceCountingSegment)chunk.getObject();
                return Arrays.asList(ServerManager.this.buildAndDecorateQueryRunner(factory, toolChest, adapter, input, builderFn, cpuTimeAccumulator));
            }
        });
        return CPUTimeMetricQueryRunner.safeBuild(new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners(this.exec, queryRunners)), toolChest), builderFn, this.emitter, cpuTimeAccumulator, true);
    }

    private <T> QueryRunner<T> buildAndDecorateQueryRunner(QueryRunnerFactory<T, Query<T>> factory, final QueryToolChest<T, Query<T>> toolChest, ReferenceCountingSegment adapter, SegmentDescriptor segmentDescriptor, Function<Query<T>, ServiceMetricEvent.Builder> builderFn, AtomicLong cpuTimeAccumulator) {
        SpecificSegmentSpec segmentSpec = new SpecificSegmentSpec(segmentDescriptor);
        return CPUTimeMetricQueryRunner.safeBuild(new SpecificSegmentQueryRunner<T>(new MetricsEmittingQueryRunner<T>(this.emitter, builderFn, new BySegmentQueryRunner<T>(adapter.getIdentifier(), adapter.getDataInterval().getStart(), new CachingQueryRunner<T>(adapter.getIdentifier(), segmentDescriptor, this.objectMapper, this.cache, toolChest, new MetricsEmittingQueryRunner<T>(this.emitter, new Function<Query<T>, ServiceMetricEvent.Builder>(){

            @Override
            public ServiceMetricEvent.Builder apply(@Nullable Query<T> input) {
                return toolChest.makeMetricBuilder(input);
            }
        }, new ReferenceCountingSegmentQueryRunner<T>(factory, adapter, segmentDescriptor), "query/segment/time", ImmutableMap.of("segment", adapter.getIdentifier())), this.cachingExec, this.cacheConfig)), "query/segmentAndCache/time", ImmutableMap.of("segment", adapter.getIdentifier())).withWaitMeasuredFromNow(), segmentSpec), builderFn, this.emitter, cpuTimeAccumulator, false);
    }

    private static <T> Function<Query<T>, ServiceMetricEvent.Builder> getBuilderFn(final QueryToolChest<T, Query<T>> toolChest) {
        return new Function<Query<T>, ServiceMetricEvent.Builder>(){

            @Override
            @Nullable
            public ServiceMetricEvent.Builder apply(@Nullable Query<T> input) {
                return toolChest.makeMetricBuilder(input);
            }
        };
    }
}

