/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server;

import java.util.Arrays;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.server.QueryStats;
import org.joda.time.DateTime;

public class RequestLogLine {
    private static final Joiner JOINER = Joiner.on("\t");
    private final DateTime timestamp;
    private final String remoteAddr;
    private final Query query;
    private final QueryStats queryStats;

    public RequestLogLine(DateTime timestamp, String remoteAddr, Query query, QueryStats queryStats) {
        this.timestamp = timestamp;
        this.remoteAddr = remoteAddr;
        this.query = query;
        this.queryStats = queryStats;
    }

    public String getLine(ObjectMapper objectMapper) throws JsonProcessingException {
        return JOINER.join(Arrays.asList(this.timestamp, this.remoteAddr, objectMapper.writeValueAsString(this.query), objectMapper.writeValueAsString(this.queryStats)));
    }

    @JsonProperty(value="timestamp")
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="query")
    public Query getQuery() {
        return this.query;
    }

    @JsonProperty(value="remoteAddr")
    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    @JsonProperty(value="queryStats")
    public QueryStats getQueryStats() {
        return this.queryStats;
    }
}

