/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.plumber;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.io.druid.segment.incremental.IndexSizeExceededException;
import org.apache.hive.druid.io.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.hive.druid.io.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.io.druid.segment.realtime.FireHydrant;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;

public class Sink
implements Iterable<FireHydrant> {
    private static final int ADD_FAILED = -1;
    private final Object hydrantLock = new Object();
    private final Interval interval;
    private final DataSchema schema;
    private final ShardSpec shardSpec;
    private final String version;
    private final int maxRowsInMemory;
    private final boolean reportParseExceptions;
    private final CopyOnWriteArrayList<FireHydrant> hydrants = new CopyOnWriteArrayList();
    private final LinkedHashSet<String> dimOrder = Sets.newLinkedHashSet();
    private final AtomicInteger numRowsExcludingCurrIndex = new AtomicInteger();
    private volatile FireHydrant currHydrant;
    private volatile boolean writable = true;

    public Sink(Interval interval, DataSchema schema, ShardSpec shardSpec, String version, int maxRowsInMemory, boolean reportParseExceptions) {
        this.schema = schema;
        this.shardSpec = shardSpec;
        this.interval = interval;
        this.version = version;
        this.maxRowsInMemory = maxRowsInMemory;
        this.reportParseExceptions = reportParseExceptions;
        this.makeNewCurrIndex(interval.getStartMillis(), schema);
    }

    public Sink(Interval interval, DataSchema schema, ShardSpec shardSpec, String version, int maxRowsInMemory, boolean reportParseExceptions, List<FireHydrant> hydrants) {
        this.schema = schema;
        this.shardSpec = shardSpec;
        this.interval = interval;
        this.version = version;
        this.maxRowsInMemory = maxRowsInMemory;
        this.reportParseExceptions = reportParseExceptions;
        int maxCount = -1;
        for (int i = 0; i < hydrants.size(); ++i) {
            FireHydrant hydrant = hydrants.get(i);
            if (hydrant.getCount() <= maxCount) {
                throw new ISE("hydrant[%s] not the right count[%s]", hydrant, i);
            }
            maxCount = hydrant.getCount();
            this.numRowsExcludingCurrIndex.addAndGet(hydrant.getSegment().asQueryableIndex().getNumRows());
        }
        this.hydrants.addAll(hydrants);
        this.makeNewCurrIndex(interval.getStartMillis(), schema);
    }

    public String getVersion() {
        return this.version;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public FireHydrant getCurrHydrant() {
        return this.currHydrant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(InputRow row) throws IndexSizeExceededException {
        if (this.currHydrant == null) {
            throw new IAE("No currHydrant but given row[%s]", row);
        }
        Object object = this.hydrantLock;
        synchronized (object) {
            if (!this.writable) {
                return -1;
            }
            IncrementalIndex index = this.currHydrant.getIndex();
            if (index == null) {
                return -1;
            }
            return index.add(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAppendRow() {
        Object object = this.hydrantLock;
        synchronized (object) {
            return this.writable && this.currHydrant != null && this.currHydrant.getIndex().canAppendRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.hydrantLock;
        synchronized (object) {
            return this.hydrants.size() == 1 && this.currHydrant.getIndex().isEmpty();
        }
    }

    public boolean isWritable() {
        return this.writable;
    }

    public FireHydrant swap() {
        return this.makeNewCurrIndex(this.interval.getStartMillis(), this.schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean swappable() {
        Object object = this.hydrantLock;
        synchronized (object) {
            return this.writable && this.currHydrant.getIndex() != null && this.currHydrant.getIndex().size() != 0;
        }
    }

    public boolean finished() {
        return !this.writable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishWriting() {
        Object object = this.hydrantLock;
        synchronized (object) {
            this.writable = false;
        }
    }

    public DataSegment getSegment() {
        return new DataSegment(this.schema.getDataSource(), this.interval, this.version, ImmutableMap.of(), Lists.newArrayList(), Lists.transform(Arrays.asList(this.schema.getAggregators()), new Function<AggregatorFactory, String>(){

            @Override
            public String apply(@Nullable AggregatorFactory input) {
                return input.getName();
            }
        }), this.shardSpec, null, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRows() {
        Object object = this.hydrantLock;
        synchronized (object) {
            return this.numRowsExcludingCurrIndex.get() + this.currHydrant.getIndex().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRowsInMemory() {
        Object object = this.hydrantLock;
        synchronized (object) {
            IncrementalIndex index = this.currHydrant.getIndex();
            if (index == null) {
                return 0;
            }
            return this.currHydrant.getIndex().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FireHydrant makeNewCurrIndex(long minTimestamp, DataSchema schema) {
        FireHydrant old;
        IncrementalIndexSchema indexSchema = new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withTimestampSpec(schema.getParser()).withQueryGranularity(schema.getGranularitySpec().getQueryGranularity()).withDimensionsSpec(schema.getParser()).withMetrics(schema.getAggregators()).withRollup(schema.getGranularitySpec().isRollup()).build();
        OnheapIncrementalIndex newIndex = new OnheapIncrementalIndex(indexSchema, this.reportParseExceptions, this.maxRowsInMemory);
        Object object = this.hydrantLock;
        synchronized (object) {
            if (this.writable) {
                old = this.currHydrant;
                int newCount = 0;
                int numHydrants = this.hydrants.size();
                if (numHydrants > 0) {
                    FireHydrant lastHydrant = this.hydrants.get(numHydrants - 1);
                    newCount = lastHydrant.getCount() + 1;
                    if (!indexSchema.getDimensionsSpec().hasCustomDimensions()) {
                        HashMap<String, ColumnCapabilitiesImpl> oldCapabilities;
                        if (lastHydrant.hasSwapped()) {
                            oldCapabilities = Maps.newHashMap();
                            QueryableIndex oldIndex = lastHydrant.getSegment().asQueryableIndex();
                            for (String dim : oldIndex.getAvailableDimensions()) {
                                this.dimOrder.add(dim);
                                oldCapabilities.put(dim, (ColumnCapabilitiesImpl)oldIndex.getColumn(dim).getCapabilities());
                            }
                        } else {
                            IncrementalIndex oldIndex = lastHydrant.getIndex();
                            this.dimOrder.addAll(oldIndex.getDimensionOrder());
                            oldCapabilities = oldIndex.getColumnCapabilities();
                        }
                        newIndex.loadDimensionIterable(this.dimOrder, oldCapabilities);
                    }
                }
                this.currHydrant = new FireHydrant(newIndex, newCount, this.getSegment().getIdentifier());
                if (old != null) {
                    this.numRowsExcludingCurrIndex.addAndGet(old.getIndex().size());
                }
            } else {
                ((IncrementalIndex)newIndex).close();
                throw new ISE("finishWriting() called during swap", new Object[0]);
            }
            this.hydrants.add(this.currHydrant);
        }
        return old;
    }

    @Override
    public Iterator<FireHydrant> iterator() {
        return Iterators.filter(this.hydrants.iterator(), new Predicate<FireHydrant>(){

            @Override
            public boolean apply(FireHydrant input) {
                IncrementalIndex index = input.getIndex();
                return index == null || index.size() != 0;
            }
        });
    }

    public String toString() {
        return "Sink{interval=" + this.interval + ", schema=" + this.schema + '}';
    }
}

