/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.firehose;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.data.input.Firehose;
import org.apache.hive.druid.io.druid.data.input.FirehoseFactory;
import org.apache.hive.druid.io.druid.data.input.impl.FileIteratingFirehose;
import org.apache.hive.druid.io.druid.data.input.impl.StringInputRowParser;

public class LocalFirehoseFactory
implements FirehoseFactory<StringInputRowParser> {
    private static final EmittingLogger log = new EmittingLogger(LocalFirehoseFactory.class);
    private final File baseDir;
    private final String filter;
    private final StringInputRowParser parser;

    @JsonCreator
    public LocalFirehoseFactory(@JsonProperty(value="baseDir") File baseDir, @JsonProperty(value="filter") String filter, @JsonProperty(value="parser") StringInputRowParser parser) {
        this.baseDir = baseDir;
        this.filter = filter;
        this.parser = parser;
    }

    @JsonProperty
    public File getBaseDir() {
        return this.baseDir;
    }

    @JsonProperty
    public String getFilter() {
        return this.filter;
    }

    @JsonProperty
    public StringInputRowParser getParser() {
        return this.parser;
    }

    @Override
    public Firehose connect(StringInputRowParser firehoseParser) throws IOException {
        if (this.baseDir == null) {
            throw new IAE("baseDir is null", new Object[0]);
        }
        log.info("Searching for all [%s] in and beneath [%s]", this.filter, this.baseDir.getAbsoluteFile());
        Collection foundFiles = FileUtils.listFiles((File)this.baseDir.getAbsoluteFile(), (IOFileFilter)new WildcardFileFilter(this.filter), (IOFileFilter)TrueFileFilter.INSTANCE);
        if (foundFiles == null || foundFiles.isEmpty()) {
            throw new ISE("Found no files to ingest! Check your schema.", new Object[0]);
        }
        log.info("Found files: " + foundFiles, new Object[0]);
        final LinkedList files = Lists.newLinkedList(foundFiles);
        return new FileIteratingFirehose(new Iterator<LineIterator>(){

            @Override
            public boolean hasNext() {
                return !files.isEmpty();
            }

            @Override
            public LineIterator next() {
                try {
                    return FileUtils.lineIterator((File)((File)files.poll()));
                }
                catch (Exception e) {
                    throw Throwables.propagate(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }, firehoseParser);
    }
}

