/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.loading.QueryableIndexFactory;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;

public class MMappedQueryableIndexFactory
implements QueryableIndexFactory {
    private static final Logger log = new Logger(MMappedQueryableIndexFactory.class);
    private final IndexIO indexIO;

    @Inject
    public MMappedQueryableIndexFactory(IndexIO indexIO) {
        this.indexIO = Preconditions.checkNotNull(indexIO, "Null IndexIO");
    }

    @Override
    public QueryableIndex factorize(File parentDir) throws SegmentLoadingException {
        try {
            return this.indexIO.loadIndex(parentDir);
        }
        catch (IOException e) {
            throw new SegmentLoadingException(e, "%s", e.getMessage());
        }
    }
}

