/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.incremental;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.com.metamx.common.parsers.ParseException;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.granularity.QueryGranularity;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.io.druid.segment.incremental.IndexSizeExceededException;

public class OnheapIncrementalIndex
extends IncrementalIndex<Aggregator> {
    private static final Logger log = new Logger(OnheapIncrementalIndex.class);
    private final ConcurrentHashMap<Integer, Aggregator[]> aggregators = new ConcurrentHashMap();
    private final IncrementalIndex.FactsHolder facts;
    private final AtomicInteger indexIncrement = new AtomicInteger(0);
    protected final int maxRowCount;
    private volatile Map<String, ColumnSelectorFactory> selectors;
    private String outOfRowsReason = null;

    public OnheapIncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, boolean deserializeComplexMetrics, boolean reportParseExceptions, boolean sortFacts, int maxRowCount) {
        super(incrementalIndexSchema, deserializeComplexMetrics, reportParseExceptions);
        this.maxRowCount = maxRowCount;
        this.facts = incrementalIndexSchema.isRollup() ? new IncrementalIndex.RollupFactsHolder(sortFacts, this.dimsComparator(), this.getDimensions()) : new IncrementalIndex.PlainFactsHolder(sortFacts);
    }

    public OnheapIncrementalIndex(long minTimestamp, QueryGranularity gran, AggregatorFactory[] metrics, boolean deserializeComplexMetrics, boolean reportParseExceptions, boolean sortFacts, int maxRowCount) {
        this(new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withQueryGranularity(gran).withMetrics(metrics).withRollup(true).build(), deserializeComplexMetrics, reportParseExceptions, sortFacts, maxRowCount);
    }

    public OnheapIncrementalIndex(long minTimestamp, QueryGranularity gran, boolean rollup, AggregatorFactory[] metrics, int maxRowCount) {
        this(new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withQueryGranularity(gran).withMetrics(metrics).withRollup(rollup).build(), true, true, true, maxRowCount);
    }

    public OnheapIncrementalIndex(long minTimestamp, QueryGranularity gran, AggregatorFactory[] metrics, int maxRowCount) {
        this(minTimestamp, gran, true, metrics, maxRowCount);
    }

    public OnheapIncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, boolean reportParseExceptions, int maxRowCount) {
        this(incrementalIndexSchema, true, reportParseExceptions, true, maxRowCount);
    }

    @Override
    public IncrementalIndex.FactsHolder getFacts() {
        return this.facts;
    }

    protected Aggregator[] initAggs(AggregatorFactory[] metrics, Supplier<InputRow> rowSupplier, boolean deserializeComplexMetrics) {
        this.selectors = Maps.newHashMap();
        for (AggregatorFactory agg : metrics) {
            this.selectors.put(agg.getName(), new ObjectCachingColumnSelectorFactory(OnheapIncrementalIndex.makeColumnSelectorFactory(agg, rowSupplier, deserializeComplexMetrics, this.getColumnCapabilities())));
        }
        return new Aggregator[metrics.length];
    }

    @Override
    protected Integer addToFacts(AggregatorFactory[] metrics, boolean deserializeComplexMetrics, boolean reportParseExceptions, InputRow row, AtomicInteger numEntries, IncrementalIndex.TimeAndDims key, ThreadLocal<InputRow> rowContainer, Supplier<InputRow> rowSupplier) throws IndexSizeExceededException {
        Integer priorIndex = this.facts.getPriorIndex(key);
        if (null != priorIndex) {
            Aggregator[] aggs = this.concurrentGet(priorIndex);
            this.doAggregate(aggs, rowContainer, row, reportParseExceptions);
        } else {
            Aggregator[] aggs = new Aggregator[metrics.length];
            this.factorizeAggs(metrics, aggs, rowContainer, row);
            this.doAggregate(aggs, rowContainer, row, reportParseExceptions);
            Integer rowIndex = this.indexIncrement.getAndIncrement();
            this.concurrentSet(rowIndex, aggs);
            if (numEntries.get() >= this.maxRowCount && this.facts.getPriorIndex(key) == null) {
                throw new IndexSizeExceededException("Maximum number of rows [%d] reached", this.maxRowCount);
            }
            Integer prev = this.facts.putIfAbsent(key, rowIndex);
            if (null == prev) {
                numEntries.incrementAndGet();
            } else {
                aggs = this.concurrentGet(prev);
                this.doAggregate(aggs, rowContainer, row, reportParseExceptions);
                this.concurrentRemove(rowIndex);
            }
        }
        return numEntries.get();
    }

    private void factorizeAggs(AggregatorFactory[] metrics, Aggregator[] aggs, ThreadLocal<InputRow> rowContainer, InputRow row) {
        rowContainer.set(row);
        for (int i = 0; i < metrics.length; ++i) {
            AggregatorFactory agg = metrics[i];
            aggs[i] = agg.factorize(this.selectors.get(agg.getName()));
        }
        rowContainer.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAggregate(Aggregator[] aggs, ThreadLocal<InputRow> rowContainer, InputRow row, boolean reportParseExceptions) {
        rowContainer.set(row);
        Aggregator[] aggregatorArray = aggs;
        int n = aggregatorArray.length;
        for (int i = 0; i < n; ++i) {
            Aggregator agg;
            Aggregator aggregator = agg = aggregatorArray[i];
            synchronized (aggregator) {
                try {
                    agg.aggregate();
                }
                catch (ParseException e) {
                    if (reportParseExceptions) {
                        throw new ParseException(e, "Encountered parse error for aggregator[%s]", agg.getName());
                    }
                    log.debug(e, "Encountered parse error, skipping aggregator[%s].", agg.getName());
                }
                continue;
            }
        }
        rowContainer.set(null);
    }

    protected Aggregator[] concurrentGet(int offset) {
        return this.aggregators.get(offset);
    }

    protected void concurrentSet(int offset, Aggregator[] value) {
        this.aggregators.put(offset, value);
    }

    protected void concurrentRemove(int offset) {
        this.aggregators.remove(offset);
    }

    @Override
    public boolean canAppendRow() {
        boolean canAdd;
        boolean bl = canAdd = this.size() < this.maxRowCount;
        if (!canAdd) {
            this.outOfRowsReason = String.format("Maximum number of rows [%d] reached", this.maxRowCount);
        }
        return canAdd;
    }

    @Override
    public String getOutOfRowsReason() {
        return this.outOfRowsReason;
    }

    protected Aggregator[] getAggsForRow(int rowOffset) {
        return this.concurrentGet(rowOffset);
    }

    @Override
    protected Object getAggVal(Aggregator agg, int rowOffset, int aggPosition) {
        return agg.get();
    }

    @Override
    public float getMetricFloatValue(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].getFloat();
    }

    @Override
    public long getMetricLongValue(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].getLong();
    }

    @Override
    public Object getMetricObjectValue(int rowOffset, int aggOffset) {
        return this.concurrentGet(rowOffset)[aggOffset].get();
    }

    @Override
    public void close() {
        super.close();
        this.aggregators.clear();
        this.facts.clear();
        if (this.selectors != null) {
            this.selectors.clear();
        }
    }

    static class ObjectCachingColumnSelectorFactory
    implements ColumnSelectorFactory {
        private final ConcurrentMap<String, LongColumnSelector> longColumnSelectorMap = Maps.newConcurrentMap();
        private final ConcurrentMap<String, FloatColumnSelector> floatColumnSelectorMap = Maps.newConcurrentMap();
        private final ConcurrentMap<String, ObjectColumnSelector> objectColumnSelectorMap = Maps.newConcurrentMap();
        private final ColumnSelectorFactory delegate;

        public ObjectCachingColumnSelectorFactory(ColumnSelectorFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return this.delegate.makeDimensionSelector(dimensionSpec);
        }

        @Override
        public FloatColumnSelector makeFloatColumnSelector(String columnName) {
            FloatColumnSelector existing = (FloatColumnSelector)this.floatColumnSelectorMap.get(columnName);
            if (existing != null) {
                return existing;
            }
            FloatColumnSelector newSelector = this.delegate.makeFloatColumnSelector(columnName);
            FloatColumnSelector prev = this.floatColumnSelectorMap.putIfAbsent(columnName, newSelector);
            return prev != null ? prev : newSelector;
        }

        @Override
        public LongColumnSelector makeLongColumnSelector(String columnName) {
            LongColumnSelector existing = (LongColumnSelector)this.longColumnSelectorMap.get(columnName);
            if (existing != null) {
                return existing;
            }
            LongColumnSelector newSelector = this.delegate.makeLongColumnSelector(columnName);
            LongColumnSelector prev = this.longColumnSelectorMap.putIfAbsent(columnName, newSelector);
            return prev != null ? prev : newSelector;
        }

        @Override
        public ObjectColumnSelector makeObjectColumnSelector(String columnName) {
            ObjectColumnSelector existing = (ObjectColumnSelector)this.objectColumnSelectorMap.get(columnName);
            if (existing != null) {
                return existing;
            }
            ObjectColumnSelector newSelector = this.delegate.makeObjectColumnSelector(columnName);
            ObjectColumnSelector prev = this.objectColumnSelectorMap.putIfAbsent(columnName, newSelector);
            return prev != null ? prev : newSelector;
        }

        @Override
        public ColumnCapabilities getColumnCapabilities(String columnName) {
            return this.delegate.getColumnCapabilities(columnName);
        }
    }
}

