/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.incremental;

import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterators;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.io.druid.granularity.QueryGranularity;
import org.apache.hive.druid.io.druid.query.QueryInterruptedException;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcherFactory;
import org.apache.hive.druid.io.druid.segment.Capabilities;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.DimensionHandler;
import org.apache.hive.druid.io.druid.segment.DimensionIndexer;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.Metadata;
import org.apache.hive.druid.io.druid.segment.NullDimensionSelector;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;
import org.apache.hive.druid.io.druid.segment.SingleScanTimeDimSelector;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.ListIndexed;
import org.apache.hive.druid.io.druid.segment.filter.BooleanValueMatcher;
import org.apache.hive.druid.io.druid.segment.filter.Filters;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class IncrementalIndexStorageAdapter
implements StorageAdapter {
    private static final NullDimensionSelector NULL_DIMENSION_SELECTOR = new NullDimensionSelector();
    private final IncrementalIndex index;

    public IncrementalIndexStorageAdapter(IncrementalIndex index) {
        this.index = index;
    }

    @Override
    public String getSegmentIdentifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Interval getInterval() {
        return this.index.getInterval();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return new ListIndexed<String>(this.index.getDimensionNames(), String.class);
    }

    @Override
    public Iterable<String> getAvailableMetrics() {
        return this.index.getMetricNames();
    }

    @Override
    public int getDimensionCardinality(String dimension) {
        if (dimension.equals("__time")) {
            return Integer.MAX_VALUE;
        }
        IncrementalIndex.DimensionDesc desc = this.index.getDimension(dimension);
        if (desc == null) {
            return 0;
        }
        DimensionIndexer indexer = this.index.getDimension(dimension).getIndexer();
        return indexer.getCardinality();
    }

    @Override
    public int getNumRows() {
        return this.index.size();
    }

    @Override
    public DateTime getMinTime() {
        return this.index.getMinTime();
    }

    @Override
    public DateTime getMaxTime() {
        return this.index.getMaxTime();
    }

    @Override
    public Comparable getMinValue(String column) {
        IncrementalIndex.DimensionDesc desc = this.index.getDimension(column);
        if (desc == null) {
            return null;
        }
        DimensionIndexer indexer = desc.getIndexer();
        return indexer.getMinValue();
    }

    @Override
    public Comparable getMaxValue(String column) {
        IncrementalIndex.DimensionDesc desc = this.index.getDimension(column);
        if (desc == null) {
            return null;
        }
        DimensionIndexer indexer = desc.getIndexer();
        return indexer.getMaxValue();
    }

    @Override
    public Capabilities getCapabilities() {
        return Capabilities.builder().dimensionValuesSorted(false).build();
    }

    @Override
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.index.getCapabilities(column);
    }

    @Override
    public Map<String, DimensionHandler> getDimensionHandlers() {
        return this.index.getDimensionHandlers();
    }

    @Override
    public String getColumnTypeName(String column) {
        String metricType = this.index.getMetricType(column);
        return metricType != null ? metricType : this.getColumnCapabilities(column).getType().toString();
    }

    @Override
    public DateTime getMaxIngestedEventTime() {
        return this.index.getMaxIngestedEventTime();
    }

    @Override
    public Sequence<Cursor> makeCursors(final Filter filter, Interval interval, final QueryGranularity gran, final boolean descending) {
        if (this.index.isEmpty()) {
            return Sequences.empty();
        }
        Interval actualIntervalTmp = interval;
        Interval dataInterval = new Interval(this.getMinTime().getMillis(), gran.next(gran.truncate(this.getMaxTime().getMillis())));
        if (!actualIntervalTmp.overlaps((ReadableInterval)dataInterval)) {
            return Sequences.empty();
        }
        if (actualIntervalTmp.getStart().isBefore((ReadableInstant)dataInterval.getStart())) {
            actualIntervalTmp = actualIntervalTmp.withStart((ReadableInstant)dataInterval.getStart());
        }
        if (actualIntervalTmp.getEnd().isAfter((ReadableInstant)dataInterval.getEnd())) {
            actualIntervalTmp = actualIntervalTmp.withEnd((ReadableInstant)dataInterval.getEnd());
        }
        final Interval actualInterval = actualIntervalTmp;
        Iterable<Long> iterable = gran.iterable(actualInterval.getStartMillis(), actualInterval.getEndMillis());
        if (descending) {
            iterable = Lists.reverse(ImmutableList.copyOf(iterable));
        }
        return Sequences.map(Sequences.simple(iterable), new Function<Long, Cursor>(){
            EntryHolder currEntry = new EntryHolder();

            @Override
            public Cursor apply(final @Nullable Long input) {
                final long timeStart = Math.max(input, actualInterval.getStartMillis());
                return new Cursor(){
                    private final ValueMatcher filterMatcher;
                    private Iterator<Map.Entry<IncrementalIndex.TimeAndDims, Integer>> baseIter;
                    private Iterable<Map.Entry<IncrementalIndex.TimeAndDims, Integer>> cursorIterable;
                    private boolean emptyRange;
                    final DateTime time;
                    int numAdvanced;
                    boolean done;
                    {
                        this.filterMatcher = IncrementalIndexStorageAdapter.this.makeFilterMatcher(filter, this, currEntry);
                        this.numAdvanced = -1;
                        this.cursorIterable = IncrementalIndexStorageAdapter.this.index.getFacts().timeRangeIterable(descending, timeStart, Math.min(actualInterval.getEndMillis(), gran.next(input)));
                        this.emptyRange = !this.cursorIterable.iterator().hasNext();
                        this.time = gran.toDateTime(input);
                        this.reset();
                    }

                    @Override
                    public DateTime getTime() {
                        return this.time;
                    }

                    @Override
                    public void advance() {
                        if (!this.baseIter.hasNext()) {
                            this.done = true;
                            return;
                        }
                        while (this.baseIter.hasNext()) {
                            if (Thread.interrupted()) {
                                throw new QueryInterruptedException(new InterruptedException());
                            }
                            currEntry.set(this.baseIter.next());
                            if (!this.filterMatcher.matches()) continue;
                            return;
                        }
                        if (!this.filterMatcher.matches()) {
                            this.done = true;
                        }
                    }

                    @Override
                    public void advanceTo(int offset) {
                        for (int count = 0; count < offset && !this.isDone(); ++count) {
                            this.advance();
                        }
                    }

                    @Override
                    public boolean isDone() {
                        return this.done;
                    }

                    @Override
                    public void reset() {
                        this.baseIter = this.cursorIterable.iterator();
                        if (this.numAdvanced == -1) {
                            this.numAdvanced = 0;
                        } else {
                            Iterators.advance(this.baseIter, this.numAdvanced);
                        }
                        if (Thread.interrupted()) {
                            throw new QueryInterruptedException(new InterruptedException());
                        }
                        boolean foundMatched = false;
                        while (this.baseIter.hasNext()) {
                            currEntry.set(this.baseIter.next());
                            if (this.filterMatcher.matches()) {
                                foundMatched = true;
                                break;
                            }
                            ++this.numAdvanced;
                        }
                        this.done = !foundMatched && (this.emptyRange || !this.baseIter.hasNext());
                    }

                    @Override
                    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
                        String dimension = dimensionSpec.getDimension();
                        ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
                        if (dimension.equals("__time")) {
                            SingleScanTimeDimSelector selector = new SingleScanTimeDimSelector(this.makeLongColumnSelector(dimension), extractionFn, descending);
                            return dimensionSpec.decorate(selector);
                        }
                        IncrementalIndex.DimensionDesc dimensionDesc = IncrementalIndexStorageAdapter.this.index.getDimension(dimensionSpec.getDimension());
                        if (dimensionDesc == null) {
                            return dimensionSpec.decorate(NULL_DIMENSION_SELECTOR);
                        }
                        DimensionIndexer indexer = dimensionDesc.getIndexer();
                        return dimensionSpec.decorate((DimensionSelector)indexer.makeColumnValueSelector(dimensionSpec, currEntry, dimensionDesc));
                    }

                    @Override
                    public FloatColumnSelector makeFloatColumnSelector(String columnName) {
                        Integer dimIndex = IncrementalIndexStorageAdapter.this.index.getDimensionIndex(columnName);
                        if (dimIndex != null) {
                            IncrementalIndex.DimensionDesc dimensionDesc = IncrementalIndexStorageAdapter.this.index.getDimension(columnName);
                            DimensionIndexer indexer = dimensionDesc.getIndexer();
                            return (FloatColumnSelector)indexer.makeColumnValueSelector(new DefaultDimensionSpec(columnName, null), currEntry, dimensionDesc);
                        }
                        Integer metricIndexInt = IncrementalIndexStorageAdapter.this.index.getMetricIndex(columnName);
                        if (metricIndexInt == null) {
                            return new FloatColumnSelector(){

                                @Override
                                public float get() {
                                    return 0.0f;
                                }
                            };
                        }
                        final int metricIndex = metricIndexInt;
                        return new FloatColumnSelector(){

                            @Override
                            public float get() {
                                return IncrementalIndexStorageAdapter.this.index.getMetricFloatValue(currEntry.getValue(), metricIndex);
                            }
                        };
                    }

                    @Override
                    public LongColumnSelector makeLongColumnSelector(String columnName) {
                        if (columnName.equals("__time")) {
                            return new LongColumnSelector(){

                                @Override
                                public long get() {
                                    return currEntry.getKey().getTimestamp();
                                }
                            };
                        }
                        Integer dimIndex = IncrementalIndexStorageAdapter.this.index.getDimensionIndex(columnName);
                        if (dimIndex != null) {
                            IncrementalIndex.DimensionDesc dimensionDesc = IncrementalIndexStorageAdapter.this.index.getDimension(columnName);
                            DimensionIndexer indexer = dimensionDesc.getIndexer();
                            return (LongColumnSelector)indexer.makeColumnValueSelector(new DefaultDimensionSpec(columnName, null), currEntry, dimensionDesc);
                        }
                        Integer metricIndexInt = IncrementalIndexStorageAdapter.this.index.getMetricIndex(columnName);
                        if (metricIndexInt == null) {
                            return new LongColumnSelector(){

                                @Override
                                public long get() {
                                    return 0L;
                                }
                            };
                        }
                        final int metricIndex = metricIndexInt;
                        return new LongColumnSelector(){

                            @Override
                            public long get() {
                                return IncrementalIndexStorageAdapter.this.index.getMetricLongValue(currEntry.getValue(), metricIndex);
                            }
                        };
                    }

                    @Override
                    public ObjectColumnSelector makeObjectColumnSelector(String column) {
                        if (column.equals("__time")) {
                            return new ObjectColumnSelector<Long>(){

                                @Override
                                public Class classOfObject() {
                                    return Long.TYPE;
                                }

                                @Override
                                public Long get() {
                                    return currEntry.getKey().getTimestamp();
                                }
                            };
                        }
                        Integer metricIndexInt = IncrementalIndexStorageAdapter.this.index.getMetricIndex(column);
                        if (metricIndexInt != null) {
                            final int metricIndex = metricIndexInt;
                            final Class classOfObject = IncrementalIndexStorageAdapter.this.index.getMetricClass(column);
                            return new ObjectColumnSelector(){

                                public Class classOfObject() {
                                    return classOfObject;
                                }

                                public Object get() {
                                    return IncrementalIndexStorageAdapter.this.index.getMetricObjectValue(currEntry.getValue(), metricIndex);
                                }
                            };
                        }
                        IncrementalIndex.DimensionDesc dimensionDesc = IncrementalIndexStorageAdapter.this.index.getDimension(column);
                        if (dimensionDesc != null) {
                            final int dimensionIndex = dimensionDesc.getIndex();
                            final DimensionIndexer indexer = dimensionDesc.getIndexer();
                            ColumnCapabilitiesImpl capabilities = dimensionDesc.getCapabilities();
                            return new ObjectColumnSelector<Object>(){

                                @Override
                                public Class classOfObject() {
                                    return Object.class;
                                }

                                @Override
                                public Object get() {
                                    IncrementalIndex.TimeAndDims key = currEntry.getKey();
                                    if (key == null) {
                                        return null;
                                    }
                                    Object[] dims = key.getDims();
                                    if (dimensionIndex >= dims.length) {
                                        return null;
                                    }
                                    Object dimVals = indexer.convertUnsortedEncodedArrayToActualArrayOrList(dims[dimensionIndex], false);
                                    return dimVals;
                                }
                            };
                        }
                        return null;
                    }

                    @Override
                    public ColumnCapabilities getColumnCapabilities(String columnName) {
                        return IncrementalIndexStorageAdapter.this.index.getCapabilities(columnName);
                    }
                };
            }
        });
    }

    private boolean isComparableNullOrEmpty(Comparable value) {
        if (value instanceof String) {
            return Strings.isNullOrEmpty((String)((Object)value));
        }
        return value == null;
    }

    private ValueMatcher makeFilterMatcher(Filter filter, Cursor cursor, EntryHolder holder) {
        return filter == null ? new BooleanValueMatcher(true) : filter.makeMatcher(new CursorAndEntryHolderValueMatcherFactory(cursor, holder));
    }

    @Override
    public Metadata getMetadata() {
        return this.index.getMetadata();
    }

    private class CursorAndEntryHolderValueMatcherFactory
    implements ValueMatcherFactory {
        private final EntryHolder holder;
        private final Cursor cursor;

        public CursorAndEntryHolderValueMatcherFactory(Cursor cursor, EntryHolder holder) {
            this.cursor = cursor;
            this.holder = holder;
        }

        @Override
        public ValueMatcher makeValueMatcher(String dimension, Comparable originalValue) {
            IncrementalIndex.DimensionDesc dimensionDesc = IncrementalIndexStorageAdapter.this.index.getDimension(dimension);
            if (dimensionDesc == null) {
                Integer metricIndexInt = IncrementalIndexStorageAdapter.this.index.getMetricIndex(dimension);
                if (metricIndexInt != null || dimension.equals("__time")) {
                    ValueType type = this.getTypeForDimension(dimension);
                    switch (type) {
                        case LONG: {
                            return Filters.getLongValueMatcher(this.cursor.makeLongColumnSelector(dimension), originalValue);
                        }
                    }
                    return new BooleanValueMatcher(IncrementalIndexStorageAdapter.this.isComparableNullOrEmpty(originalValue));
                }
                return new BooleanValueMatcher(IncrementalIndexStorageAdapter.this.isComparableNullOrEmpty(originalValue));
            }
            DimensionIndexer indexer = dimensionDesc.getIndexer();
            int dimIndex = dimensionDesc.getIndex();
            return indexer.makeIndexingValueMatcher(originalValue, this.holder, dimIndex);
        }

        @Override
        public ValueMatcher makeValueMatcher(String dimension, DruidPredicateFactory predicateFactory) {
            IncrementalIndex.DimensionDesc dimensionDesc = IncrementalIndexStorageAdapter.this.index.getDimension(dimension);
            if (dimensionDesc == null) {
                Integer metricIndexInt = IncrementalIndexStorageAdapter.this.index.getMetricIndex(dimension);
                if (metricIndexInt != null || dimension.equals("__time")) {
                    ValueType type = this.getTypeForDimension(dimension);
                    switch (type) {
                        case LONG: {
                            return this.makeLongValueMatcher(dimension, predicateFactory.makeLongPredicate());
                        }
                    }
                    return new BooleanValueMatcher(predicateFactory.makeStringPredicate().apply(null));
                }
                return new BooleanValueMatcher(predicateFactory.makeStringPredicate().apply(null));
            }
            DimensionIndexer indexer = dimensionDesc.getIndexer();
            int dimIndex = dimensionDesc.getIndex();
            return indexer.makeIndexingValueMatcher(predicateFactory, this.holder, dimIndex);
        }

        private ValueMatcher makeLongValueMatcher(String dimension, DruidLongPredicate predicate) {
            return Filters.getLongPredicateMatcher(this.cursor.makeLongColumnSelector(dimension), predicate);
        }

        private ValueType getTypeForDimension(String dimension) {
            ColumnCapabilities capabilities = IncrementalIndexStorageAdapter.this.index.getCapabilities(dimension);
            return capabilities == null ? ValueType.STRING : capabilities.getType();
        }
    }

    public static class EntryHolder {
        Map.Entry<IncrementalIndex.TimeAndDims, Integer> currEntry = null;

        public Map.Entry<IncrementalIndex.TimeAndDims, Integer> get() {
            return this.currEntry;
        }

        public void set(Map.Entry<IncrementalIndex.TimeAndDims, Integer> currEntry) {
            this.currEntry = currEntry;
        }

        public IncrementalIndex.TimeAndDims getKey() {
            return this.currEntry.getKey();
        }

        public Integer getValue() {
            return this.currEntry.getValue();
        }
    }
}

