/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.incremental;

import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.granularity.QueryGranularities;
import org.apache.hive.druid.io.druid.granularity.QueryGranularity;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;

public class IncrementalIndexSchema {
    public static final boolean DEFAULT_ROLLUP = true;
    private final long minTimestamp;
    private final TimestampSpec timestampSpec;
    private final QueryGranularity gran;
    private final DimensionsSpec dimensionsSpec;
    private final AggregatorFactory[] metrics;
    private final boolean rollup;

    public IncrementalIndexSchema(long minTimestamp, TimestampSpec timestampSpec, QueryGranularity gran, DimensionsSpec dimensionsSpec, AggregatorFactory[] metrics, boolean rollup) {
        this.minTimestamp = minTimestamp;
        this.timestampSpec = timestampSpec;
        this.gran = gran;
        this.dimensionsSpec = dimensionsSpec;
        this.metrics = metrics;
        this.rollup = rollup;
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public TimestampSpec getTimestampSpec() {
        return this.timestampSpec;
    }

    public QueryGranularity getGran() {
        return this.gran;
    }

    public DimensionsSpec getDimensionsSpec() {
        return this.dimensionsSpec;
    }

    public AggregatorFactory[] getMetrics() {
        return this.metrics;
    }

    public boolean isRollup() {
        return this.rollup;
    }

    public static class Builder {
        private long minTimestamp = 0L;
        private TimestampSpec timestampSpec;
        private QueryGranularity gran = QueryGranularities.NONE;
        private DimensionsSpec dimensionsSpec = new DimensionsSpec(null, null, null);
        private AggregatorFactory[] metrics = new AggregatorFactory[0];
        private boolean rollup = true;

        public Builder withMinTimestamp(long minTimestamp) {
            this.minTimestamp = minTimestamp;
            return this;
        }

        public Builder withTimestampSpec(TimestampSpec timestampSpec) {
            this.timestampSpec = timestampSpec;
            return this;
        }

        public Builder withTimestampSpec(InputRowParser parser) {
            this.timestampSpec = parser != null && parser.getParseSpec() != null && parser.getParseSpec().getTimestampSpec() != null ? parser.getParseSpec().getTimestampSpec() : new TimestampSpec(null, null, null);
            return this;
        }

        public Builder withQueryGranularity(QueryGranularity gran) {
            this.gran = gran;
            return this;
        }

        public Builder withDimensionsSpec(DimensionsSpec dimensionsSpec) {
            this.dimensionsSpec = dimensionsSpec;
            return this;
        }

        public Builder withDimensionsSpec(InputRowParser parser) {
            this.dimensionsSpec = parser != null && parser.getParseSpec() != null && parser.getParseSpec().getDimensionsSpec() != null ? parser.getParseSpec().getDimensionsSpec() : new DimensionsSpec(null, null, null);
            return this;
        }

        public Builder withMetrics(AggregatorFactory[] metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder withRollup(boolean rollup) {
            this.rollup = rollup;
            return this;
        }

        public IncrementalIndexSchema build() {
            return new IncrementalIndexSchema(this.minTimestamp, this.timestampSpec, this.gran, this.dimensionsSpec, this.metrics, this.rollup);
        }
    }
}

