/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.metamx.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.JavaScriptDimFilter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcherFactory;
import org.apache.hive.druid.io.druid.segment.filter.Filters;
import org.mozilla.javascript.Context;

public class JavaScriptFilter
implements Filter {
    private final String dimension;
    private final JavaScriptDimFilter.JavaScriptPredicateFactory predicateFactory;

    public JavaScriptFilter(String dimension, JavaScriptDimFilter.JavaScriptPredicateFactory predicate) {
        this.dimension = dimension;
        this.predicateFactory = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableBitmap getBitmapIndex(BitmapIndexSelector selector) {
        final Context cx = Context.enter();
        try {
            Predicate<String> contextualPredicate = new Predicate<String>(){

                @Override
                public boolean apply(String input) {
                    return JavaScriptFilter.this.predicateFactory.applyInContext(cx, input);
                }
            };
            ImmutableBitmap immutableBitmap = Filters.matchPredicate(this.dimension, selector, contextualPredicate);
            return immutableBitmap;
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        return factory.makeValueMatcher(this.dimension, this.predicateFactory);
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }
}

