/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.metamx.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.io.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcherFactory;
import org.apache.hive.druid.io.druid.segment.filter.Filters;

public class InFilter
implements Filter {
    private final String dimension;
    private final Set<String> values;
    private final ExtractionFn extractionFn;
    private final Supplier<DruidLongPredicate> longPredicateSupplier;

    public InFilter(String dimension, Set<String> values, Supplier<DruidLongPredicate> longPredicateSupplier, ExtractionFn extractionFn) {
        this.dimension = dimension;
        this.values = values;
        this.extractionFn = extractionFn;
        this.longPredicateSupplier = longPredicateSupplier;
    }

    @Override
    public ImmutableBitmap getBitmapIndex(final BitmapIndexSelector selector) {
        if (this.extractionFn == null) {
            return selector.getBitmapFactory().union(Iterables.transform(this.values, new Function<String, ImmutableBitmap>(){

                @Override
                public ImmutableBitmap apply(String value) {
                    return selector.getBitmapIndex(InFilter.this.dimension, value);
                }
            }));
        }
        return Filters.matchPredicate(this.dimension, selector, this.getPredicateFactory().makeStringPredicate());
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        return factory.makeValueMatcher(this.dimension, this.getPredicateFactory());
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }

    private DruidPredicateFactory getPredicateFactory() {
        return new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                if (InFilter.this.extractionFn != null) {
                    return new Predicate<String>(){

                        @Override
                        public boolean apply(String input) {
                            return InFilter.this.values.contains(Strings.nullToEmpty(InFilter.this.extractionFn.apply(input)));
                        }
                    };
                }
                return new Predicate<String>(){

                    @Override
                    public boolean apply(String input) {
                        return InFilter.this.values.contains(Strings.nullToEmpty(input));
                    }
                };
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                if (InFilter.this.extractionFn != null) {
                    return new DruidLongPredicate(){

                        @Override
                        public boolean applyLong(long input) {
                            return InFilter.this.values.contains(InFilter.this.extractionFn.apply(input));
                        }
                    };
                }
                return (DruidLongPredicate)InFilter.this.longPredicateSupplier.get();
            }
        };
    }
}

