/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.metamx.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.BitmapIndexSelector;
import org.apache.hive.druid.io.druid.query.filter.BoundDimFilter;
import org.apache.hive.druid.io.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.io.druid.query.filter.DruidPredicateFactory;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcher;
import org.apache.hive.druid.io.druid.query.filter.ValueMatcherFactory;
import org.apache.hive.druid.io.druid.query.ordering.StringComparators;
import org.apache.hive.druid.io.druid.segment.column.BitmapIndex;
import org.apache.hive.druid.io.druid.segment.filter.Filters;

public class BoundFilter
implements Filter {
    private final BoundDimFilter boundDimFilter;
    private final Comparator<String> comparator;
    private final ExtractionFn extractionFn;
    private final Supplier<DruidLongPredicate> longPredicateSupplier;

    public BoundFilter(BoundDimFilter boundDimFilter) {
        this.boundDimFilter = boundDimFilter;
        this.comparator = boundDimFilter.getOrdering();
        this.extractionFn = boundDimFilter.getExtractionFn();
        this.longPredicateSupplier = boundDimFilter.getLongPredicateSupplier();
    }

    @Override
    public ImmutableBitmap getBitmapIndex(BitmapIndexSelector selector) {
        if (this.boundDimFilter.getOrdering().equals(StringComparators.LEXICOGRAPHIC) && this.extractionFn == null) {
            int found;
            final BitmapIndex bitmapIndex = selector.getBitmapIndex(this.boundDimFilter.getDimension());
            if (bitmapIndex == null || bitmapIndex.getCardinality() == 0) {
                if (this.doesMatch(null)) {
                    return selector.getBitmapFactory().complement(selector.getBitmapFactory().makeEmptyImmutableBitmap(), selector.getNumRows());
                }
                return selector.getBitmapFactory().makeEmptyImmutableBitmap();
            }
            final int startIndex = !this.boundDimFilter.hasLowerBound() ? 0 : ((found = bitmapIndex.getIndex(this.boundDimFilter.getLower())) >= 0 ? (this.boundDimFilter.isLowerStrict() ? found + 1 : found) : -(found + 1));
            final int endIndex = !this.boundDimFilter.hasUpperBound() ? bitmapIndex.getCardinality() : ((found = bitmapIndex.getIndex(this.boundDimFilter.getUpper())) >= 0 ? (this.boundDimFilter.isUpperStrict() ? found : found + 1) : -(found + 1));
            return selector.getBitmapFactory().union(new Iterable<ImmutableBitmap>(){

                @Override
                public Iterator<ImmutableBitmap> iterator() {
                    return new Iterator<ImmutableBitmap>(){
                        int currIndex;
                        {
                            this.currIndex = startIndex;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.currIndex < endIndex;
                        }

                        @Override
                        public ImmutableBitmap next() {
                            return bitmapIndex.getBitmap(this.currIndex++);
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            });
        }
        return Filters.matchPredicate(this.boundDimFilter.getDimension(), selector, this.getPredicateFactory().makeStringPredicate());
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        return factory.makeValueMatcher(this.boundDimFilter.getDimension(), this.getPredicateFactory());
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.boundDimFilter.getDimension()) != null;
    }

    private DruidPredicateFactory getPredicateFactory() {
        return new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                if (BoundFilter.this.extractionFn != null) {
                    return new Predicate<String>(){

                        @Override
                        public boolean apply(String input) {
                            return BoundFilter.this.doesMatch(BoundFilter.this.extractionFn.apply(input));
                        }
                    };
                }
                return new Predicate<String>(){

                    @Override
                    public boolean apply(String input) {
                        return BoundFilter.this.doesMatch(input);
                    }
                };
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                if (BoundFilter.this.extractionFn != null) {
                    return new DruidLongPredicate(){

                        @Override
                        public boolean applyLong(long input) {
                            return BoundFilter.this.doesMatch(BoundFilter.this.extractionFn.apply(input));
                        }
                    };
                }
                if (BoundFilter.this.boundDimFilter.getOrdering().equals(StringComparators.NUMERIC)) {
                    return (DruidLongPredicate)BoundFilter.this.longPredicateSupplier.get();
                }
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        return BoundFilter.this.doesMatch(String.valueOf(input));
                    }
                };
            }
        };
    }

    private boolean doesMatch(String input) {
        if (input == null) {
            return (!this.boundDimFilter.hasLowerBound() || this.boundDimFilter.getLower().isEmpty() && !this.boundDimFilter.isLowerStrict()) && (!this.boundDimFilter.hasUpperBound() || !this.boundDimFilter.getUpper().isEmpty() || !this.boundDimFilter.isUpperStrict());
        }
        int lowerComparing = 1;
        int upperComparing = 1;
        if (this.boundDimFilter.hasLowerBound()) {
            lowerComparing = this.comparator.compare(input, this.boundDimFilter.getLower());
        }
        if (this.boundDimFilter.hasUpperBound()) {
            upperComparing = this.comparator.compare(this.boundDimFilter.getUpper(), input);
        }
        if (this.boundDimFilter.isLowerStrict() && this.boundDimFilter.isUpperStrict()) {
            return lowerComparing > 0 && upperComparing > 0;
        }
        if (this.boundDimFilter.isLowerStrict()) {
            return lowerComparing > 0 && upperComparing >= 0;
        }
        if (this.boundDimFilter.isUpperStrict()) {
            return lowerComparing >= 0 && upperComparing > 0;
        }
        return lowerComparing >= 0 && upperComparing >= 0;
    }
}

