/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import org.apache.hive.druid.io.druid.segment.data.Offset;

public class UnioningOffset
implements Offset {
    private final Offset[] offsets = new Offset[2];
    private final int[] offsetVals = new int[2];
    private int nextOffsetIndex;

    public UnioningOffset(Offset lhs, Offset rhs) {
        if (lhs.withinBounds()) {
            this.offsets[0] = lhs;
        }
        if (rhs.withinBounds()) {
            if (this.offsets[0] == null) {
                this.offsets[0] = rhs;
            } else {
                this.offsets[1] = rhs;
            }
        }
        if (this.offsets[0] != null) {
            this.offsetVals[0] = this.offsets[0].getOffset();
            if (this.offsets[1] != null) {
                this.offsetVals[1] = this.offsets[1].getOffset();
            }
        }
        this.figureOutNextValue();
    }

    private UnioningOffset(Offset[] offsets, int[] offsetVals, int nextOffsetIndex) {
        System.arraycopy(offsets, 0, this.offsets, 0, 2);
        System.arraycopy(offsetVals, 0, this.offsetVals, 0, 2);
        this.nextOffsetIndex = nextOffsetIndex;
    }

    private void figureOutNextValue() {
        if (this.offsets[0] != null) {
            if (this.offsets[1] != null) {
                int lhs = this.offsetVals[0];
                int rhs = this.offsetVals[1];
                if (lhs < rhs) {
                    this.nextOffsetIndex = 0;
                } else if (lhs == rhs) {
                    this.nextOffsetIndex = 0;
                    this.rollIndexForward(1);
                } else {
                    this.nextOffsetIndex = 1;
                }
            } else {
                this.nextOffsetIndex = 0;
            }
        }
    }

    private void rollIndexForward(int i) {
        this.offsets[i].increment();
        if (!this.offsets[i].withinBounds()) {
            this.offsets[i] = null;
            if (i == 0) {
                this.offsets[0] = this.offsets[1];
                this.offsetVals[0] = this.offsetVals[1];
            }
        } else {
            this.offsetVals[i] = this.offsets[i].getOffset();
        }
    }

    @Override
    public int getOffset() {
        return this.offsetVals[this.nextOffsetIndex];
    }

    @Override
    public void increment() {
        this.rollIndexForward(this.nextOffsetIndex);
        this.figureOutNextValue();
    }

    @Override
    public boolean withinBounds() {
        return this.offsets[0] != null;
    }

    @Override
    public Offset clone() {
        Offset[] newOffsets = new Offset[2];
        int[] newOffsetValues = new int[2];
        for (int i = 0; i < newOffsets.length; ++i) {
            newOffsets[i] = this.offsets[i] == null ? null : this.offsets[i].clone();
            newOffsetValues[i] = this.offsetVals[i];
        }
        return new UnioningOffset(newOffsets, newOffsetValues, this.nextOffsetIndex);
    }
}

