/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hive.druid.com.google.common.collect.BiMap;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.io.druid.segment.data.CompressedObjectStrategy;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.VSizeLongSerde;

public class TableLongEncodingWriter
implements CompressionFactory.LongEncodingWriter {
    private final BiMap<Long, Integer> table;
    private final int bitsPerValue;
    private VSizeLongSerde.LongSerializer serializer;

    public TableLongEncodingWriter(BiMap<Long, Integer> table) {
        if (table.size() > 256) {
            throw new IAE("Invalid table size[%s]", table.size());
        }
        this.table = table;
        this.bitsPerValue = VSizeLongSerde.getBitsForMax(table.size());
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        this.serializer = VSizeLongSerde.getSerializer(this.bitsPerValue, buffer, buffer.position());
    }

    @Override
    public void setOutputStream(OutputStream output) {
        this.serializer = VSizeLongSerde.getSerializer(this.bitsPerValue, output);
    }

    @Override
    public void write(long value) throws IOException {
        this.serializer.write(((Integer)this.table.get(value)).intValue());
    }

    @Override
    public void flush() throws IOException {
        if (this.serializer != null) {
            this.serializer.close();
        }
    }

    @Override
    public void putMeta(OutputStream metaOut, CompressedObjectStrategy.CompressionStrategy strategy) throws IOException {
        metaOut.write(CompressionFactory.setEncodingFlag(strategy.getId()));
        metaOut.write(CompressionFactory.LongEncodingFormat.TABLE.getId());
        metaOut.write(1);
        metaOut.write(Ints.toByteArray(this.table.size()));
        BiMap<Integer, Long> inverse = this.table.inverse();
        for (int i = 0; i < this.table.size(); ++i) {
            metaOut.write(Longs.toByteArray((Long)inverse.get(i)));
        }
    }

    @Override
    public int getBlockSize(int bytesPerBlock) {
        return VSizeLongSerde.getNumValuesPerBlock(this.bitsPerValue, bytesPerBlock);
    }

    @Override
    public int getNumBytes(int values) {
        return VSizeLongSerde.getSerializedSize(this.bitsPerValue, values);
    }
}

