/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.column;

import org.apache.hive.druid.io.druid.segment.column.AbstractColumn;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.io.druid.segment.column.GenericColumn;
import org.apache.hive.druid.io.druid.segment.column.IndexedFloatsGenericColumn;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.CompressedFloatsIndexedSupplier;

public class FloatColumn
extends AbstractColumn {
    private static final ColumnCapabilitiesImpl CAPABILITIES = new ColumnCapabilitiesImpl().setType(ValueType.FLOAT);
    private final CompressedFloatsIndexedSupplier column;

    public FloatColumn(CompressedFloatsIndexedSupplier column) {
        this.column = column;
    }

    @Override
    public ColumnCapabilities getCapabilities() {
        return CAPABILITIES;
    }

    @Override
    public int getLength() {
        return this.column.size();
    }

    @Override
    public GenericColumn getGenericColumn() {
        return new IndexedFloatsGenericColumn(this.column.get());
    }
}

