/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.column;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.io.druid.segment.column.Column;
import org.apache.hive.druid.io.druid.segment.column.ColumnBuilder;
import org.apache.hive.druid.io.druid.segment.column.ColumnConfig;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.serde.ColumnPartSerde;

public class ColumnDescriptor {
    private final ValueType valueType;
    private final boolean hasMultipleValues;
    private final List<ColumnPartSerde> parts;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    public ColumnDescriptor(@JsonProperty(value="valueType") ValueType valueType, @JsonProperty(value="hasMultipleValues") boolean hasMultipleValues, @JsonProperty(value="parts") List<ColumnPartSerde> parts) {
        this.valueType = valueType;
        this.hasMultipleValues = hasMultipleValues;
        this.parts = parts;
    }

    @JsonProperty
    public ValueType getValueType() {
        return this.valueType;
    }

    @JsonProperty
    public boolean isHasMultipleValues() {
        return this.hasMultipleValues;
    }

    @JsonProperty
    public List<ColumnPartSerde> getParts() {
        return this.parts;
    }

    public long numBytes() {
        long retVal = 0L;
        for (ColumnPartSerde part : this.parts) {
            retVal += part.getSerializer().numBytes();
        }
        return retVal;
    }

    public void write(WritableByteChannel channel) throws IOException {
        for (ColumnPartSerde part : this.parts) {
            part.getSerializer().write(channel);
        }
    }

    public Column read(ByteBuffer buffer, ColumnConfig columnConfig) {
        ColumnBuilder builder = new ColumnBuilder().setType(this.valueType).setHasMultipleValues(this.hasMultipleValues);
        for (ColumnPartSerde part : this.parts) {
            part.getDeserializer().read(buffer, builder, columnConfig);
        }
        return builder.build();
    }

    public static class Builder {
        private ValueType valueType = null;
        private Boolean hasMultipleValues = null;
        private final List<ColumnPartSerde> parts = Lists.newArrayList();

        public Builder setValueType(ValueType valueType) {
            if (this.valueType != null && this.valueType != valueType) {
                throw new IAE("valueType[%s] is already set, cannot change to[%s]", new Object[]{this.valueType, valueType});
            }
            this.valueType = valueType;
            return this;
        }

        public Builder setHasMultipleValues(boolean hasMultipleValues) {
            if (this.hasMultipleValues != null && this.hasMultipleValues != hasMultipleValues) {
                throw new IAE("hasMultipleValues[%s] is already set, cannot change to[%s]", this.hasMultipleValues, hasMultipleValues);
            }
            this.hasMultipleValues = hasMultipleValues;
            return this;
        }

        public Builder addSerde(ColumnPartSerde serde) {
            this.parts.add(serde);
            return this;
        }

        public ColumnDescriptor build() {
            Preconditions.checkNotNull(this.valueType, "must specify a valueType");
            return new ColumnDescriptor(this.valueType, this.hasMultipleValues == null ? false : this.hasMultipleValues, this.parts);
        }
    }
}

