/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.io.ByteSink;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.com.google.common.io.Closer;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.com.google.common.io.OutputSupplier;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.metamx.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.com.metamx.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.com.metamx.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.com.metamx.collections.spatial.ImmutableRTree;
import org.apache.hive.druid.com.metamx.collections.spatial.RTree;
import org.apache.hive.druid.com.metamx.collections.spatial.split.LinearGutmanSplitStrategy;
import org.apache.hive.druid.com.metamx.common.ByteBufferUtils;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.collections.CombiningIterable;
import org.apache.hive.druid.io.druid.common.guava.FileOutputSupplier;
import org.apache.hive.druid.io.druid.common.utils.SerializerUtils;
import org.apache.hive.druid.io.druid.segment.DimensionMergerLegacy;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.IndexableAdapter;
import org.apache.hive.druid.io.druid.segment.ProgressIndicator;
import org.apache.hive.druid.io.druid.segment.StringDimensionMergerV9;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.ByteBufferWriter;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexedWriter;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.IndexedRTree;
import org.apache.hive.druid.io.druid.segment.data.TmpFileIOPeon;
import org.apache.hive.druid.io.druid.segment.data.VSizeIndexedWriter;

public class StringDimensionMergerLegacy
extends StringDimensionMergerV9
implements DimensionMergerLegacy<int[]> {
    private static final Logger log = new Logger(StringDimensionMergerLegacy.class);
    private VSizeIndexedWriter encodedValueWriterV8;
    private IOPeon spatialIoPeon;
    private File dictionaryFile;

    public StringDimensionMergerLegacy(String dimensionName, IndexSpec indexSpec, File outDir, IOPeon ioPeon, ColumnCapabilities capabilities, ProgressIndicator progress) {
        super(dimensionName, indexSpec, outDir, ioPeon, capabilities, progress);
    }

    @Override
    protected void setupEncodedValueWriter() throws IOException {
        this.encodedValueWriterV8 = new VSizeIndexedWriter(this.ioPeon, this.dimensionName, this.cardinality);
        this.encodedValueWriterV8.open();
    }

    @Override
    protected void processMergedRowHelper(int[] vals) throws IOException {
        List<Integer> listToWrite = vals == null ? null : Ints.asList(vals);
        this.encodedValueWriterV8.add(listToWrite);
    }

    @Override
    public void writeIndexes(List<IntBuffer> segmentRowNumConversions, Closer closer) throws IOException {
        SerializerUtils serializerUtils = new SerializerUtils();
        long dimStartTime = System.currentTimeMillis();
        String bmpFilename = String.format("%s.inverted", this.dimensionName);
        this.bitmapWriter = new GenericIndexedWriter<ImmutableBitmap>(this.ioPeon, bmpFilename, this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
        this.bitmapWriter.open();
        final MappedByteBuffer dimValsMapped = Files.map(this.dictionaryFile);
        closer.register(new Closeable(){

            @Override
            public void close() throws IOException {
                ByteBufferUtils.unmap(dimValsMapped);
            }
        });
        if (!this.dimensionName.equals(serializerUtils.readString(dimValsMapped))) {
            throw new ISE("dimensions[%s] didn't equate!?  This is a major WTF moment.", this.dimensionName);
        }
        GenericIndexed<String> dimVals = GenericIndexed.read(dimValsMapped, GenericIndexed.STRING_STRATEGY);
        log.info("Starting dimension[%s] with cardinality[%,d]", this.dimensionName, dimVals.size());
        BitmapSerdeFactory bitmapSerdeFactory = this.indexSpec.getBitmapSerdeFactory();
        BitmapFactory bitmapFactory = bitmapSerdeFactory.getBitmapFactory();
        RTree tree = null;
        this.spatialWriter = null;
        boolean hasSpatial = this.capabilities.hasSpatialIndexes();
        this.spatialIoPeon = new TmpFileIOPeon();
        if (hasSpatial) {
            BitmapFactory bmpFactory = bitmapSerdeFactory.getBitmapFactory();
            String spatialFilename = String.format("%s.spatial", this.dimensionName);
            this.spatialWriter = new ByteBufferWriter<ImmutableRTree>(this.spatialIoPeon, spatialFilename, new IndexedRTree.ImmutableRTreeObjectStrategy(bmpFactory));
            this.spatialWriter.open();
            tree = new RTree(2, new LinearGutmanSplitStrategy(0, 50, bitmapFactory), bitmapFactory);
        }
        StringDimensionMergerV9.IndexSeeker[] dictIdSeeker = this.toIndexSeekers(this.adapters, this.dimConversions, this.dimensionName);
        for (int dictId = 0; dictId < dimVals.size(); ++dictId) {
            String dimVal;
            this.progress.progress();
            ArrayList<StringDimensionMergerV9.ConvertingIndexedInts> convertedInverteds = Lists.newArrayListWithCapacity(this.adapters.size());
            for (int j = 0; j < this.adapters.size(); ++j) {
                int seekedDictId = dictIdSeeker[j].seek(dictId);
                if (seekedDictId == -1) continue;
                convertedInverteds.add(new StringDimensionMergerV9.ConvertingIndexedInts(((IndexableAdapter)this.adapters.get(j)).getBitmapIndex(this.dimensionName, seekedDictId), segmentRowNumConversions.get(j)));
            }
            MutableBitmap bitset = bitmapSerdeFactory.getBitmapFactory().makeEmptyMutableBitmap();
            for (Integer row : CombiningIterable.createSplatted(convertedInverteds, Ordering.natural().nullsFirst())) {
                if (row == -1) continue;
                bitset.add(row);
            }
            if (dictId == 0 && Iterables.getFirst(dimVals, "") == null) {
                bitset.or(this.nullRowsBitmap);
            }
            this.bitmapWriter.write(bitmapSerdeFactory.getBitmapFactory().makeImmutableBitmap(bitset));
            if (!hasSpatial || (dimVal = (String)dimVals.get(dictId)) == null) continue;
            ArrayList<String> stringCoords = Lists.newArrayList(SPLITTER.split(dimVal));
            float[] coords = new float[stringCoords.size()];
            for (int j = 0; j < coords.length; ++j) {
                coords[j] = Float.valueOf((String)stringCoords.get(j)).floatValue();
            }
            tree.insert(coords, bitset);
        }
        log.info("Completed dimension[%s] in %,d millis.", this.dimensionName, System.currentTimeMillis() - dimStartTime);
        if (hasSpatial) {
            this.spatialWriter.write(ImmutableRTree.newImmutableFromMutable(tree));
        }
    }

    @Override
    public void writeValueMetadataToFile(FileOutputSupplier valueEncodingFile) throws IOException {
        SerializerUtils serializerUtils = new SerializerUtils();
        this.dictionaryWriter.close();
        serializerUtils.writeString(valueEncodingFile, this.dimensionName);
        ByteStreams.copy(this.dictionaryWriter.combineStreams(), (OutputSupplier<? extends OutputStream>)valueEncodingFile);
        this.dictionaryFile = valueEncodingFile.getFile();
    }

    @Override
    public void writeRowValuesToFile(FileOutputSupplier rowValueFile) throws IOException {
        this.encodedValueWriterV8.close();
        ByteStreams.copy(this.encodedValueWriterV8.combineStreams(), (OutputSupplier<? extends OutputStream>)rowValueFile);
    }

    @Override
    public void writeIndexesToFiles(final ByteSink invertedIndexFile, OutputSupplier<FileOutputStream> spatialIndexFile) throws IOException {
        SerializerUtils serializerUtils = new SerializerUtils();
        OutputSupplier<OutputStream> invertedIndexOutputSupplier = new OutputSupplier<OutputStream>(){

            @Override
            public OutputStream getOutput() throws IOException {
                return invertedIndexFile.openStream();
            }
        };
        this.bitmapWriter.close();
        serializerUtils.writeString((OutputSupplier<? extends OutputStream>)invertedIndexOutputSupplier, this.dimensionName);
        ByteStreams.copy(this.bitmapWriter.combineStreams(), (OutputSupplier<? extends OutputStream>)invertedIndexOutputSupplier);
        if (this.capabilities.hasSpatialIndexes()) {
            this.spatialWriter.close();
            serializerUtils.writeString(spatialIndexFile, this.dimensionName);
            ByteStreams.copy(this.spatialWriter.combineStreams(), spatialIndexFile);
            this.spatialIoPeon.cleanup();
        }
    }
}

