/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.Closeable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.FluentIterable;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.io.Closer;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.guava.CloseQuietly;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.segment.DimensionHandler;
import org.apache.hive.druid.io.druid.segment.IndexableAdapter;
import org.apache.hive.druid.io.druid.segment.Metadata;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.Rowboat;
import org.apache.hive.druid.io.druid.segment.column.BitmapIndex;
import org.apache.hive.druid.io.druid.segment.column.Column;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ComplexColumn;
import org.apache.hive.druid.io.druid.segment.column.DictionaryEncodedColumn;
import org.apache.hive.druid.io.druid.segment.column.GenericColumn;
import org.apache.hive.druid.io.druid.segment.column.IndexedFloatsGenericColumn;
import org.apache.hive.druid.io.druid.segment.column.IndexedLongsGenericColumn;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.BitmapCompressedIndexedInts;
import org.apache.hive.druid.io.druid.segment.data.EmptyIndexedInts;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.IndexedIterable;
import org.apache.hive.druid.io.druid.segment.data.ListIndexed;
import org.joda.time.Interval;

public class QueryableIndexIndexableAdapter
implements IndexableAdapter {
    private static final Logger log = new Logger(QueryableIndexIndexableAdapter.class);
    private final int numRows;
    private final QueryableIndex input;
    private final List<String> availableDimensions;
    private final Metadata metadata;

    public QueryableIndexIndexableAdapter(QueryableIndex input) {
        this.input = input;
        this.numRows = input.getNumRows();
        this.availableDimensions = Lists.newArrayList();
        for (String dim : input.getAvailableDimensions()) {
            Column col = input.getColumn(dim);
            if (col == null) {
                log.warn("Wtf!? column[%s] didn't exist!?!?!?", dim);
                continue;
            }
            if (col.getDictionaryEncoding() == null) {
                log.info("No dictionary on dimension[%s]", dim);
            }
            this.availableDimensions.add(dim);
        }
        this.metadata = input.getMetadata();
    }

    @Override
    public Interval getDataInterval() {
        return this.input.getDataInterval();
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public Indexed<String> getDimensionNames() {
        return new ListIndexed<String>(this.availableDimensions, String.class);
    }

    @Override
    public Indexed<String> getMetricNames() {
        LinkedHashSet<String> columns = Sets.newLinkedHashSet(this.input.getColumnNames());
        HashSet<String> dimensions = Sets.newHashSet(this.getDimensionNames());
        return new ListIndexed<String>(Lists.newArrayList(Sets.difference(columns, dimensions)), String.class);
    }

    @Override
    public Indexed<Comparable> getDimValueLookup(String dimension) {
        Column column = this.input.getColumn(dimension);
        if (column == null) {
            return null;
        }
        final DictionaryEncodedColumn dict = column.getDictionaryEncoding();
        if (dict == null) {
            return null;
        }
        return new Indexed<Comparable>(){

            @Override
            public Class<? extends Comparable> getClazz() {
                return Comparable.class;
            }

            @Override
            public int size() {
                return dict.getCardinality();
            }

            @Override
            public Comparable get(int index) {
                return dict.lookupName(index);
            }

            @Override
            public int indexOf(Comparable value) {
                return dict.lookupId(value);
            }

            @Override
            public Iterator<Comparable> iterator() {
                return IndexedIterable.create(this).iterator();
            }
        };
    }

    @Override
    public Iterable<Rowboat> getRows() {
        return new Iterable<Rowboat>(){

            @Override
            public Iterator<Rowboat> iterator() {
                return new Iterator<Rowboat>(){
                    final GenericColumn timestamps;
                    final Closeable[] metrics;
                    final Closeable[] columns;
                    final Closer closer;
                    final int numMetrics;
                    final DimensionHandler[] handlers;
                    Collection<DimensionHandler> handlerSet;
                    int currRow;
                    boolean done;
                    {
                        this.timestamps = QueryableIndexIndexableAdapter.this.input.getColumn("__time").getGenericColumn();
                        this.closer = Closer.create();
                        this.numMetrics = QueryableIndexIndexableAdapter.this.getMetricNames().size();
                        this.handlers = new DimensionHandler[QueryableIndexIndexableAdapter.this.availableDimensions.size()];
                        this.handlerSet = QueryableIndexIndexableAdapter.this.input.getDimensionHandlers().values();
                        this.currRow = 0;
                        this.done = false;
                        this.closer.register(this.timestamps);
                        this.handlerSet.toArray(this.handlers);
                        for (Closeable column : this.columns = FluentIterable.from(this.handlerSet).transform(new Function<DimensionHandler, Closeable>(){

                            @Override
                            public Closeable apply(DimensionHandler handler) {
                                Column column = QueryableIndexIndexableAdapter.this.input.getColumn(handler.getDimensionName());
                                return handler.getSubColumn(column);
                            }
                        }).toArray(Closeable.class)) {
                            this.closer.register(column);
                        }
                        Indexed<String> availableMetrics = QueryableIndexIndexableAdapter.this.getMetricNames();
                        this.metrics = new Closeable[availableMetrics.size()];
                        block5: for (int i = 0; i < this.metrics.length; ++i) {
                            Column column = QueryableIndexIndexableAdapter.this.input.getColumn(availableMetrics.get(i));
                            ValueType type = column.getCapabilities().getType();
                            switch (type) {
                                case FLOAT: 
                                case LONG: {
                                    this.metrics[i] = column.getGenericColumn();
                                    continue block5;
                                }
                                case COMPLEX: {
                                    this.metrics[i] = column.getComplexColumn();
                                    continue block5;
                                }
                                default: {
                                    throw new ISE("Cannot handle type[%s]", new Object[]{type});
                                }
                            }
                        }
                        for (Closeable metricColumn : this.metrics) {
                            this.closer.register(metricColumn);
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        boolean hasNext;
                        boolean bl = hasNext = this.currRow < QueryableIndexIndexableAdapter.this.numRows;
                        if (!hasNext && !this.done) {
                            CloseQuietly.close(this.closer);
                            this.done = true;
                        }
                        return hasNext;
                    }

                    @Override
                    public Rowboat next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Object[] dims = new Object[this.columns.length];
                        int dimIndex = 0;
                        for (Closeable column : this.columns) {
                            dims[dimIndex] = this.handlers[dimIndex].getRowValueArrayFromColumn(column, this.currRow);
                            ++dimIndex;
                        }
                        Object[] metricArray = new Object[this.numMetrics];
                        for (int i = 0; i < metricArray.length; ++i) {
                            if (this.metrics[i] instanceof IndexedFloatsGenericColumn) {
                                metricArray[i] = Float.valueOf(((GenericColumn)this.metrics[i]).getFloatSingleValueRow(this.currRow));
                                continue;
                            }
                            if (this.metrics[i] instanceof IndexedLongsGenericColumn) {
                                metricArray[i] = ((GenericColumn)this.metrics[i]).getLongSingleValueRow(this.currRow);
                                continue;
                            }
                            if (!(this.metrics[i] instanceof ComplexColumn)) continue;
                            metricArray[i] = ((ComplexColumn)this.metrics[i]).getRowValue(this.currRow);
                        }
                        Rowboat retVal = new Rowboat(this.timestamps.getLongSingleValueRow(this.currRow), dims, metricArray, this.currRow, this.handlers);
                        ++this.currRow;
                        return retVal;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @VisibleForTesting
    IndexedInts getBitmapIndex(String dimension, String value) {
        Column column = this.input.getColumn(dimension);
        if (column == null) {
            return EmptyIndexedInts.EMPTY_INDEXED_INTS;
        }
        BitmapIndex bitmaps = column.getBitmapIndex();
        if (bitmaps == null) {
            return EmptyIndexedInts.EMPTY_INDEXED_INTS;
        }
        return new BitmapCompressedIndexedInts(bitmaps.getBitmap(bitmaps.getIndex(value)));
    }

    @Override
    public String getMetricType(String metric) {
        Column column = this.input.getColumn(metric);
        ValueType type = column.getCapabilities().getType();
        switch (type) {
            case FLOAT: {
                return "float";
            }
            case LONG: {
                return "long";
            }
            case COMPLEX: {
                try (ComplexColumn complexColumn = column.getComplexColumn();){
                    String string = complexColumn.getTypeName();
                    return string;
                }
            }
        }
        throw new ISE("Unknown type[%s]", new Object[]{type});
    }

    @Override
    public ColumnCapabilities getCapabilities(String column) {
        return this.input.getColumn(column).getCapabilities();
    }

    @Override
    public IndexedInts getBitmapIndex(String dimension, int dictId) {
        Column column = this.input.getColumn(dimension);
        if (column == null) {
            return EmptyIndexedInts.EMPTY_INDEXED_INTS;
        }
        BitmapIndex bitmaps = column.getBitmapIndex();
        if (bitmaps == null) {
            return EmptyIndexedInts.EMPTY_INDEXED_INTS;
        }
        if (dictId >= 0) {
            return new BitmapCompressedIndexedInts(bitmaps.getBitmap(dictId));
        }
        return EmptyIndexedInts.EMPTY_INDEXED_INTS;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Map<String, DimensionHandler> getDimensionHandlers() {
        return this.input.getDimensionHandlers();
    }
}

