/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.lookup;

import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.io.druid.query.lookup.LookupModule;
import org.apache.hive.druid.io.druid.server.initialization.ZkPathsConfig;
import org.apache.hive.druid.io.druid.server.listener.announcer.ListeningAnnouncerConfig;
import org.apache.hive.druid.io.druid.server.metrics.DataSourceTaskIdHolder;

class LookupListeningAnnouncerConfig
extends ListeningAnnouncerConfig {
    public static final String DEFAULT_TIER = "__default";
    private final DataSourceTaskIdHolder dataSourceTaskIdHolder;
    @JsonProperty(value="lookupTier")
    private String lookupTier = null;
    @JsonProperty(value="lookupTierIsDatasource")
    private boolean lookupTierIsDatasource = false;

    @JsonCreator
    public LookupListeningAnnouncerConfig(@JacksonInject ZkPathsConfig zkPathsConfig, @JacksonInject DataSourceTaskIdHolder dataSourceTaskIdHolder) {
        super(zkPathsConfig);
        this.dataSourceTaskIdHolder = dataSourceTaskIdHolder;
    }

    public String getLookupTier() {
        Preconditions.checkArgument(!this.lookupTierIsDatasource || null == this.lookupTier, "Cannot specify both `lookupTier` and `lookupTierIsDatasource`");
        String lookupTier = this.lookupTierIsDatasource ? this.dataSourceTaskIdHolder.getDataSource() : this.lookupTier;
        return Preconditions.checkNotNull(lookupTier == null ? DEFAULT_TIER : Strings.emptyToNull(lookupTier), "Cannot have empty lookup tier from %s", this.lookupTierIsDatasource ? "bound value" : "druid.lookup");
    }

    public String getLookupKey() {
        return LookupModule.getTierListenerPath(this.getLookupTier());
    }
}

