/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.lookup;

import com.google.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactory;
import org.apache.hive.druid.io.druid.query.lookup.LookupIntrospectHandler;
import org.apache.hive.druid.io.druid.query.lookup.LookupReferencesManager;

@Path(value="/druid/v1/lookups/introspect")
public class LookupIntrospectionResource {
    private static final Logger LOGGER = new Logger(LookupIntrospectionResource.class);
    private final LookupReferencesManager lookupReferencesManager;

    @Inject
    public LookupIntrospectionResource(@Context LookupReferencesManager lookupReferencesManager) {
        this.lookupReferencesManager = lookupReferencesManager;
    }

    @Path(value="/{lookupId}")
    public Object introspectLookup(@PathParam(value="lookupId") String lookupId) {
        LookupExtractorFactory lookupExtractorFactory = this.lookupReferencesManager.get(lookupId);
        if (lookupExtractorFactory == null) {
            LOGGER.error("trying to introspect non existing lookup [%s]", lookupId);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        LookupIntrospectHandler introspectHandler = lookupExtractorFactory.getIntrospectHandler();
        if (introspectHandler != null) {
            return introspectHandler;
        }
        LOGGER.warn("Trying to introspect lookup [%s] of type [%s] but implementation doesn't provide resource", lookupId, ((LookupExtractor)lookupExtractorFactory.get()).getClass());
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

