/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.epinephelinae;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.guava.BaseSequence;
import org.apache.hive.druid.com.metamx.common.guava.CloseQuietly;
import org.apache.hive.druid.com.metamx.common.guava.ResourceClosingSequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.io.druid.collections.ResourceHolder;
import org.apache.hive.druid.io.druid.collections.StupidPool;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQueryConfig;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.BufferGrouper;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import org.apache.hive.druid.io.druid.query.groupby.epinephelinae.Grouper;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.data.EmptyIndexedInts;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.filter.Filters;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class GroupByQueryEngineV2 {
    private GroupByQueryEngineV2() {
    }

    public static Sequence<Row> process(final GroupByQuery query, StorageAdapter storageAdapter, StupidPool<ByteBuffer> intermediateResultsBufferPool, final GroupByQueryConfig config) {
        if (storageAdapter == null) {
            throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        List<Interval> intervals = query.getQuerySegmentSpec().getIntervals();
        if (intervals.size() != 1) {
            throw new IAE("Should only have one interval, got[%s]", intervals);
        }
        Sequence<Cursor> cursors = storageAdapter.makeCursors(Filters.toFilter(query.getDimFilter()), intervals.get(0), query.getGranularity(), false);
        final GroupByEngineKeySerde keySerde = new GroupByEngineKeySerde(query.getDimensions().size());
        final ResourceHolder<ByteBuffer> bufferHolder = intermediateResultsBufferPool.take();
        String fudgeTimestampString = Strings.emptyToNull(query.getContextValue("fudgeTimestamp", ""));
        final DateTime fudgeTimestamp = fudgeTimestampString == null ? null : new DateTime(Long.parseLong(fudgeTimestampString));
        return Sequences.concat(new ResourceClosingSequence(Sequences.map(cursors, new Function<Cursor, Sequence<Row>>(){

            @Override
            public Sequence<Row> apply(final Cursor cursor) {
                return new BaseSequence<Row, GroupByEngineIterator>(new BaseSequence.IteratorMaker<Row, GroupByEngineIterator>(){

                    @Override
                    public GroupByEngineIterator make() {
                        return new GroupByEngineIterator(query, config, cursor, (ByteBuffer)bufferHolder.get(), keySerde, fudgeTimestamp);
                    }

                    @Override
                    public void cleanup(GroupByEngineIterator iterFromMake) {
                        iterFromMake.close();
                    }
                });
            }
        }), new Closeable(){

            @Override
            public void close() throws IOException {
                CloseQuietly.close(bufferHolder);
            }
        }));
    }

    private static class GroupByEngineKeySerde
    implements Grouper.KeySerde<ByteBuffer> {
        private final int keySize;

        public GroupByEngineKeySerde(int dimCount) {
            this.keySize = dimCount * 4;
        }

        @Override
        public int keySize() {
            return this.keySize;
        }

        @Override
        public Class<ByteBuffer> keyClazz() {
            return ByteBuffer.class;
        }

        @Override
        public ByteBuffer toByteBuffer(ByteBuffer key) {
            return key;
        }

        @Override
        public ByteBuffer fromByteBuffer(ByteBuffer buffer, int position) {
            ByteBuffer dup = buffer.duplicate();
            dup.position(position).limit(position + this.keySize);
            return dup.slice();
        }

        @Override
        public Grouper.KeyComparator comparator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
        }
    }

    private static class GroupByEngineIterator
    implements Iterator<Row>,
    Closeable {
        private final GroupByQuery query;
        private final GroupByQueryConfig querySpecificConfig;
        private final Cursor cursor;
        private final ByteBuffer buffer;
        private final Grouper.KeySerde<ByteBuffer> keySerde;
        private final DateTime timestamp;
        private final DimensionSelector[] selectors;
        private final ByteBuffer keyBuffer;
        private final int[] stack;
        private final IndexedInts[] valuess;
        private int stackp = Integer.MIN_VALUE;
        private boolean currentRowWasPartiallyAggregated = false;
        private CloseableGrouperIterator<ByteBuffer, Row> delegate = null;

        public GroupByEngineIterator(GroupByQuery query, GroupByQueryConfig config, Cursor cursor, ByteBuffer buffer, Grouper.KeySerde<ByteBuffer> keySerde, DateTime fudgeTimestamp) {
            int dimCount = query.getDimensions().size();
            this.query = query;
            this.querySpecificConfig = config.withOverrides(query);
            this.cursor = cursor;
            this.buffer = buffer;
            this.keySerde = keySerde;
            this.keyBuffer = ByteBuffer.allocate(keySerde.keySize());
            this.selectors = new DimensionSelector[dimCount];
            for (int i = 0; i < dimCount; ++i) {
                this.selectors[i] = cursor.makeDimensionSelector(query.getDimensions().get(i));
            }
            this.stack = new int[dimCount];
            this.valuess = new IndexedInts[dimCount];
            this.timestamp = fudgeTimestamp != null ? fudgeTimestamp : cursor.getTime();
        }

        @Override
        public Row next() {
            if (this.delegate != null && this.delegate.hasNext()) {
                return this.delegate.next();
            }
            if (this.cursor.isDone()) {
                throw new NoSuchElementException();
            }
            if (this.delegate != null) {
                this.delegate.close();
                this.delegate = null;
            }
            final BufferGrouper<ByteBuffer> grouper = new BufferGrouper<ByteBuffer>(this.buffer, this.keySerde, this.cursor, this.query.getAggregatorSpecs().toArray(new AggregatorFactory[this.query.getAggregatorSpecs().size()]), this.querySpecificConfig.getBufferGrouperMaxSize(), this.querySpecificConfig.getBufferGrouperMaxLoadFactor(), this.querySpecificConfig.getBufferGrouperInitialBuckets());
            block0: while (!this.cursor.isDone()) {
                int position;
                if (!this.currentRowWasPartiallyAggregated) {
                    this.stackp = this.stack.length - 1;
                    for (int i = 0; i < this.selectors.length; ++i) {
                        DimensionSelector selector = this.selectors[i];
                        this.valuess[i] = selector == null ? EmptyIndexedInts.EMPTY_INDEXED_INTS : selector.getRow();
                        position = 4 * i;
                        if (this.valuess[i].size() == 0) {
                            this.stack[i] = 0;
                            this.keyBuffer.putInt(position, -1);
                            continue;
                        }
                        this.stack[i] = 1;
                        this.keyBuffer.putInt(position, this.valuess[i].get(0));
                    }
                }
                boolean doAggregate = true;
                while (this.stackp >= -1) {
                    if (doAggregate) {
                        this.keyBuffer.rewind();
                        if (!grouper.aggregate(this.keyBuffer)) {
                            this.currentRowWasPartiallyAggregated = true;
                            break block0;
                        }
                        doAggregate = false;
                    }
                    if (this.stackp >= 0 && this.stack[this.stackp] < this.valuess[this.stackp].size()) {
                        this.keyBuffer.putInt(4 * this.stackp, this.valuess[this.stackp].get(this.stack[this.stackp]));
                        int n = this.stackp;
                        this.stack[n] = this.stack[n] + 1;
                        for (int i = this.stackp + 1; i < this.stack.length; ++i) {
                            position = 4 * i;
                            if (this.valuess[i].size() == 0) {
                                this.stack[i] = 0;
                                this.keyBuffer.putInt(position, -1);
                                continue;
                            }
                            this.stack[i] = 1;
                            this.keyBuffer.putInt(position, this.valuess[i].get(0));
                        }
                        this.stackp = this.stack.length - 1;
                        doAggregate = true;
                        continue;
                    }
                    --this.stackp;
                }
                this.cursor.advance();
                this.currentRowWasPartiallyAggregated = false;
            }
            this.delegate = new CloseableGrouperIterator<ByteBuffer, Row>(grouper, false, new Function<Grouper.Entry<ByteBuffer>, Row>(){

                @Override
                public Row apply(Grouper.Entry<ByteBuffer> entry) {
                    int i;
                    LinkedHashMap<String, Object> theMap = Maps.newLinkedHashMap();
                    for (i = 0; i < GroupByEngineIterator.this.selectors.length; ++i) {
                        int id = entry.getKey().getInt(4 * i);
                        if (id < 0) continue;
                        theMap.put(GroupByEngineIterator.this.query.getDimensions().get(i).getOutputName(), GroupByEngineIterator.this.selectors[i].lookupName(id));
                    }
                    for (i = 0; i < entry.getValues().length; ++i) {
                        theMap.put(GroupByEngineIterator.this.query.getAggregatorSpecs().get(i).getName(), entry.getValues()[i]);
                    }
                    return new MapBasedRow(GroupByEngineIterator.this.timestamp, theMap);
                }
            }, new Closeable(){

                @Override
                public void close() throws IOException {
                    grouper.close();
                }
            });
            return this.delegate.next();
        }

        @Override
        public boolean hasNext() {
            return this.delegate != null && this.delegate.hasNext() || !this.cursor.isDone();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            if (this.delegate != null) {
                this.delegate.close();
            }
        }
    }
}

