/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.filter;

import java.nio.ByteBuffer;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.search.search.SearchQuerySpec;
import org.apache.hive.druid.io.druid.segment.filter.SearchQueryFilter;

public class SearchQueryDimFilter
implements DimFilter {
    private final String dimension;
    private final SearchQuerySpec query;
    private final ExtractionFn extractionFn;

    public SearchQueryDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="query") SearchQuerySpec query, @JsonProperty(value="extractionFn") ExtractionFn extractionFn) {
        Preconditions.checkArgument(dimension != null, "dimension must not be null");
        Preconditions.checkArgument(query != null, "query must not be null");
        this.dimension = dimension;
        this.query = query;
        this.extractionFn = extractionFn;
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public SearchQuerySpec getQuery() {
        return this.query;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8(this.dimension);
        byte[] queryBytes = this.query.getCacheKey();
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        return ByteBuffer.allocate(3 + dimensionBytes.length + queryBytes.length + extractionFnBytes.length).put((byte)6).put(dimensionBytes).put((byte)-1).put(queryBytes).put((byte)-1).put(extractionFnBytes).array();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        return new SearchQueryFilter(this.dimension, this.query, this.extractionFn);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    public String toString() {
        return "SearchQueryDimFilter{dimension='" + this.dimension + '\'' + ", query=" + this.query + ", extractionFn='" + this.extractionFn + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchQueryDimFilter)) {
            return false;
        }
        SearchQueryDimFilter that = (SearchQueryDimFilter)o;
        if (!this.dimension.equals(that.dimension)) {
            return false;
        }
        if (!this.query.equals(that.query)) {
            return false;
        }
        return this.extractionFn != null ? this.extractionFn.equals(that.extractionFn) : that.extractionFn == null;
    }

    public int hashCode() {
        int result = this.dimension.hashCode();
        result = 31 * result + this.query.hashCode();
        result = 31 * result + (this.extractionFn != null ? this.extractionFn.hashCode() : 0);
        return result;
    }
}

