/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.filter;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.ImmutableSortedSet;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Range;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.com.google.common.collect.TreeRangeSet;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.DruidLongPredicate;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.query.filter.SelectorDimFilter;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractionFn;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.io.druid.segment.filter.InFilter;

public class InDimFilter
implements DimFilter {
    public static final int LONG_HASHING_THRESHOLD = 16;
    private final ImmutableSortedSet<String> values;
    private final String dimension;
    private final ExtractionFn extractionFn;
    private final Supplier<DruidLongPredicate> longPredicateSupplier;

    @JsonCreator
    public InDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="values") List<String> values, @JsonProperty(value="extractionFn") ExtractionFn extractionFn) {
        Preconditions.checkNotNull(dimension, "dimension can not be null");
        Preconditions.checkArgument(values != null && !values.isEmpty(), "values can not be null or empty");
        this.values = ImmutableSortedSet.copyOf(Iterables.transform(values, new Function<String, String>(){

            @Override
            public String apply(String input) {
                return Strings.nullToEmpty(input);
            }
        }));
        this.dimension = dimension;
        this.extractionFn = extractionFn;
        this.longPredicateSupplier = this.getLongPredicateSupplier();
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public Set<String> getValues() {
        return this.values;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8(this.dimension);
        byte[][] valuesBytes = new byte[this.values.size()][];
        int valuesBytesSize = 0;
        int index = 0;
        for (String value : this.values) {
            valuesBytes[index] = StringUtils.toUtf8(Strings.nullToEmpty(value));
            valuesBytesSize += valuesBytes[index].length + 1;
            ++index;
        }
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        ByteBuffer filterCacheKey = ByteBuffer.allocate(3 + dimensionBytes.length + valuesBytesSize + extractionFnBytes.length).put((byte)9).put(dimensionBytes).put((byte)-1).put(extractionFnBytes).put((byte)-1);
        for (byte[] bytes : valuesBytes) {
            filterCacheKey.put(bytes).put((byte)-1);
        }
        return filterCacheKey.array();
    }

    @Override
    public DimFilter optimize() {
        InDimFilter inFilter = this.optimizeLookup();
        if (inFilter.values.size() == 1) {
            return new SelectorDimFilter(inFilter.dimension, inFilter.values.first(), inFilter.getExtractionFn());
        }
        return inFilter;
    }

    private InDimFilter optimizeLookup() {
        if (this.extractionFn instanceof LookupExtractionFn && ((LookupExtractionFn)this.extractionFn).isOptimize()) {
            LookupExtractionFn exFn = (LookupExtractionFn)this.extractionFn;
            LookupExtractor lookup = exFn.getLookup();
            ArrayList<String> keys = new ArrayList<String>();
            for (String value : this.values) {
                String convertedValue = Strings.emptyToNull(value);
                if (!exFn.isRetainMissingValue() && Objects.equals(convertedValue, exFn.getReplaceMissingValueWith())) {
                    return this;
                }
                keys.addAll(lookup.unapply(convertedValue));
                if (!exFn.isRetainMissingValue() || lookup.apply(convertedValue) != null) continue;
                keys.add(convertedValue);
            }
            if (keys.isEmpty()) {
                return this;
            }
            return new InDimFilter(this.dimension, keys, null);
        }
        return this;
    }

    @Override
    public Filter toFilter() {
        return new InFilter(this.dimension, this.values, this.longPredicateSupplier, this.extractionFn);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        if (!Objects.equals(this.getDimension(), dimension) || this.getExtractionFn() != null) {
            return null;
        }
        TreeRangeSet<String> retSet = TreeRangeSet.create();
        for (String value : this.values) {
            retSet.add(Range.singleton(Strings.nullToEmpty(value)));
        }
        return retSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InDimFilter that = (InDimFilter)o;
        if (this.values != null ? !this.values.equals(that.values) : that.values != null) {
            return false;
        }
        if (!this.dimension.equals(that.dimension)) {
            return false;
        }
        return this.extractionFn != null ? this.extractionFn.equals(that.extractionFn) : that.extractionFn == null;
    }

    public int hashCode() {
        int result = this.values != null ? this.values.hashCode() : 0;
        result = 31 * result + this.dimension.hashCode();
        result = 31 * result + (this.extractionFn != null ? this.extractionFn.hashCode() : 0);
        return result;
    }

    private Supplier<DruidLongPredicate> getLongPredicateSupplier() {
        return new Supplier<DruidLongPredicate>(){
            private final Object initLock = new Object();
            private volatile boolean longsInitialized = false;
            private volatile boolean useLongHash;
            private volatile long[] longArray;
            private volatile HashSet<Long> longHashSet;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void initLongValues() {
                if (this.longsInitialized) {
                    return;
                }
                Object object = this.initLock;
                synchronized (object) {
                    if (this.longsInitialized) {
                        return;
                    }
                    ArrayList<Long> longs = new ArrayList<Long>();
                    for (String value : InDimFilter.this.values) {
                        Long longValue = Longs.tryParse(value);
                        if (longValue == null) continue;
                        longs.add(longValue);
                    }
                    boolean bl = this.useLongHash = longs.size() > 16;
                    if (this.useLongHash) {
                        this.longHashSet = new HashSet(longs);
                    } else {
                        this.longArray = new long[longs.size()];
                        for (int i = 0; i < longs.size(); ++i) {
                            this.longArray[i] = (Long)longs.get(i);
                        }
                        Arrays.sort(this.longArray);
                    }
                    this.longsInitialized = true;
                }
            }

            @Override
            public DruidLongPredicate get() {
                this.initLongValues();
                if (this.useLongHash) {
                    return new DruidLongPredicate(){

                        @Override
                        public boolean applyLong(long input) {
                            return longHashSet.contains(input);
                        }
                    };
                }
                return new DruidLongPredicate(){

                    @Override
                    public boolean applyLong(long input) {
                        return Arrays.binarySearch(longArray, input) >= 0;
                    }
                };
            }
        };
    }
}

