/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.dimension;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;
import org.apache.hive.druid.io.druid.segment.data.ListBasedIndexedInts;

public abstract class BaseFilteredDimensionSpec
implements DimensionSpec {
    protected final DimensionSpec delegate;

    public BaseFilteredDimensionSpec(@JsonProperty(value="delegate") DimensionSpec delegate) {
        this.delegate = Preconditions.checkNotNull(delegate, "delegate must not be null");
    }

    @JsonProperty
    public DimensionSpec getDelegate() {
        return this.delegate;
    }

    @Override
    public String getDimension() {
        return this.delegate.getDimension();
    }

    @Override
    public String getOutputName() {
        return this.delegate.getOutputName();
    }

    @Override
    public ExtractionFn getExtractionFn() {
        return this.delegate.getExtractionFn();
    }

    @Override
    public boolean preservesOrdering() {
        return this.delegate.preservesOrdering();
    }

    protected static DimensionSelector decorate(final DimensionSelector selector, final Map<Integer, Integer> forwardMapping, final int[] reverseMapping) {
        if (selector == null) {
            return selector;
        }
        return new DimensionSelector(){

            @Override
            public IndexedInts getRow() {
                IndexedInts baseRow = selector.getRow();
                ArrayList<Integer> result = new ArrayList<Integer>(baseRow.size());
                Iterator iterator = baseRow.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    if (!forwardMapping.containsKey(i)) continue;
                    result.add((Integer)forwardMapping.get(i));
                }
                return new ListBasedIndexedInts(result);
            }

            @Override
            public int getValueCardinality() {
                return forwardMapping.size();
            }

            @Override
            public String lookupName(int id) {
                return selector.lookupName(reverseMapping[id]);
            }

            @Override
            public int lookupId(String name) {
                return (Integer)forwardMapping.get(selector.lookupId(name));
            }
        };
    }
}

